<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('jemaat', function (Blueprint $table) {
            $table->string('tempat_lahir')->nullable()->after('tanggal_lahir');
            $table->enum('status', ['pending', 'aktif', 'ditolak'])->default('pending')->after('aktif');
            $table->string('kode')->nullable()->after('id');
        });
    }

    public function down(): void
    {
        Schema::table('jemaat', function (Blueprint $table) {
            $table->dropColumn(['tempat_lahir', 'status', 'kode']);
        });
    }
};
