<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        // Create Admin User
        User::firstOrCreate(
            ['email' => 'admin@gereja.org'],
            [
                'name' => 'Admin Gereja',
                'password' => Hash::make('password123'),
                'role' => 'admin',
                'is_active' => true,
            ]
        );

        User::firstOrCreate(
            ['email' => 'pendeta@gereja.org'],
            [
                'name' => 'Pdt. Yohanes',
                'password' => Hash::make('password123'),
                'role' => 'pendeta',
                'is_active' => true,
            ]
        );

        // Call all seeders
        $this->call([
            ProfilGerejaSeeder::class,
            PendetaSeeder::class,
            MajelisSeeder::class,
            OigSeeder::class,
            JadwalIbadahSeeder::class,
            KegiatanSeeder::class,
            PengumumanSeeder::class,
            KeuanganSeeder::class,
            KomunikasiSeeder::class,
            JemaatSeeder::class,
        ]);
    }
}
