<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\JadwalIbadah;

class JadwalIbadahSeeder extends Seeder
{
    public function run(): void
    {
        // Jadwal Mingguan
        $jadwalMingguan = [
            ['nama' => 'Ibadah Minggu Pagi', 'hari' => 'Minggu', 'waktu' => '09:00', 'tempat' => 'Gedung Gereja', 'pelayan' => 'Pdt. Yohanes', 'online' => true, 'tipe' => 'mingguan'],
            ['nama' => 'Ibadah Minggu Sore', 'hari' => 'Minggu', 'waktu' => '17:00', 'tempat' => 'Gedung Gereja', 'pelayan' => 'Pdt. Maria', 'online' => false, 'tipe' => 'mingguan'],
            ['nama' => 'Persekutuan Doa', 'hari' => 'Rabu', 'waktu' => '18:00', 'tempat' => 'Ruang Doa', 'pelayan' => 'Pdt. Yohanes', 'online' => true, 'tipe' => 'mingguan'],
            ['nama' => 'Sekolah Minggu', 'hari' => 'Minggu', 'waktu' => '08:00', 'tempat' => 'Ruang SM', 'pelayan' => 'Tim SM', 'online' => false, 'tipe' => 'mingguan'],
        ];

        foreach ($jadwalMingguan as $data) {
            JadwalIbadah::create($data);
        }

        // Jadwal Khusus
        $jadwalKhusus = [
            ['nama' => 'Ibadah Malam Natal', 'hari' => 'Selasa', 'waktu' => '20:00', 'tempat' => 'Gedung Gereja', 'pelayan' => 'Pdt. Yohanes', 'tipe' => 'khusus', 'kategori' => 'Natal', 'tanggal' => '2024-12-24'],
            ['nama' => 'Ibadah Hari Natal', 'hari' => 'Rabu', 'waktu' => '09:00', 'tempat' => 'Gedung Gereja', 'pelayan' => 'Pdt. Maria', 'tipe' => 'khusus', 'kategori' => 'Natal', 'tanggal' => '2024-12-25'],
            ['nama' => 'Ibadah Tahun Baru', 'hari' => 'Rabu', 'waktu' => '09:00', 'tempat' => 'Gedung Gereja', 'pelayan' => 'Pdt. Yohanes', 'tipe' => 'khusus', 'kategori' => 'Tahun Baru', 'tanggal' => '2025-01-01'],
        ];

        foreach ($jadwalKhusus as $data) {
            JadwalIbadah::create($data);
        }
    }
}
