<?php

namespace Database\Seeders;

use App\Models\Jemaat;
use Illuminate\Database\Seeder;

class JemaatSeeder extends Seeder
{
    public function run(): void
    {
        $alamatRantepao = [
            'Jl. Pongtiku No. 12, Rantepao, Toraja Utara',
            'Jl. Mappanyukki No. 8, Rantepao, Toraja Utara',
            'Jl. Ahmad Yani No. 25, Rantepao, Toraja Utara',
            'Jl. Diponegoro No. 15, Rantepao, Toraja Utara',
            'Jl. Landorundun No. 7, Rantepao, Toraja Utara',
            'Jl. Poros Palopo No. 45, Rantepao, Toraja Utara',
            'Jl. Sesean No. 3, Rantepao, Toraja Utara',
            'Kelurahan Tallunglipu, Rantepao, Toraja Utara',
            'Kelurahan Rante Kalua, Rantepao, Toraja Utara',
            'Kelurahan Karassik, Rantepao, Toraja Utara',
            'Lembang Bori, Rantepao, Toraja Utara',
            'Lembang Nanggala, Rantepao, Toraja Utara',
            'Lembang Tikala, Rantepao, Toraja Utara',
            'Lembang Sa\'dan, Rantepao, Toraja Utara',
            'Jl. Pasar Bolu No. 18, Rantepao, Toraja Utara',
            'Jl. Ke\'te Kesu No. 5, Rantepao, Toraja Utara',
            'Jl. Batutumonga No. 22, Rantepao, Toraja Utara',
            'Jl. Londa No. 9, Rantepao, Toraja Utara',
            'Lembang Palawa, Rantepao, Toraja Utara',
            'Lembang Baruppu, Rantepao, Toraja Utara',
        ];

        $jemaatData = [
            ['nama' => 'Markus Paembonan', 'jenis_kelamin' => 'L', 'tempat_lahir' => 'Rantepao', 'tanggal_lahir' => '1985-03-15', 'status_pernikahan' => 'Menikah', 'pekerjaan' => 'Petani'],
            ['nama' => 'Maria Limbong', 'jenis_kelamin' => 'P', 'tempat_lahir' => 'Makale', 'tanggal_lahir' => '1990-07-22', 'status_pernikahan' => 'Menikah', 'pekerjaan' => 'Guru'],
            ['nama' => 'Yohanes Sulo', 'jenis_kelamin' => 'L', 'tempat_lahir' => 'Rantepao', 'tanggal_lahir' => '1978-11-08', 'status_pernikahan' => 'Menikah', 'pekerjaan' => 'Wiraswasta'],
            ['nama' => 'Elisabeth Tandilino', 'jenis_kelamin' => 'P', 'tempat_lahir' => 'Toraja', 'tanggal_lahir' => '1995-02-14', 'status_pernikahan' => 'Belum Menikah', 'pekerjaan' => 'Perawat'],
            ['nama' => 'Petrus Rante', 'jenis_kelamin' => 'L', 'tempat_lahir' => 'Rantepao', 'tanggal_lahir' => '1982-09-30', 'status_pernikahan' => 'Menikah', 'pekerjaan' => 'PNS'],
            ['nama' => 'Sarah Palimbong', 'jenis_kelamin' => 'P', 'tempat_lahir' => 'Sa\'dan', 'tanggal_lahir' => '1988-05-19', 'status_pernikahan' => 'Menikah', 'pekerjaan' => 'Ibu Rumah Tangga'],
            ['nama' => 'Daniel Allo', 'jenis_kelamin' => 'L', 'tempat_lahir' => 'Rantepao', 'tanggal_lahir' => '1970-12-25', 'status_pernikahan' => 'Menikah', 'pekerjaan' => 'Pendeta'],
            ['nama' => 'Ruth Sarira', 'jenis_kelamin' => 'P', 'tempat_lahir' => 'Makale', 'tanggal_lahir' => '1992-08-11', 'status_pernikahan' => 'Belum Menikah', 'pekerjaan' => 'Mahasiswa'],
            ['nama' => 'Samuel Toding', 'jenis_kelamin' => 'L', 'tempat_lahir' => 'Rantepao', 'tanggal_lahir' => '1980-04-07', 'status_pernikahan' => 'Menikah', 'pekerjaan' => 'Pedagang'],
            ['nama' => 'Naomi Lamba', 'jenis_kelamin' => 'P', 'tempat_lahir' => 'Toraja', 'tanggal_lahir' => '1975-01-28', 'status_pernikahan' => 'Janda', 'pekerjaan' => 'Petani'],
            ['nama' => 'Paulus Mangiding', 'jenis_kelamin' => 'L', 'tempat_lahir' => 'Rantepao', 'tanggal_lahir' => '1998-06-03', 'status_pernikahan' => 'Belum Menikah', 'pekerjaan' => 'Mahasiswa'],
            ['nama' => 'Debora Parinding', 'jenis_kelamin' => 'P', 'tempat_lahir' => 'Nanggala', 'tanggal_lahir' => '1983-10-16', 'status_pernikahan' => 'Menikah', 'pekerjaan' => 'Bidan'],
            ['nama' => 'Yakobus Sampetoding', 'jenis_kelamin' => 'L', 'tempat_lahir' => 'Rantepao', 'tanggal_lahir' => '1965-07-09', 'status_pernikahan' => 'Menikah', 'pekerjaan' => 'Pensiunan'],
            ['nama' => 'Esther Tarrapa', 'jenis_kelamin' => 'P', 'tempat_lahir' => 'Tikala', 'tanggal_lahir' => '1993-03-21', 'status_pernikahan' => 'Belum Menikah', 'pekerjaan' => 'Karyawan Swasta'],
            ['nama' => 'Andreas Paranoan', 'jenis_kelamin' => 'L', 'tempat_lahir' => 'Rantepao', 'tanggal_lahir' => '1987-11-12', 'status_pernikahan' => 'Menikah', 'pekerjaan' => 'Sopir'],
            ['nama' => 'Lidya Pasang', 'jenis_kelamin' => 'P', 'tempat_lahir' => 'Makale', 'tanggal_lahir' => '1979-08-05', 'status_pernikahan' => 'Menikah', 'pekerjaan' => 'Guru'],
            ['nama' => 'Stefanus Bua', 'jenis_kelamin' => 'L', 'tempat_lahir' => 'Rantepao', 'tanggal_lahir' => '2000-02-29', 'status_pernikahan' => 'Belum Menikah', 'pekerjaan' => 'Pelajar'],
            ['nama' => 'Priskila Tangke', 'jenis_kelamin' => 'P', 'tempat_lahir' => 'Baruppu', 'tanggal_lahir' => '1991-09-17', 'status_pernikahan' => 'Menikah', 'pekerjaan' => 'Wiraswasta'],
            ['nama' => 'Tomas Layuk', 'jenis_kelamin' => 'L', 'tempat_lahir' => 'Rantepao', 'tanggal_lahir' => '1973-04-24', 'status_pernikahan' => 'Duda', 'pekerjaan' => 'Tukang Kayu'],
            ['nama' => 'Hana Soreang', 'jenis_kelamin' => 'P', 'tempat_lahir' => 'Palawa', 'tanggal_lahir' => '1996-12-08', 'status_pernikahan' => 'Belum Menikah', 'pekerjaan' => 'Perawat'],
        ];

        foreach ($jemaatData as $index => $data) {
            $telepon = '08' . rand(11, 99) . rand(1000, 9999) . rand(100, 999);
            
            Jemaat::create([
                'kode' => Jemaat::generateKode(),
                'nama' => $data['nama'],
                'jenis_kelamin' => $data['jenis_kelamin'],
                'tempat_lahir' => $data['tempat_lahir'],
                'tanggal_lahir' => $data['tanggal_lahir'],
                'alamat' => $alamatRantepao[$index],
                'telepon' => $telepon,
                'email' => strtolower(str_replace(' ', '.', $data['nama'])) . '@gmail.com',
                'status_pernikahan' => $data['status_pernikahan'],
                'pekerjaan' => $data['pekerjaan'],
                'aktif' => true,
                'status' => 'aktif',
            ]);
        }

        $this->command->info('20 data jemaat berhasil ditambahkan!');
    }
}
