<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Kegiatan;

class KegiatanSeeder extends Seeder
{
    public function run(): void
    {
        $kegiatanRutin = [
            [
                'nama' => 'Persekutuan Doa',
                'slug' => 'persekutuan-doa',
                'deskripsi' => 'Persekutuan doa bersama untuk mendoakan jemaat, gereja, dan bangsa.',
                'jadwal' => 'Setiap Rabu, 18:00',
                'waktu' => '18:00 WIB',
                'tempat' => 'Ruang Doa Gereja',
                'tipe' => 'rutin',
            ],
            [
                'nama' => 'Pendalaman Alkitab',
                'slug' => 'pendalaman-alkitab',
                'deskripsi' => 'Studi Alkitab bersama untuk memahami Firman Tuhan lebih dalam.',
                'jadwal' => 'Setiap Jumat, 19:00',
                'waktu' => '19:00 WIB',
                'tempat' => 'Gedung Gereja',
                'tipe' => 'rutin',
            ],
            [
                'nama' => 'Kunjungan Jemaat',
                'slug' => 'kunjungan-jemaat',
                'deskripsi' => 'Mengunjungi jemaat yang sakit atau membutuhkan pelayanan.',
                'jadwal' => 'Setiap Sabtu',
                'waktu' => '10:00 WIB',
                'tempat' => 'Rumah Jemaat',
                'tipe' => 'rutin',
            ],
        ];

        foreach ($kegiatanRutin as $data) {
            Kegiatan::create($data);
        }

        $kegiatanKhusus = [
            [
                'nama' => 'Perayaan Natal',
                'slug' => 'perayaan-natal',
                'deskripsi' => 'Perayaan Natal bersama seluruh jemaat.',
                'waktu' => '09:00 WIB',
                'tempat' => 'Gedung Gereja',
                'tipe' => 'khusus',
                'kategori' => 'Natal',
                'tanggal' => '2024-12-25',
            ],
            [
                'nama' => 'Malam Tahun Baru',
                'slug' => 'malam-tahun-baru',
                'deskripsi' => 'Ibadah tutup tahun dan doa syukur.',
                'waktu' => '21:00 WIB',
                'tempat' => 'Gedung Gereja',
                'tipe' => 'khusus',
                'kategori' => 'Tahun Baru',
                'tanggal' => '2024-12-31',
            ],
            [
                'nama' => 'Retreat Pemuda',
                'slug' => 'retreat-pemuda',
                'deskripsi' => 'Retret rohani pemuda untuk penguatan iman.',
                'waktu' => '08:00 WIB',
                'tempat' => 'Villa Rantepao',
                'tipe' => 'khusus',
                'kategori' => 'Pemuda',
                'tanggal' => '2025-01-05',
            ],
            [
                'nama' => 'Seminar Keluarga',
                'slug' => 'seminar-keluarga',
                'deskripsi' => 'Seminar pembinaan keluarga Kristen.',
                'waktu' => '09:00 WIB',
                'tempat' => 'Gedung Gereja',
                'tipe' => 'khusus',
                'kategori' => 'Keluarga',
                'tanggal' => '2025-01-12',
            ],
        ];

        foreach ($kegiatanKhusus as $data) {
            Kegiatan::create($data);
        }
    }
}
