<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Keuangan;

class KeuanganSeeder extends Seeder
{
    public function run(): void
    {
        $periode = 'Desember 2024';

        // Pemasukan
        $pemasukan = [
            ['keterangan' => 'Persembahan Mingguan', 'jumlah' => 15000000],
            ['keterangan' => 'Persembahan Syukur', 'jumlah' => 5000000],
            ['keterangan' => 'Dana Diakonia', 'jumlah' => 3000000],
            ['keterangan' => 'Dana Pembangunan', 'jumlah' => 2000000],
        ];

        foreach ($pemasukan as $data) {
            Keuangan::create([
                'tipe' => 'pemasukan',
                'keterangan' => $data['keterangan'],
                'jumlah' => $data['jumlah'],
                'tanggal' => '2024-12-20',
                'periode' => $periode,
            ]);
        }

        // Pengeluaran
        $pengeluaran = [
            ['keterangan' => 'Operasional Gereja', 'jumlah' => 8000000],
            ['keterangan' => 'Listrik & Air', 'jumlah' => 2000000],
            ['keterangan' => 'Dana Diakonia', 'jumlah' => 3000000],
            ['keterangan' => 'Kegiatan Natal', 'jumlah' => 5000000],
        ];

        foreach ($pengeluaran as $data) {
            Keuangan::create([
                'tipe' => 'pengeluaran',
                'keterangan' => $data['keterangan'],
                'jumlah' => $data['jumlah'],
                'tanggal' => '2024-12-20',
                'periode' => $periode,
            ]);
        }

        // Data bulan sebelumnya untuk chart
        $bulanSebelumnya = [
            ['periode' => 'Oktober 2024', 'pemasukan' => 17500000, 'pengeluaran' => 12500000],
            ['periode' => 'November 2024', 'pemasukan' => 21250000, 'pengeluaran' => 16250000],
        ];

        foreach ($bulanSebelumnya as $bulan) {
            Keuangan::create([
                'tipe' => 'pemasukan',
                'keterangan' => 'Total Pemasukan',
                'jumlah' => $bulan['pemasukan'],
                'tanggal' => '2024-' . ($bulan['periode'] == 'Oktober 2024' ? '10' : '11') . '-01',
                'periode' => $bulan['periode'],
            ]);
            Keuangan::create([
                'tipe' => 'pengeluaran',
                'keterangan' => 'Total Pengeluaran',
                'jumlah' => $bulan['pengeluaran'],
                'tanggal' => '2024-' . ($bulan['periode'] == 'Oktober 2024' ? '10' : '11') . '-01',
                'periode' => $bulan['periode'],
            ]);
        }
    }
}
