<?php

namespace Database\Seeders;

use App\Models\Komunikasi;
use Illuminate\Database\Seeder;

class KomunikasiSeeder extends Seeder
{
    public function run(): void
    {
        Komunikasi::insert([
            [
                'nama' => 'Ibadah Minggu Pagi',
                'deskripsi' => 'Live streaming ibadah minggu',
                'hari' => 'Minggu',
                'tanggal' => '2024-12-22',
                'waktu' => '09:00',
                'platform' => 'Zoom & Meet',
                'zoom_link' => 'https://zoom.us/j/1234567890',
                'meet_link' => 'https://meet.google.com/abc-defg-hij',
                'is_active' => false,
                'catatan' => null,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'nama' => 'Persekutuan Doa',
                'deskripsi' => 'Persekutuan doa mingguan',
                'hari' => 'Rabu',
                'tanggal' => '2024-12-25',
                'waktu' => '18:00',
                'platform' => 'Zoom',
                'zoom_link' => 'https://zoom.us/j/0987654321',
                'meet_link' => null,
                'is_active' => false,
                'catatan' => null,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'nama' => 'Ibadah Natal',
                'deskripsi' => 'Perayaan Natal bersama',
                'hari' => 'Rabu',
                'tanggal' => '2024-12-25',
                'waktu' => '09:00',
                'platform' => 'Zoom & Meet',
                'zoom_link' => 'https://zoom.us/j/1111111111',
                'meet_link' => 'https://meet.google.com/nat-alge-reja',
                'is_active' => true,
                'catatan' => 'Siapkan choir',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }
}
