<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Oig;

class OigSeeder extends Seeder
{
    public function run(): void
    {
        $oigData = [
            [
                'nama' => 'Sekolah Minggu',
                'slug' => 'sekolah-minggu',
                'deskripsi' => 'Wadah pembinaan iman anak-anak gereja melalui pengajaran Firman Tuhan yang kreatif dan menyenangkan.',
                'ketua' => 'Ibu Sarah',
                'jadwal' => 'Minggu, 08:00 WIB',
                'pengurus' => ['Ketua' => 'Ibu Sarah', 'Wakil Ketua' => 'Bpk. Petrus', 'Sekretaris' => 'Ibu Ruth', 'Bendahara' => 'Ibu Ester'],
            ],
            [
                'nama' => 'Persekutuan Pemuda',
                'slug' => 'pemuda',
                'deskripsi' => 'Wadah persekutuan dan pelayanan bagi pemuda-pemudi gereja untuk bertumbuh dalam iman dan pelayanan.',
                'ketua' => 'Sdr. Daniel',
                'jadwal' => 'Sabtu, 18:00 WIB',
                'pengurus' => ['Ketua' => 'Sdr. Daniel', 'Wakil Ketua' => 'Sdri. Priska', 'Sekretaris' => 'Sdr. Timothy', 'Bendahara' => 'Sdri. Esther'],
            ],
            [
                'nama' => 'Persekutuan Kaum Ibu',
                'slug' => 'kaum-ibu',
                'deskripsi' => 'Wadah persekutuan dan pembinaan rohani bagi para ibu dalam jemaat.',
                'ketua' => 'Ibu Naomi',
                'jadwal' => 'Kamis, 10:00 WIB',
                'pengurus' => ['Ketua' => 'Ibu Naomi', 'Wakil Ketua' => 'Ibu Debora', 'Sekretaris' => 'Ibu Lydia', 'Bendahara' => 'Ibu Priska'],
            ],
            [
                'nama' => 'Persekutuan Kaum Bapak',
                'slug' => 'kaum-bapak',
                'deskripsi' => 'Wadah persekutuan dan pembinaan rohani bagi para bapak dalam jemaat.',
                'ketua' => 'Bpk. Abraham',
                'jadwal' => 'Jumat, 19:00 WIB',
                'pengurus' => ['Ketua' => 'Bpk. Abraham', 'Wakil Ketua' => 'Bpk. Ishak', 'Sekretaris' => 'Bpk. Yakub', 'Bendahara' => 'Bpk. Yusuf'],
            ],
        ];

        foreach ($oigData as $data) {
            Oig::create($data);
        }
    }
}
