<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Pengumuman;

class PengumumanSeeder extends Seeder
{
    public function run(): void
    {
        Pengumuman::truncate();

        $pengumuman = [
            [
                'judul' => 'Ibadah Syukuran Tahun Baru 2025',
                'deskripsi' => 'Ibadah Syukuran Tahun Baru akan diadakan pada tanggal 1 Januari 2025 pukul 10:00 WITA di Gedung Gereja. Mari bersama-sama mengucap syukur atas penyertaan Tuhan di tahun yang baru.',
                'tanggal' => '2025-01-01',
                'aktif' => true,
            ],
            [
                'judul' => 'Pendaftaran Sekolah Minggu Semester Genap 2025',
                'deskripsi' => 'Pendaftaran Sekolah Minggu untuk semester genap tahun 2025 telah dibuka. Bagi orang tua yang ingin mendaftarkan anak-anaknya, silakan hubungi sekretariat gereja atau daftar langsung setiap hari Minggu.',
                'tanggal' => '2025-01-05',
                'aktif' => true,
            ],
            [
                'judul' => 'Persekutuan Doa Awal Tahun',
                'deskripsi' => 'Persekutuan doa rutin setiap Rabu malam pukul 18:00 WITA akan dimulai kembali tanggal 8 Januari 2025. Seluruh jemaat diundang untuk hadir dan bersama-sama mendoakan pelayanan gereja di tahun baru.',
                'tanggal' => '2025-01-08',
                'aktif' => true,
            ],
        ];

        foreach ($pengumuman as $data) {
            Pengumuman::create($data);
        }
    }
}
