@extends('layouts.admin')

@section('title', isset($berita) ? 'Edit Berita' : 'Tambah Berita')
@section('page-title', isset($berita) ? 'Edit Berita' : 'Tambah Berita')

@section('content')
    <div class="max-w-3xl">
        <!-- Back Button -->
        <a href="{{ route('admin.berita.index') }}"
            class="inline-flex items-center gap-2 text-slate-600 hover:text-[#1e3a5f] font-medium mb-5 transition-colors duration-200">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
            </svg>
            Kembali ke Daftar Berita
        </a>

        <div class="bg-white rounded-2xl shadow-admin-md border border-slate-100 p-6">
            <div class="flex items-center gap-3 mb-6">
                <div
                    class="w-12 h-12 rounded-xl bg-gradient-to-br from-blue-100 to-blue-50 flex items-center justify-center">
                    <svg class="w-6 h-6 text-[#1e3a5f]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                            d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z" />
                    </svg>
                </div>
                <div>
                    <h2 class="text-xl font-bold text-[#1e3a5f]">{{ isset($berita) ? 'Edit Berita' : 'Tulis Berita Baru' }}
                    </h2>
                    <p class="text-sm text-slate-500">
                        {{ isset($berita) ? 'Perbarui informasi berita' : 'Lengkapi form di bawah untuk membuat berita' }}
                    </p>
                </div>
            </div>

            <form action="{{ isset($berita) ? route('admin.berita.update', $berita->id) : route('admin.berita.store') }}"
                method="POST" enctype="multipart/form-data" class="space-y-5" id="beritaForm">
                @csrf
                @if(isset($berita))
                    @method('PUT')
                @endif

                <!-- Judul -->
                <div>
                    <label class="block text-slate-700 font-semibold text-[15px] mb-2">Judul Berita *</label>
                    <input type="text" name="judul" value="{{ $berita->judul ?? old('judul') }}" required
                        class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-[#1e3a5f] focus:bg-white focus:outline-none transition-all duration-200"
                        placeholder="Masukkan judul berita...">
                    @error('judul')
                        <p class="text-sm text-rose-500 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Ringkasan -->
                <div>
                    <label class="block text-slate-700 font-semibold text-[15px] mb-2">Ringkasan (Opsional)</label>
                    <textarea name="ringkasan" rows="2"
                        class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-[#1e3a5f] focus:bg-white focus:outline-none transition-all duration-200"
                        placeholder="Ringkasan singkat berita... (maksimal 500 karakter)">{{ $berita->ringkasan ?? old('ringkasan') }}</textarea>
                    <p class="text-xs text-slate-400 mt-1">Jika kosong, akan diambil dari 150 karakter pertama isi berita
                    </p>
                </div>

                <!-- Isi Berita dengan Quill Editor -->
                <div>
                    <label class="block text-slate-700 font-semibold text-[15px] mb-2">
                        <span class="flex items-center gap-2">
                            <svg class="w-5 h-5 text-[#d4af37]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                            </svg>
                            Isi Berita *
                        </span>
                    </label>

                    <!-- Quill Editor Container -->
                    <div id="editor-container"></div>

                    <!-- Hidden input untuk menyimpan konten -->
                    <input type="hidden" name="isi" id="isi-input">

                    @error('isi')
                        <p class="text-sm text-rose-500 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Gambar -->
                <div class="bg-slate-50 rounded-xl p-5 border border-slate-200">
                    <label class="block text-slate-700 font-semibold text-[15px] mb-3">
                        <span class="flex items-center gap-2">
                            <svg class="w-5 h-5 text-[#d4af37]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                            </svg>
                            Gambar Utama (Opsional)
                        </span>
                    </label>

                    @if(isset($berita) && $berita->gambar)
                        <div class="mb-4">
                            <p class="text-sm text-slate-500 mb-2">Gambar saat ini:</p>
                            <img src="{{ asset('images/' . $berita->gambar) }}" alt="{{ $berita->judul }}"
                                class="w-48 h-32 object-cover rounded-xl border border-slate-200">
                        </div>
                    @endif

                    <input type="file" name="gambar" accept="image/jpeg,image/png,image/jpg,image/webp"
                        class="w-full px-4 py-3 bg-white border-2 border-dashed border-slate-300 rounded-xl text-[15px] focus:border-[#1e3a5f] focus:outline-none transition-all duration-200 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-semibold file:bg-[#1e3a5f] file:text-white hover:file:bg-[#2d5a8a]">
                    <p class="text-xs text-slate-400 mt-2">Format: JPG, PNG, WebP. Maksimal 2MB. Rekomendasi: 1200x630
                        piksel</p>
                    @error('gambar')
                        <p class="text-sm text-rose-500 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Tanggal & Status -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                    <div>
                        <label class="block text-slate-700 font-semibold text-[15px] mb-2">Tanggal Publikasi *</label>
                        <input type="date" name="tanggal_publikasi"
                            value="{{ isset($berita) ? $berita->tanggal_publikasi->format('Y-m-d') : old('tanggal_publikasi', date('Y-m-d')) }}"
                            required
                            class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-[#1e3a5f] focus:bg-white focus:outline-none transition-all duration-200">
                    </div>
                    <div>
                        <label class="block text-slate-700 font-semibold text-[15px] mb-2">Status *</label>
                        <select name="status" required
                            class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-[#1e3a5f] focus:bg-white focus:outline-none transition-all duration-200">
                            <option value="draft" {{ (isset($berita) && $berita->status == 'draft') ? 'selected' : '' }}>Draft
                                (Simpan dulu)</option>
                            <option value="published" {{ (isset($berita) && $berita->status == 'published') ? 'selected' : '' }}>Published (Tampil di publik)</option>
                        </select>
                    </div>
                </div>

                <!-- Info Box -->
                <div class="bg-blue-50 rounded-xl p-4 border border-blue-200">
                    <div class="flex gap-3">
                        <svg class="w-5 h-5 text-blue-600 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <div class="text-sm text-blue-800">
                            <p class="font-semibold mb-1">Tips Penulisan:</p>
                            <ul class="list-disc list-inside text-blue-700 space-y-1">
                                <li>Gunakan <strong>Heading</strong> untuk judul bagian dalam artikel</li>
                                <li>Gunakan <strong>Bold</strong> dan <strong>Italic</strong> untuk penekanan</li>
                                <li>Gunakan tombol <strong>Link</strong> untuk menambah hyperlink</li>
                                <li>Pastikan konten mudah dibaca dengan paragraf yang rapi</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="flex items-center gap-4 pt-5 border-t border-slate-200 mt-6">
                    <button type="submit"
                        class="inline-flex items-center gap-2 px-6 py-3 bg-[#1e3a5f] text-white rounded-xl font-semibold text-[15px] hover:bg-[#2d5a8a] transition-all duration-200 shadow-admin-sm hover:shadow-admin-md">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                        </svg>
                        {{ isset($berita) ? 'Update Berita' : 'Simpan Berita' }}
                    </button>
                    <a href="{{ route('admin.berita.index') }}"
                        class="inline-flex items-center gap-2 px-6 py-3 bg-slate-100 text-slate-700 rounded-xl font-semibold text-[15px] hover:bg-slate-200 transition-all duration-200">
                        Batal
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Quill CSS -->
    <link href="https://cdn.quilljs.com/1.3.7/quill.snow.css" rel="stylesheet">

    <!-- Quill JS -->
    <script src="https://cdn.quilljs.com/1.3.7/quill.min.js"></script>

    <style>
        /* Quill Editor Custom Styling */
        #editor-container {
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            overflow: hidden;
            background: #fff;
        }

        #editor-container:focus-within {
            border-color: #1e3a5f;
        }

        .ql-toolbar.ql-snow {
            border: none !important;
            border-bottom: 1px solid #e2e8f0 !important;
            background: #f8fafc;
            padding: 12px !important;
        }

        .ql-container.ql-snow {
            border: none !important;
            font-family: 'Nunito', sans-serif;
            font-size: 16px;
        }

        .ql-editor {
            min-height: 350px;
            padding: 20px !important;
            line-height: 1.8;
            color: #334155;
        }

        .ql-editor.ql-blank::before {
            font-style: normal;
            color: #94a3b8;
            left: 20px;
        }

        .ql-editor h1,
        .ql-editor h2,
        .ql-editor h3 {
            color: #1e3a5f;
            font-weight: 700;
        }

        .ql-editor h1 {
            font-size: 2em;
            margin: 0.67em 0;
        }

        .ql-editor h2 {
            font-size: 1.5em;
            margin: 0.83em 0;
        }

        .ql-editor h3 {
            font-size: 1.17em;
            margin: 1em 0;
        }

        .ql-editor p {
            margin-bottom: 1em;
        }

        .ql-editor a {
            color: #d4af37;
        }

        .ql-editor blockquote {
            border-left: 4px solid #d4af37;
            padding-left: 16px;
            margin: 1em 0;
            color: #64748b;
        }

        .ql-editor ul,
        .ql-editor ol {
            padding-left: 1.5em;
        }

        /* Toolbar button styling */
        .ql-snow .ql-toolbar button:hover,
        .ql-snow .ql-toolbar button:focus {
            background: #e2e8f0;
            border-radius: 4px;
        }

        .ql-snow .ql-toolbar button.ql-active {
            background: #1e3a5f;
            border-radius: 4px;
        }

        .ql-snow .ql-toolbar button.ql-active .ql-stroke {
            stroke: #fff;
        }

        .ql-snow .ql-toolbar button.ql-active .ql-fill {
            fill: #fff;
        }

        .ql-snow .ql-picker-label:hover,
        .ql-snow .ql-picker-label.ql-active {
            color: #1e3a5f;
        }

        .ql-snow .ql-picker-options {
            border-radius: 8px;
            box-shadow: 0 4px 6px -1px rgb(0 0 0 / 0.1);
        }
    </style>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Konfigurasi toolbar Quill
            var toolbarOptions = [
                [{
                    'header': [1, 2, 3, false]
                }],
                ['bold', 'italic', 'underline', 'strike'],
                [{
                    'color': []
                }, {
                    'background': []
                }],
                [{
                    'align': []
                }],
                [{
                    'list': 'ordered'
                }, {
                    'list': 'bullet'
                }],
                [{
                    'indent': '-1'
                }, {
                    'indent': '+1'
                }],
                ['blockquote'],
                ['link'],
                ['clean']
            ];

            // Inisialisasi Quill
            var quill = new Quill('#editor-container', {
                modules: {
                    toolbar: toolbarOptions
                },
                placeholder: 'Tulis isi berita di sini...',
                theme: 'snow'
            });

            // Load existing content jika ada
            var existingContent = @json($berita->isi ?? old('isi') ?? '');
            if (existingContent) {
                quill.root.innerHTML = existingContent;
            }

            // Update hidden input sebelum submit
            var form = document.getElementById('beritaForm');
            form.addEventListener('submit', function (e) {
                var isiInput = document.getElementById('isi-input');
                var content = quill.root.innerHTML;

                // Jika konten hanya whitespace atau empty paragraph, set kosong
                if (content === '<p><br></p>' || content.trim() === '') {
                    isiInput.value = '';
                } else {
                    isiInput.value = content;
                }

                // Validasi manual
                if (!isiInput.value) {
                    e.preventDefault();
                    alert('Isi berita tidak boleh kosong!');
                    quill.focus();
                }
            });

            // Update hidden input saat konten berubah (untuk validasi real-time)
            quill.on('text-change', function () {
                var content = quill.root.innerHTML;
                if (content === '<p><br></p>') {
                    document.getElementById('isi-input').value = '';
                } else {
                    document.getElementById('isi-input').value = content;
                }
            });
        });
    </script>
@endsection