@extends('layouts.admin')

@section('title', isset($jadwal) ? 'Edit Ibadah Khusus' : 'Tambah Ibadah Khusus')
@section('page-title', isset($jadwal) ? 'Edit Ibadah Khusus' : 'Tambah Ibadah Khusus')

@section('content')
    <div class="max-w-3xl">
        <div class="bg-white rounded-xl shadow-md p-6">
            <form
                action="{{ isset($jadwal) ? route('admin.ibadah-khusus.update', $jadwal->id) : route('admin.ibadah-khusus.store') }}"
                method="POST" class="space-y-6">
                @csrf
                @if(isset($jadwal))
                    @method('PUT')
                @endif

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="md:col-span-2">
                        <label class="block text-gray-700 font-semibold mb-2" style="color: #1e3a5f;">Nama Ibadah / Tema
                            *</label>
                        <input type="text" name="nama" value="{{ $jadwal->nama ?? old('nama') }}" required
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                            placeholder="Contoh: Ibadah Syukur Perayaan Natal">
                    </div>

                    <div>
                        <label class="block text-gray-700 font-semibold mb-2" style="color: #1e3a5f;">Kategori</label>
                        <select name="kategori"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                            <option value="">Pilih Kategori</option>
                            <option value="Natal" {{ (isset($jadwal) && $jadwal->kategori == 'Natal') ? 'selected' : '' }}>
                                Natal</option>
                            <option value="Paskah" {{ (isset($jadwal) && $jadwal->kategori == 'Paskah') ? 'selected' : '' }}>
                                Paskah</option>
                            <option value="Perjamuan Kudus" {{ (isset($jadwal) && $jadwal->kategori == 'Perjamuan Kudus') ? 'selected' : '' }}>Perjamuan Kudus</option>
                            <option value="Pernikahan" {{ (isset($jadwal) && $jadwal->kategori == 'Pernikahan') ? 'selected' : '' }}>Pernikahan</option>
                            <option value="Dukacita" {{ (isset($jadwal) && $jadwal->kategori == 'Dukacita') ? 'selected' : '' }}>Dukacita</option>
                            <option value="Lainnya" {{ (isset($jadwal) && $jadwal->kategori == 'Lainnya') ? 'selected' : '' }}>Lainnya</option>
                        </select>
                    </div>

                    <div>
                        <label class="block text-gray-700 font-semibold mb-2" style="color: #1e3a5f;">Tanggal *</label>
                        <input type="date" name="tanggal"
                            value="{{ isset($jadwal) ? $jadwal->tanggal->format('Y-m-d') : old('tanggal') }}" required
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                    </div>

                    <div>
                        <label class="block text-gray-700 font-semibold mb-2" style="color: #1e3a5f;">Waktu *</label>
                        <input type="time" name="waktu" value="{{ $jadwal->waktu ?? old('waktu') }}" required
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                    </div>

                    <div>
                        <label class="block text-gray-700 font-semibold mb-2" style="color: #1e3a5f;">Tempat *</label>
                        <input type="text" name="tempat" value="{{ $jadwal->tempat ?? old('tempat') }}" required
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                            placeholder="Contoh: Gedung Gereja">
                    </div>

                    <div class="md:col-span-2">
                        <label class="block text-gray-700 font-semibold mb-2" style="color: #1e3a5f;">Pelayan Firman</label>
                        <input type="text" name="pelayan" value="{{ $jadwal->pelayan ?? old('pelayan') }}"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                            placeholder="Nama Pendeta / Pengkhotbah">
                    </div>

                    <!-- <div class="flex items-center space-x-6 pt-2">
                                <label class="inline-flex items-center cursor-pointer">
                                    <input type="checkbox" name="online" value="1" {{ (isset($jadwal) && $jadwal->online) ? 'checked' : '' }} class="hidden peer">
                                    <div
                                        class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600 relative">
                                    </div>
                                    <span class="ml-3 text-sm font-medium text-gray-700">Tersedia Online (Live Streaming)</span>
                                </label>

                                <label class="inline-flex items-center cursor-pointer">
                                    <input type="checkbox" name="aktif" value="1" {{ (!isset($jadwal) || $jadwal->aktif) ? 'checked' : '' }} class="hidden peer">
                                    <div
                                        class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-green-600 relative">
                                    </div>
                                    <span class="ml-3 text-sm font-medium text-gray-700">Aktif</span>
                                </label>
                            </div> -->
                </div>

                <div class="flex items-center gap-4 pt-6 ">
                    <button type="submit"
                        class="px-8 py-3 bg-gereja-biru text-white rounded-xl font-bold hover:bg-gereja-biru-light transition-all shadow-md">
                        {{ isset($jadwal) ? 'Update' : 'Simpan' }}
                    </button>
                    <a href="{{ route('admin.ibadah-khusus.index') }}"
                        class="px-8 py-3 bg-gray-200 text-gray-700 rounded-xl font-bold hover:bg-gray-300 transition-all">
                        Batal
                    </a>
                </div>
            </form>
        </div>
    </div>
@endsection