@extends('layouts.admin')

@section('title', isset($jadwal) ? 'Edit Jadwal' : 'Tambah Jadwal')
@section('page-title', isset($jadwal) ? 'Edit Jadwal Ibadah' : 'Tambah Jadwal Ibadah')

@section('content')
<div class="max-w-3xl">
    <div class="bg-white rounded-xl shadow-md p-6">
        <form action="{{ isset($jadwal) ? route('admin.jadwal.update', $jadwal['id']) : route('admin.jadwal.store') }}" method="POST" class="space-y-6">
            @csrf
            @if(isset($jadwal))
            @method('PUT')
            @endif

            <div>
                <label class="block text-gray-700 font-semibold mb-2">Nama Ibadah *</label>
                <input type="text" name="nama" value="{{ $jadwal['nama'] ?? old('nama') }}" required class="w-full px-4 py-3 border-2 border-gray-300 rounded-lg focus:border-gereja-biru focus:outline-none">
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-gray-700 font-semibold mb-2">Hari *</label>
                    <select name="hari" required class="w-full px-4 py-3 border-2 border-gray-300 rounded-lg focus:border-gereja-biru focus:outline-none">
                        <option value="">Pilih Hari</option>
                        @foreach(['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'] as $hari)
                        <option value="{{ $hari }}" {{ (isset($jadwal) && $jadwal['hari'] == $hari) ? 'selected' : '' }}>{{ $hari }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="block text-gray-700 font-semibold mb-2">Waktu *</label>
                    <input type="time" name="waktu" value="{{ $jadwal['waktu'] ?? old('waktu') }}" required class="w-full px-4 py-3 border-2 border-gray-300 rounded-lg focus:border-gereja-biru focus:outline-none">
                </div>
            </div>

            <div>
                <label class="block text-gray-700 font-semibold mb-2">Tempat *</label>
                <input type="text" name="tempat" value="{{ $jadwal['tempat'] ?? old('tempat') }}" required class="w-full px-4 py-3 border-2 border-gray-300 rounded-lg focus:border-gereja-biru focus:outline-none">
            </div>

            <div>
                <label class="block text-gray-700 font-semibold mb-2">Pelayan Firman *</label>
                <input type="text" name="pelayan" value="{{ $jadwal['pelayan'] ?? old('pelayan') }}" required class="w-full px-4 py-3 border-2 border-gray-300 rounded-lg focus:border-gereja-biru focus:outline-none">
            </div>

            <div class="flex items-center space-x-4">
                <button type="submit" class="px-8 py-3 bg-gereja-biru text-white rounded-lg font-bold hover:bg-gereja-biru-light transition">
                    {{ isset($jadwal) ? 'Update' : 'Simpan' }}
                </button>
                <a href="{{ route('admin.jadwal.index') }}" class="px-8 py-3 bg-gray-300 text-gray-700 rounded-lg font-bold hover:bg-gray-400 transition">
                    Batal
                </a>
            </div>
        </form>
    </div>
</div>
@endsection