@extends('layouts.admin')

@section('title', 'Manajemen Jadwal Ibadah')
@section('page-title', 'Manajemen Jadwal Ibadah')

@section('content')
<div class="bg-white rounded-xl shadow-md p-6">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-6">
        <h2 class="text-xl font-bold text-gereja-biru mb-4 md:mb-0">Daftar Jadwal Ibadah</h2>
        <a href="{{ route('admin.jadwal.create') }}" class="inline-flex items-center px-6 py-3 bg-gereja-biru text-white rounded-lg font-bold hover:bg-gereja-biru-light transition">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/></svg>
            Tambah Jadwal
        </a>
    </div>

    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-3 text-left text-gray-600">Nama Ibadah</th>
                    <th class="px-4 py-3 text-left text-gray-600">Hari</th>
                    <th class="px-4 py-3 text-left text-gray-600">Waktu</th>
                    <th class="px-4 py-3 text-left text-gray-600">Tempat</th>
                    <th class="px-4 py-3 text-left text-gray-600">Pelayan</th>
                    <th class="px-4 py-3 text-left text-gray-600">Aksi</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-100">
                @foreach($jadwalList as $jadwal)
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-4 font-semibold">{{ $jadwal->nama }}</td>
                    <td class="px-4 py-4">{{ $jadwal->hari }}</td>
                    <td class="px-4 py-4">{{ $jadwal->waktu }}</td>
                    <td class="px-4 py-4">{{ $jadwal->tempat }}</td>
                    <td class="px-4 py-4">{{ $jadwal->pelayan }}</td>
                    <td class="px-4 py-4">
                        <div class="flex items-center space-x-2">
                            <a href="{{ route('admin.jadwal.edit', $jadwal->id) }}" class="p-2 text-blue-600 hover:bg-blue-100 rounded-lg">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/></svg>
                            </a>
                            <form action="{{ route('admin.jadwal.destroy', $jadwal->id) }}" method="POST" onsubmit="return confirm('Yakin ingin menghapus?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="p-2 text-red-600 hover:bg-red-100 rounded-lg">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/></svg>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    
    {{ $jadwalList->links('components.pagination') }}
</div>
@endsection
