@extends('layouts.admin')

@section('title', isset($event) ? 'Edit Event' : 'Tambah Event')
@section('page-title', isset($event) ? 'Edit Event Kalender' : 'Tambah Event Kalender')

@section('content')
    <div class="max-w-3xl">
        <div class="bg-white rounded-xl shadow-md p-6">
            <form action="{{ isset($event) ? route('admin.kalender.update', $event->id) : route('admin.kalender.store') }}"
                method="POST" class="space-y-6">
                @csrf
                @if(isset($event))
                    @method('PUT')
                @endif

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Nama Event *</label>
                    <input type="text" name="nama" value="{{ $event->nama ?? old('nama') }}" required
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                        placeholder="Contoh: Ibadah Natal">
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Tanggal *</label>
                        <input type="date" name="tanggal"
                            value="{{ isset($event) ? $event->tanggal->format('Y-m-d') : old('tanggal') }}" required
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                    </div>
                    <div>
                        <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Waktu</label>
                        <input type="time" name="waktu"
                            value="{{ isset($event) ? substr($event->waktu, 0, 5) : old('waktu') }}"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Tipe Event *</label>
                    <select name="tipe" required
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                        <option value="">Pilih Tipe</option>
                        <option value="ibadah" {{ (isset($event) && $event->tipe == 'ibadah') ? 'selected' : '' }}>Ibadah
                        </option>
                        <option value="khusus" {{ (isset($event) && $event->tipe == 'khusus') ? 'selected' : '' }}>Khusus
                        </option>
                        <option value="kegiatan" {{ (isset($event) && $event->tipe == 'kegiatan') ? 'selected' : '' }}>
                            Kegiatan</option>
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Tempat</label>
                    <input type="text" name="tempat" value="{{ $event->tempat ?? old('tempat') }}"
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                        placeholder="Contoh: Gedung Gereja Utama">
                </div>

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Deskripsi</label>
                    <textarea name="deskripsi" rows="3"
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                        placeholder="Deskripsi event">{{ $event->deskripsi ?? old('deskripsi') }}</textarea>
                </div>

                <div>
                    <label class="flex items-center">
                        <input type="checkbox" name="aktif" value="1" {{ (isset($event) && $event->aktif) ? 'checked' : (!isset($event) ? 'checked' : '') }} class="w-5 h-5 mr-3 rounded border-gray-300">
                        <span class="text-sm font-semibold" style="color: #1e3a5f;">Event Aktif</span>
                    </label>
                </div>

                <div class="flex items-center gap-4 pt-4">
                    <button type="submit"
                        class="px-6 py-3 rounded-xl font-semibold transition-all shadow-material-1 hover:shadow-material-2"
                        style="background: #1e3a5f; color: #ffffff;">
                        {{ isset($event) ? 'Update Event' : 'Simpan Event' }}
                    </button>
                    <a href="{{ route('admin.kalender.index') }}"
                        class="px-6 py-3 rounded-xl font-semibold bg-gray-200 text-gray-700 hover:bg-gray-300 transition-all">
                        Batal
                    </a>
                </div>
            </form>
        </div>
    </div>
@endsection