@extends('layouts.admin')

@section('title', 'Manajemen Kalender')
@section('page-title', 'Manajemen Kalender Gereja')

@section('content')
<div class="bg-white rounded-xl shadow-md p-6">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-6">
        <div>
            <h2 class="text-xl font-bold text-gereja-biru">Kalender Gereja</h2>
            <p class="text-gray-600">Kelola agenda dan jadwal kegiatan gereja di sini.</p>
        </div>
        <a href="{{ route('admin.kalender.create') }}" class="mt-4 md:mt-0 inline-flex items-center px-6 py-3 bg-gereja-biru text-white rounded-lg font-bold hover:bg-gereja-biru-light transition">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/></svg>
            Tambah Event
        </a>
    </div>
    
    @if(count($events) > 0)
    <div class="space-y-4">
        @foreach($events as $event)
        <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg hover:bg-gray-100 transition">
            <div class="flex-grow">
                <h3 class="font-semibold text-gereja-biru">{{ $event['nama'] }}</h3>
                <p class="text-gray-500 text-sm">{{ $event['tanggal'] }} {{ $event['waktu'] ? '- ' . $event['waktu'] : '' }}</p>
                @if($event['tempat'] ?? false)
                <p class="text-gray-400 text-xs">{{ $event['tempat'] }}</p>
                @endif
            </div>
            <div class="flex items-center gap-3">
                <span class="px-3 py-1 rounded-full text-xs font-semibold {{ $event['type'] == 'ibadah' ? 'bg-blue-100 text-blue-700' : ($event['type'] == 'khusus' ? 'bg-green-100 text-green-700' : 'bg-yellow-100 text-yellow-700') }}">{{ ucfirst($event['type']) }}</span>
                <a href="{{ route('admin.kalender.edit', $event['id']) }}" class="p-2 text-blue-600 hover:bg-blue-100 rounded-lg">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/></svg>
                </a>
                <form action="{{ route('admin.kalender.destroy', $event['id']) }}" method="POST" onsubmit="return confirm('Yakin ingin menghapus event ini?')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="p-2 text-red-600 hover:bg-red-100 rounded-lg">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/></svg>
                    </button>
                </form>
            </div>
        </div>
        @endforeach
    </div>
    @else
    <div class="text-center py-12">
        <svg class="w-16 h-16 text-gray-300 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
        <p class="text-gray-500">Belum ada event di kalender</p>
        <a href="{{ route('admin.kalender.create') }}" class="inline-block mt-4 px-6 py-2 bg-gereja-biru text-white rounded-lg font-semibold">Tambah Event Pertama</a>
    </div>
    @endif
</div>
@endsection
