@extends('layouts.admin')

@section('title', isset($kegiatan) ? 'Edit Kegiatan' : 'Tambah Kegiatan')
@section('page-title', isset($kegiatan) ? 'Edit Kegiatan' : 'Tambah Kegiatan')

@section('content')
    <div class="max-w-3xl">
        <div class="bg-white rounded-xl shadow-md p-6">
            <form
                action="{{ isset($kegiatan) ? route('admin.kegiatan.update', $kegiatan->id) : route('admin.kegiatan.store') }}"
                method="POST" class="space-y-6">
                @csrf
                @if(isset($kegiatan))
                    @method('PUT')
                @endif

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Nama Kegiatan *</label>
                    <input type="text" name="nama" value="{{ $kegiatan->nama ?? old('nama') }}" required
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                        placeholder="Contoh: Persekutuan Doa">
                </div>

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Tipe Kegiatan *</label>
                    <select name="tipe" required
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                        <option value="">Pilih Tipe</option>
                        <option value="rutin" {{ (isset($kegiatan) && $kegiatan->tipe == 'rutin') ? 'selected' : '' }}>Rutin
                        </option>
                        <option value="khusus" {{ (isset($kegiatan) && $kegiatan->tipe == 'khusus') ? 'selected' : '' }}>
                            Khusus</option>
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Kategori</label>
                    <select name="kategori"
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                        <option value="">Pilih Kategori</option>
                        <option value="ibadah" {{ (isset($kegiatan) && $kegiatan->kategori == 'ibadah') ? 'selected' : '' }}>
                            Ibadah</option>
                        <option value="persekutuan" {{ (isset($kegiatan) && $kegiatan->kategori == 'persekutuan') ? 'selected' : '' }}>Persekutuan</option>
                        <option value="pelayanan" {{ (isset($kegiatan) && $kegiatan->kategori == 'pelayanan') ? 'selected' : '' }}>Pelayanan</option>
                        <option value="sosial" {{ (isset($kegiatan) && $kegiatan->kategori == 'sosial') ? 'selected' : '' }}>
                            Sosial</option>
                        <option value="pendidikan" {{ (isset($kegiatan) && $kegiatan->kategori == 'pendidikan') ? 'selected' : '' }}>Pendidikan</option>
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Jadwal (untuk kegiatan
                        rutin)</label>
                    <input type="text" name="jadwal" value="{{ $kegiatan->jadwal ?? old('jadwal') }}"
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                        placeholder="Contoh: Setiap Rabu, 18:00 WIB">
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Tanggal (untuk kegiatan
                            khusus)</label>
                        <input type="date" name="tanggal"
                            value="{{ isset($kegiatan) && $kegiatan->tanggal ? $kegiatan->tanggal->format('Y-m-d') : old('tanggal') }}"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                    </div>
                    <div>
                        <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Waktu</label>
                        <input type="time" name="waktu"
                            value="{{ isset($kegiatan) ? substr($kegiatan->waktu ?? '', 0, 5) : old('waktu') }}"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Tempat</label>
                    <input type="text" name="tempat" value="{{ $kegiatan->tempat ?? old('tempat') }}"
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                        placeholder="Contoh: Gedung Gereja Utama">
                </div>

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Deskripsi</label>
                    <textarea name="deskripsi" rows="4"
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                        placeholder="Deskripsi kegiatan">{{ $kegiatan->deskripsi ?? old('deskripsi') }}</textarea>
                </div>

                <div>
                    <label class="flex items-center">
                        <input type="checkbox" name="aktif" value="1" {{ (isset($kegiatan) && $kegiatan->aktif) ? 'checked' : (!isset($kegiatan) ? 'checked' : '') }} class="w-5 h-5 mr-3 rounded border-gray-300">
                        <span class="text-sm font-semibold" style="color: #1e3a5f;">Kegiatan Aktif</span>
                    </label>
                </div>

                <div class="flex items-center gap-4 pt-4">
                    <button type="submit"
                        class="px-6 py-3 rounded-xl font-semibold transition-all shadow-material-1 hover:shadow-material-2"
                        style="background: #1e3a5f; color: #ffffff;">
                        {{ isset($kegiatan) ? 'Update Kegiatan' : 'Simpan Kegiatan' }}
                    </button>
                    <a href="{{ route('admin.kegiatan.index') }}"
                        class="px-6 py-3 rounded-xl font-semibold bg-gray-200 text-gray-700 hover:bg-gray-300 transition-all">
                        Batal
                    </a>
                </div>
            </form>
        </div>
    </div>
@endsection