@extends('layouts.admin')

@section('title', isset($meeting) ? 'Edit Meeting' : 'Tambah Meeting')
@section('page-title', isset($meeting) ? 'Edit Meeting Online' : 'Tambah Meeting Online')

@section('content')
    <div class="max-w-3xl">
        <!-- Back Button -->
        <a href="{{ route('admin.komunikasi.index') }}"
            class="inline-flex items-center gap-2 text-slate-600 hover:text-[#1e3a5f] font-medium mb-5 transition-colors duration-200">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
            </svg>
            Kembali ke Daftar Meeting
        </a>

        <div class="bg-white rounded-2xl shadow-admin-md border border-slate-100 p-6">
            <div class="flex items-center gap-3 mb-6">
                <div
                    class="w-12 h-12 rounded-xl bg-gradient-to-br from-blue-100 to-blue-50 flex items-center justify-center">
                    <svg class="w-6 h-6 text-[#1e3a5f]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                            d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z" />
                    </svg>
                </div>
                <div>
                    <h2 class="text-xl font-bold text-[#1e3a5f]">
                        {{ isset($meeting) ? 'Edit Meeting Online' : 'Buat Meeting Baru' }}</h2>
                    <p class="text-sm text-slate-500">
                        {{ isset($meeting) ? 'Perbarui informasi meeting' : 'Lengkapi data meeting di bawah ini' }}</p>
                </div>
            </div>

            <form
                action="{{ isset($meeting) ? route('admin.komunikasi.update', $meeting['id'] ?? 1) : route('admin.komunikasi.store') }}"
                method="POST" class="space-y-5">
                @csrf
                @if(isset($meeting))
                    @method('PUT')
                @endif

                <div>
                    <label class="block text-slate-700 font-semibold text-[15px] mb-2">Nama Meeting *</label>
                    <input type="text" name="nama" value="{{ $meeting['nama'] ?? old('nama') }}" required
                        class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-[#1e3a5f] focus:bg-white focus:outline-none transition-all duration-200"
                        placeholder="Contoh: Ibadah Minggu Pagi">
                </div>

                <div>
                    <label class="block text-slate-700 font-semibold text-[15px] mb-2">Deskripsi</label>
                    <textarea name="deskripsi" rows="3"
                        class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-[#1e3a5f] focus:bg-white focus:outline-none transition-all duration-200"
                        placeholder="Deskripsi singkat meeting">{{ $meeting['deskripsi'] ?? old('deskripsi') }}</textarea>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                    <div>
                        <label class="block text-slate-700 font-semibold text-[15px] mb-2">Hari *</label>
                        <select name="hari" required
                            class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-[#1e3a5f] focus:bg-white focus:outline-none transition-all duration-200">
                            <option value="">Pilih Hari</option>
                            @foreach(['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'] as $hari)
                                <option value="{{ $hari }}" {{ (isset($meeting) && $meeting['hari'] == $hari) ? 'selected' : '' }}>{{ $hari }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label class="block text-slate-700 font-semibold text-[15px] mb-2">Waktu *</label>
                        <input type="time" name="waktu" value="{{ $meeting['waktu'] ?? old('waktu') }}" required
                            class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-[#1e3a5f] focus:bg-white focus:outline-none transition-all duration-200">
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                    <div>
                        <label class="block text-slate-700 font-semibold text-[15px] mb-2">Tanggal (opsional)</label>
                        <input type="date" name="tanggal"
                            value="{{ isset($meeting['tanggal']) ? date('Y-m-d', strtotime($meeting['tanggal'])) : old('tanggal') }}"
                            class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-[#1e3a5f] focus:bg-white focus:outline-none transition-all duration-200">
                        <p class="text-xs text-slate-400 mt-1">Kosongkan untuk meeting rutin</p>
                    </div>
                    <div>
                        <label class="block text-slate-700 font-semibold text-[15px] mb-2">Platform *</label>
                        <select name="platform" required
                            class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-[#1e3a5f] focus:bg-white focus:outline-none transition-all duration-200">
                            <option value="">Pilih Platform</option>
                            <option value="Zoom" {{ (isset($meeting) && $meeting['platform'] == 'Zoom') ? 'selected' : '' }}>
                                Zoom</option>
                            <option value="Google Meet" {{ (isset($meeting) && $meeting['platform'] == 'Google Meet') ? 'selected' : '' }}>Google Meet</option>
                            <option value="Zoom & Meet" {{ (isset($meeting) && $meeting['platform'] == 'Zoom & Meet') ? 'selected' : '' }}>Zoom & Google Meet</option>
                        </select>
                    </div>
                </div>

                <!-- Platform Links Section -->
                <div class="bg-slate-50 rounded-xl p-5 space-y-4 border border-slate-200">
                    <h3 class="font-semibold text-[#1e3a5f] text-[15px] flex items-center gap-2">
                        <svg class="w-5 h-5 text-[#d4af37]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1" />
                        </svg>
                        Link Platform
                    </h3>
                    <div>
                        <label class="block text-slate-600 font-medium text-sm mb-2">Link Zoom</label>
                        <input type="url" name="zoom_link" value="{{ $meeting['zoom_link'] ?? old('zoom_link') }}"
                            class="w-full px-4 py-3 bg-white border-2 border-slate-200 rounded-xl text-[15px] focus:border-blue-500 focus:outline-none transition-all duration-200"
                            placeholder="https://zoom.us/j/...">
                    </div>
                    <div>
                        <label class="block text-slate-600 font-medium text-sm mb-2">Link Google Meet</label>
                        <input type="url" name="meet_link" value="{{ $meeting['meet_link'] ?? old('meet_link') }}"
                            class="w-full px-4 py-3 bg-white border-2 border-slate-200 rounded-xl text-[15px] focus:border-emerald-500 focus:outline-none transition-all duration-200"
                            placeholder="https://meet.google.com/...">
                    </div>
                </div>

                <div>
                    <label class="block text-slate-700 font-semibold text-[15px] mb-2">Catatan (Khusus Admin)</label>
                    <textarea name="catatan" rows="2"
                        class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-[#1e3a5f] focus:bg-white focus:outline-none transition-all duration-200"
                        placeholder="Catatan tambahan (opsional)">{{ $meeting['catatan'] ?? old('catatan') }}</textarea>
                </div>

                <div class="bg-amber-50 rounded-xl p-4 border border-amber-200">
                    <label class="flex items-center cursor-pointer">
                        <input type="checkbox" name="is_active" value="1" {{ (isset($meeting) && $meeting['is_active']) ? 'checked' : '' }}
                            class="w-5 h-5 mr-3 rounded border-slate-300 text-[#1e3a5f] focus:ring-[#1e3a5f]">
                        <div>
                            <span class="text-[15px] font-semibold text-amber-800">Aktifkan Meeting</span>
                            <p class="text-sm text-amber-600">Meeting akan ditandai sebagai "LIVE" (sedang berlangsung)</p>
                        </div>
                    </label>
                </div>

                <div class="flex items-center gap-4 pt-5 border-t border-slate-200 mt-6">
                    <button type="submit"
                        class="inline-flex items-center gap-2 px-6 py-3 bg-[#1e3a5f] text-white rounded-xl font-semibold text-[15px] hover:bg-[#2d5a8a] transition-all duration-200 shadow-admin-sm hover:shadow-admin-md">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                        </svg>
                        {{ isset($meeting) ? 'Update Meeting' : 'Simpan Meeting' }}
                    </button>
                    <a href="{{ route('admin.komunikasi.index') }}"
                        class="inline-flex items-center gap-2 px-6 py-3 bg-slate-100 text-slate-700 rounded-xl font-semibold text-[15px] hover:bg-slate-200 transition-all duration-200">
                        Batal
                    </a>
                </div>
            </form>
        </div>
    </div>
@endsection