@extends('layouts.admin')

@section('title', 'Manajemen Komunikasi')
@section('page-title', 'Manajemen Komunikasi Daring')

@section('content')
<!-- Main Card -->
<div class="bg-white rounded-2xl shadow-admin-md border border-slate-100 p-6 mb-6">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-6">
        <div class="flex items-center gap-2">
            <span class="w-1.5 h-7 bg-[#d4af37] rounded-full"></span>
            <h2 class="text-xl font-bold text-[#1e3a5f]">Jadwal Pertemuan Daring</h2>
        </div>
        <a href="{{ route('admin.komunikasi.create') }}" class="inline-flex items-center justify-center gap-2 px-6 py-3 bg-[#1e3a5f] text-white rounded-xl font-bold text-[15px] hover:bg-[#2d5a8a] transition-all duration-200 shadow-admin-sm hover:shadow-admin-md">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/></svg>
            Buat Meeting Baru
        </a>
    </div>

    @if(count($meetings) > 0)
    <div class="space-y-4">
        @foreach($meetings as $meeting)
        <div class="bg-slate-50 rounded-xl p-5 hover:shadow-admin-md transition-all duration-300 border-2 {{ $meeting['is_active'] ? 'border-emerald-400 bg-emerald-50' : 'border-slate-100 hover:border-slate-200' }}">
            <div class="flex flex-col lg:flex-row lg:items-start lg:justify-between gap-4">
                <!-- Meeting Info -->
                <div class="flex items-start gap-4 flex-grow">
                    <div class="w-14 h-14 rounded-xl flex items-center justify-center flex-shrink-0 shadow-admin-sm {{ $meeting['is_active'] ? 'bg-gradient-to-br from-emerald-500 to-emerald-600' : 'bg-gradient-to-br from-[#1e3a5f] to-[#2d5a8a]' }}">
                        <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z"/></svg>
                    </div>
                    <div class="flex-grow min-w-0">
                        <div class="flex items-center flex-wrap gap-2 mb-2">
                            <h3 class="text-xl font-bold text-[#1e3a5f]">{{ $meeting['nama'] }}</h3>
                            @if($meeting['is_active'])
                            <span class="inline-flex items-center gap-1.5 px-3 py-1 bg-rose-500 text-white rounded-full text-xs font-bold animate-pulse">
                                <span class="w-2 h-2 rounded-full bg-white"></span>
                                LIVE
                            </span>
                            @endif
                        </div>
                        <p class="text-slate-600 text-[15px] leading-relaxed mb-3">{{ $meeting['deskripsi'] }}</p>
                        <div class="flex flex-wrap gap-4 text-sm text-slate-500">
                            <span class="inline-flex items-center gap-1.5 bg-white px-3 py-1.5 rounded-lg">
                                <svg class="w-4 h-4 text-[#d4af37]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
                                {{ $meeting['hari'] }}, {{ $meeting['tanggal'] }}
                            </span>
                            <span class="inline-flex items-center gap-1.5 bg-white px-3 py-1.5 rounded-lg">
                                <svg class="w-4 h-4 text-[#d4af37]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                                {{ $meeting['waktu'] }}
                            </span>
                            <span class="inline-flex items-center gap-1.5 bg-white px-3 py-1.5 rounded-lg">
                                <svg class="w-4 h-4 text-[#d4af37]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z"/></svg>
                                {{ $meeting['platform'] }}
                            </span>
                        </div>
                    </div>
                </div>
                
                <!-- Actions -->
                <div class="flex flex-col gap-2.5 lg:min-w-[160px]">
                    @if($meeting['zoom_link'])
                    <a href="{{ $meeting['zoom_link'] }}" target="_blank" class="inline-flex items-center justify-center gap-2 px-4 py-2.5 bg-blue-600 text-white rounded-xl text-sm font-semibold hover:bg-blue-700 transition-all duration-200 shadow-admin-sm">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24"><path d="M4.585 4.585a1.333 1.333 0 011.885 0L12 10.115l5.53-5.53a1.333 1.333 0 011.885 1.885L13.885 12l5.53 5.53a1.333 1.333 0 01-1.885 1.885L12 13.885l-5.53 5.53a1.333 1.333 0 01-1.885-1.885L10.115 12 4.585 6.47a1.333 1.333 0 010-1.885z"/></svg>
                        Buka Zoom
                    </a>
                    @endif
                    @if($meeting['meet_link'])
                    <a href="{{ $meeting['meet_link'] }}" target="_blank" class="inline-flex items-center justify-center gap-2 px-4 py-2.5 bg-emerald-600 text-white rounded-xl text-sm font-semibold hover:bg-emerald-700 transition-all duration-200 shadow-admin-sm">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z"/></svg>
                        Buka Meet
                    </a>
                    @endif
                    <div class="flex gap-2">
                        <a href="{{ route('admin.komunikasi.edit', $meeting['id']) }}" class="flex-1 inline-flex items-center justify-center gap-1.5 px-3 py-2 bg-white border border-slate-200 text-slate-700 rounded-xl text-sm font-semibold hover:bg-slate-50 transition-all duration-200">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/></svg>
                            Edit
                        </a>
                        <button onclick="shareLink('{{ $meeting['zoom_link'] ?? $meeting['meet_link'] }}')" class="flex-1 inline-flex items-center justify-center gap-1.5 px-3 py-2 bg-[#d4af37] text-[#1e3a5f] rounded-xl text-sm font-semibold hover:bg-[#e6c85a] transition-all duration-200">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.368 2.684 3 3 0 00-5.368-2.684z"/></svg>
                            Share
                        </button>
                    </div>
                    <form action="{{ route('admin.komunikasi.destroy', $meeting['id']) }}" method="POST" class="inline" onsubmit="return confirm('Yakin ingin menghapus meeting ini?')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="w-full inline-flex items-center justify-center gap-1.5 px-3 py-2 bg-rose-50 text-rose-600 border border-rose-200 rounded-xl text-sm font-semibold hover:bg-rose-100 transition-all duration-200">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/></svg>
                            Hapus
                        </button>
                    </form>
                </div>
            </div>
            
            <!-- Meeting Notes -->
            <div class="mt-5 pt-5 border-t border-slate-200">
                <details class="group">
                    <summary class="cursor-pointer flex items-center gap-2 text-sm font-semibold text-slate-700 hover:text-[#1e3a5f] transition-colors duration-200">
                        <svg class="w-4 h-4 text-[#d4af37] group-open:rotate-90 transition-transform duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
                        Catatan Pertemuan (Khusus Admin/Pendeta)
                    </summary>
                    <div class="mt-3 pl-6">
                        <textarea class="w-full px-4 py-3 bg-white border border-slate-200 rounded-xl text-[15px] text-slate-700 focus:border-[#1e3a5f] focus:ring-2 focus:ring-[#1e3a5f]/20 focus:outline-none transition-all duration-200" rows="3" placeholder="Tambahkan catatan pertemuan..." readonly>{{ $meeting['catatan'] ?? '' }}</textarea>
                    </div>
                </details>
            </div>
        </div>
        @endforeach
    </div>
    @else
    <div class="text-center py-16">
        <div class="w-20 h-20 rounded-2xl bg-slate-100 flex items-center justify-center mx-auto mb-5">
            <svg class="w-10 h-10 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z"/></svg>
        </div>
        <p class="text-slate-500 text-lg font-medium mb-2">Belum ada meeting terdaftar</p>
        <p class="text-slate-400 text-[15px] mb-6">Buat meeting pertama untuk memulai</p>
        <a href="{{ route('admin.komunikasi.create') }}" class="inline-flex items-center gap-2 px-6 py-3 bg-[#1e3a5f] text-white rounded-xl font-semibold hover:bg-[#2d5a8a] transition-all duration-200 shadow-admin-sm hover:shadow-admin-md">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/></svg>
            Buat Meeting Pertama
        </a>
    </div>
    @endif
</div>

<script>
function shareLink(link) {
    if (navigator.share) {
        navigator.share({
            title: 'Link Pertemuan Daring Gereja',
            text: 'Bergabunglah dalam pertemuan daring kami',
            url: link
        });
    } else {
        navigator.clipboard.writeText(link);
        // Show toast notification
        const toast = document.createElement('div');
        toast.className = 'fixed bottom-6 right-6 bg-[#1e3a5f] text-white px-5 py-3 rounded-xl shadow-admin-lg z-50 animate-fade-in flex items-center gap-2';
        toast.innerHTML = '<svg class="w-5 h-5 text-[#d4af37]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg> Link berhasil disalin!';
        document.body.appendChild(toast);
        setTimeout(() => {
            toast.style.opacity = '0';
            setTimeout(() => toast.remove(), 300);
        }, 2000);
    }
}
</script>

<style>
.animate-fade-in {
    animation: fadeIn 0.3s ease-out;
    transition: opacity 0.3s;
}
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}
</style>
@endsection
