<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Admin - Gereja Jemaat Buntu Ambaang</title>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="min-h-screen bg-gradient-to-br from-[--color-gereja-biru] to-[--color-gereja-biru-light] flex items-center justify-center p-4">
    <div class="w-full max-w-md">
        <div class="bg-white rounded-2xl shadow-2xl p-8">
            <!-- Logo -->
            <div class="text-center mb-8">
                <div class="w-20 h-20 mx-auto bg-gereja-emas rounded-full flex items-center justify-center mb-4">
                    <svg class="w-12 h-12 text-gereja-biru" fill="currentColor" viewBox="0 0 24 24">
                        <path d="M12 2L2 12h3v8h6v-6h2v6h6v-8h3L12 2z"/>
                    </svg>
                </div>
                <h1 class="text-2xl font-bold text-gereja-biru">Admin Panel</h1>
                <p class="text-gray-500">Gereja Jemaat Buntu Ambaang</p>
            </div>

            @if(session('error'))
            <div class="mb-6 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg">
                {{ session('error') }}
            </div>
            @endif

            <form action="{{ route('admin.login.submit') }}" method="POST" class="space-y-6">
                @csrf
                <div>
                    <label class="block text-gray-700 font-semibold mb-2">Username / Email</label>
                    <input type="text" name="username" required class="w-full px-4 py-3 border-2 border-gray-300 rounded-lg focus:border-gereja-biru focus:outline-none" placeholder="Masukkan username atau email">
                </div>
                
                <div>
                    <label class="block text-gray-700 font-semibold mb-2">Password</label>
                    <input type="password" name="password" required class="w-full px-4 py-3 border-2 border-gray-300 rounded-lg focus:border-gereja-biru focus:outline-none" placeholder="Masukkan password">
                </div>

                <div class="flex items-center justify-between">
                    <label class="flex items-center">
                        <input type="checkbox" name="remember" class="w-4 h-4 mr-2">
                        <span class="text-gray-600">Ingat saya</span>
                    </label>
                </div>

                <button type="submit" class="w-full bg-gereja-biru text-white py-4 rounded-lg font-bold text-lg hover:bg-gereja-biru-light transition">
                    Login
                </button>
            </form>

            <div class="mt-6 text-center">
                <a href="{{ route('beranda') }}" class="text-gereja-biru hover:text-gereja-emas transition">
                    &larr; Kembali ke Website
                </a>
            </div>

            <!-- Demo Login Info -->
            <div class="mt-6 p-4 bg-gray-50 rounded-lg">
                <p class="text-xs text-gray-500 font-semibold mb-2">Demo Login:</p>
                <div class="text-xs text-gray-600 space-y-1">
                    <p><strong>Admin:</strong> admin / admin123</p>
                    <p><strong>Pendeta:</strong> pendeta@gereja.com / pendeta123</p>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
