@extends('layouts.admin')

@section('title', isset($oig) ? 'Edit OIG' : 'Tambah OIG')
@section('page-title', isset($oig) ? 'Edit Organisasi Intra Gereja' : 'Tambah Organisasi Intra Gereja')

@section('content')
    <div class="max-w-3xl">
        <div class="bg-white rounded-xl shadow-md p-6">
            <form action="{{ isset($oig) ? route('admin.oig.update', $oig->id) : route('admin.oig.store') }}" method="POST"
                class="space-y-6">
                @csrf
                @if(isset($oig))
                    @method('PUT')
                @endif

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Nama OIG *</label>
                    <input type="text" name="nama" value="{{ $oig->nama ?? old('nama') }}" required
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                        placeholder="Contoh: Persekutuan Pemuda">
                </div>

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Jadwal Kegiatan</label>
                    <input type="text" name="jadwal" value="{{ $oig->jadwal ?? old('jadwal') }}"
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                        placeholder="Contoh: Setiap Sabtu, 17:00 WIB">
                </div>

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Deskripsi</label>
                    <textarea name="deskripsi" rows="3"
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                        placeholder="Deskripsi singkat tentang OIG">{{ $oig->deskripsi ?? old('deskripsi') }}</textarea>
                </div>

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Pengurus</label>
                    <div id="pengurus-container" class="space-y-3">
                        @if(isset($oig) && $oig->pengurus)
                            @foreach($oig->pengurus as $index => $pengurus)
                                @php
                                    $nama = is_array($pengurus) ? ($pengurus['nama'] ?? '') : '';
                                    $jabatan = is_array($pengurus) ? ($pengurus['jabatan'] ?? '') : '';
                                @endphp
                                <div class="flex gap-3 pengurus-row">
                                    <input type="text" name="pengurus_nama[]" value="{{ $nama }}"
                                        class="flex-1 px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                                        placeholder="Nama">
                                    <select name="pengurus_jabatan[]"
                                        class="w-40 px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                                        <option value="">Jabatan</option>
                                        <option value="Ketua" {{ $jabatan == 'Ketua' ? 'selected' : '' }}>Ketua</option>
                                        <option value="Wakil Ketua" {{ $jabatan == 'Wakil Ketua' ? 'selected' : '' }}>Wakil Ketua
                                        </option>
                                        <option value="Sekretaris" {{ $jabatan == 'Sekretaris' ? 'selected' : '' }}>Sekretaris
                                        </option>
                                        <option value="Bendahara" {{ $jabatan == 'Bendahara' ? 'selected' : '' }}>Bendahara</option>
                                        <option value="Anggota" {{ $jabatan == 'Anggota' ? 'selected' : '' }}>Anggota</option>
                                    </select>
                                    <button type="button" onclick="removePengurus(this)"
                                        class="px-3 py-3 bg-red-100 text-red-600 rounded-xl hover:bg-red-200">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                        </svg>
                                    </button>
                                </div>
                            @endforeach
                        @else
                            <div class="flex gap-3 pengurus-row">
                                <input type="text" name="pengurus_nama[]"
                                    class="flex-1 px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                                    placeholder="Nama">
                                <select name="pengurus_jabatan[]"
                                    class="w-40 px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                                    <option value="">Jabatan</option>
                                    <option value="Ketua">Ketua</option>
                                    <option value="Wakil Ketua">Wakil Ketua</option>
                                    <option value="Sekretaris">Sekretaris</option>
                                    <option value="Bendahara">Bendahara</option>
                                    <option value="Anggota">Anggota</option>
                                </select>
                                <button type="button" onclick="removePengurus(this)"
                                    class="px-3 py-3 bg-red-100 text-red-600 rounded-xl hover:bg-red-200">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                    </svg>
                                </button>
                            </div>
                        @endif
                    </div>
                    <button type="button" onclick="addPengurus()"
                        class="mt-3 px-4 py-2 bg-gray-100 text-gray-700 rounded-xl hover:bg-gray-200 text-sm font-semibold">
                        + Tambah Pengurus
                    </button>
                </div>

                <div class="flex items-center gap-4 pt-4">
                    <button type="submit"
                        class="px-6 py-3 rounded-xl font-semibold transition-all shadow-material-1 hover:shadow-material-2"
                        style="background: #1e3a5f; color: #ffffff;">
                        {{ isset($oig) ? 'Update OIG' : 'Simpan OIG' }}
                    </button>
                    <a href="{{ route('admin.oig.index') }}"
                        class="px-6 py-3 rounded-xl font-semibold bg-gray-200 text-gray-700 hover:bg-gray-300 transition-all">
                        Batal
                    </a>
                </div>
            </form>
        </div>
    </div>

    <script>
        function addPengurus() {
            const container = document.getElementById('pengurus-container');
            const row = document.createElement('div');
            row.className = 'flex gap-3 pengurus-row';
            row.innerHTML = `
                    <input type="text" name="pengurus_nama[]" 
                        class="flex-1 px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                        placeholder="Nama">
                    <select name="pengurus_jabatan[]" class="w-40 px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                        <option value="">Jabatan</option>
                        <option value="Ketua">Ketua</option>
                        <option value="Wakil Ketua">Wakil Ketua</option>
                        <option value="Sekretaris">Sekretaris</option>
                        <option value="Bendahara">Bendahara</option>
                        <option value="Anggota">Anggota</option>
                    </select>
                    <button type="button" onclick="removePengurus(this)" class="px-3 py-3 bg-red-100 text-red-600 rounded-xl hover:bg-red-200">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/></svg>
                    </button>
                `;
            container.appendChild(row);
        }

        function removePengurus(btn) {
            const rows = document.querySelectorAll('.pengurus-row');
            if (rows.length > 1) {
                btn.closest('.pengurus-row').remove();
            }
        }
    </script>
@endsection