@extends('layouts.admin')

@section('title', 'Manajemen OIG')
@section('page-title', 'Manajemen Organisasi Intra Gereja')

@section('content')
<div class="bg-white rounded-xl shadow-md p-6">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-6">
        <h2 class="text-xl font-bold text-gereja-biru mb-4 md:mb-0">Daftar OIG</h2>
        <a href="{{ route('admin.oig.create') }}" class="inline-flex items-center px-6 py-3 bg-gereja-biru text-white rounded-lg font-bold hover:bg-gereja-biru-light transition">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/></svg>
            Tambah OIG
        </a>
    </div>
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-3 text-left text-gray-600">Nama OIG</th>
                    <th class="px-4 py-3 text-left text-gray-600">Ketua</th>
                    <th class="px-4 py-3 text-left text-gray-600">Jadwal</th>
                    <th class="px-4 py-3 text-left text-gray-600">Aksi</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-100">
                @foreach($oigList as $oig)
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-4 font-semibold">{{ $oig['nama'] }}</td>
                    <td class="px-4 py-4">{{ $oig['ketua'] }}</td>
                    <td class="px-4 py-4">{{ $oig['jadwal'] }}</td>
                    <td class="px-4 py-4">
                        <div class="flex items-center space-x-2">
                            <a href="{{ route('admin.oig.edit', $oig['id']) }}" class="p-2 text-blue-600 hover:bg-blue-100 rounded-lg">Edit</a>
                            <form action="{{ route('admin.oig.destroy', $oig['id']) }}" method="POST" onsubmit="return confirm('Yakin?')">@csrf @method('DELETE')<button class="p-2 text-red-600 hover:bg-red-100 rounded-lg">Hapus</button></form>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection

