@extends('layouts.admin')

@section('title', isset($pengumuman) ? 'Edit Pengumuman' : 'Tambah Pengumuman')
@section('page-title', isset($pengumuman) ? 'Edit Pengumuman' : 'Tambah Pengumuman')

@section('content')
    <div class="max-w-3xl">
        <!-- Back Button -->
        <a href="{{ route('admin.pengumuman.index') }}"
            class="inline-flex items-center gap-2 text-slate-600 hover:text-[#1e3a5f] font-medium mb-5 transition-colors duration-200">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
            </svg>
            Kembali ke Daftar Pengumuman
        </a>

        <div class="bg-white rounded-2xl shadow-admin-md border border-slate-100 p-6">
            <div class="flex items-center gap-3 mb-6">
                <div
                    class="w-12 h-12 rounded-xl bg-gradient-to-br from-blue-100 to-blue-50 flex items-center justify-center">
                    <svg class="w-6 h-6 text-[#1e3a5f]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                            d="M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z" />
                    </svg>
                </div>
                <div>
                    <h2 class="text-xl font-bold text-[#1e3a5f]">
                        {{ isset($pengumuman) ? 'Edit Pengumuman' : 'Tambah Pengumuman Baru' }}</h2>
                    <p class="text-sm text-slate-500">
                        {{ isset($pengumuman) ? 'Perbarui informasi pengumuman' : 'Lengkapi form di bawah untuk membuat pengumuman' }}
                    </p>
                </div>
            </div>

            <form
                action="{{ isset($pengumuman) ? route('admin.pengumuman.update', $pengumuman->id) : route('admin.pengumuman.store') }}"
                method="POST" class="space-y-5">
                @csrf
                @if(isset($pengumuman))
                    @method('PUT')
                @endif

                <!-- Judul -->
                <div>
                    <label class="block text-slate-700 font-semibold text-[15px] mb-2">Judul Pengumuman *</label>
                    <input type="text" name="judul" value="{{ $pengumuman->judul ?? old('judul') }}" required
                        class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-[#1e3a5f] focus:bg-white focus:outline-none transition-all duration-200"
                        placeholder="Contoh: Ibadah Syukuran Tahun Baru 2025">
                    @error('judul')
                        <p class="text-sm text-rose-500 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Deskripsi -->
                <div>
                    <label class="block text-slate-700 font-semibold text-[15px] mb-2">Deskripsi *</label>
                    <textarea name="deskripsi" rows="4" required
                        class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-[#1e3a5f] focus:bg-white focus:outline-none transition-all duration-200 resize-none"
                        placeholder="Tuliskan deskripsi lengkap pengumuman...">{{ $pengumuman->deskripsi ?? old('deskripsi') }}</textarea>
                    @error('deskripsi')
                        <p class="text-sm text-rose-500 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Tanggal -->
                <div>
                    <label class="block text-slate-700 font-semibold text-[15px] mb-2">Tanggal *</label>
                    <input type="date" name="tanggal"
                        value="{{ isset($pengumuman) ? $pengumuman->tanggal->format('Y-m-d') : old('tanggal', date('Y-m-d')) }}"
                        required
                        class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-[#1e3a5f] focus:bg-white focus:outline-none transition-all duration-200">
                    @error('tanggal')
                        <p class="text-sm text-rose-500 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Status Aktif -->
                <div class="bg-slate-50 rounded-xl p-4 border border-slate-200">
                    <label class="flex items-center gap-3 cursor-pointer">
                        <input type="checkbox" name="aktif" value="1" {{ (isset($pengumuman) && $pengumuman->aktif) || !isset($pengumuman) ? 'checked' : '' }}
                            class="w-5 h-5 rounded border-slate-300 text-[#1e3a5f] focus:ring-[#1e3a5f] focus:ring-offset-0 cursor-pointer">
                        <div>
                            <span class="font-semibold text-slate-700">Aktifkan Pengumuman</span>
                            <p class="text-sm text-slate-500">Pengumuman akan ditampilkan di beranda publik jika diaktifkan
                            </p>
                        </div>
                    </label>
                </div>

                <!-- Info Box -->
                <div class="bg-amber-50 rounded-xl p-4 border border-amber-200">
                    <div class="flex gap-3">
                        <svg class="w-5 h-5 text-amber-600 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <div class="text-sm text-amber-800">
                            <p class="font-semibold mb-1">Informasi:</p>
                            <p class="text-amber-700">Hanya 3 pengumuman terbaru yang aktif akan ditampilkan di beranda
                                publik.</p>
                        </div>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="flex items-center gap-4 pt-5 border-t border-slate-200 mt-6">
                    <button type="submit"
                        class="inline-flex items-center gap-2 px-6 py-3 bg-[#1e3a5f] text-white rounded-xl font-semibold text-[15px] hover:bg-[#2d5a8a] transition-all duration-200 shadow-admin-sm hover:shadow-admin-md">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                        </svg>
                        {{ isset($pengumuman) ? 'Update Pengumuman' : 'Simpan Pengumuman' }}
                    </button>
                    <a href="{{ route('admin.pengumuman.index') }}"
                        class="inline-flex items-center gap-2 px-6 py-3 bg-slate-100 text-slate-700 rounded-xl font-semibold text-[15px] hover:bg-slate-200 transition-all duration-200">
                        Batal
                    </a>
                </div>
            </form>
        </div>
    </div>
@endsection