@extends('layouts.admin')

@section('title', 'Pesan Kontak')
@section('page-title', 'Pesan Kontak')

@section('content')
<!-- Stats Card -->
<div class="bg-white rounded-2xl shadow-admin-md border border-slate-100 p-6 mb-6">
    <div class="flex items-center justify-between">
        <div class="flex items-center gap-4">
            <div class="w-14 h-14 bg-gradient-to-br from-blue-100 to-blue-50 rounded-2xl flex items-center justify-center">
                <svg class="w-7 h-7 text-[#1e3a5f]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
            </div>
            <div>
                <p class="text-slate-500 text-[15px] font-medium">Total Pesan Belum Dibaca</p>
                <p class="text-3xl font-bold text-[#1e3a5f]">{{ $totalBelumDibaca }}</p>
            </div>
        </div>
    </div>
</div>

<!-- Pesan List -->
<div class="bg-white rounded-2xl shadow-admin-md border border-slate-100 p-6">
    <div class="flex items-center gap-2 mb-6">
        <span class="w-1.5 h-7 bg-[#d4af37] rounded-full"></span>
        <h2 class="text-xl font-bold text-[#1e3a5f]">Daftar Pesan Masuk</h2>
    </div>
    
    <div class="space-y-4">
        @forelse($pesanList as $pesan)
        <div class="bg-slate-50 rounded-xl p-5 hover:shadow-admin-md transition-all duration-300 border border-slate-100 hover:border-slate-200 {{ !$pesan->dibaca ? 'border-l-4 border-l-[#d4af37]' : '' }}">
            <div class="flex flex-col md:flex-row md:items-start md:justify-between gap-4">
                <div class="flex items-start gap-4 flex-grow">
                    <div class="w-12 h-12 rounded-xl bg-gradient-to-br {{ !$pesan->dibaca ? 'from-amber-100 to-amber-50' : 'from-slate-200 to-slate-100' }} flex items-center justify-center flex-shrink-0 shadow-admin-sm">
                        <svg class="w-6 h-6 {{ !$pesan->dibaca ? 'text-[#d4af37]' : 'text-slate-500' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                    </div>
                    <div class="flex-grow min-w-0">
                        <div class="flex items-center gap-2 mb-1">
                            <h3 class="font-bold text-[#1e3a5f] text-lg truncate">{{ $pesan->nama }}</h3>
                            @if(!$pesan->dibaca)
                            <span class="inline-flex items-center gap-1 px-2 py-0.5 rounded-full text-xs font-semibold bg-[#d4af37] text-white">
                                Baru
                            </span>
                            @endif
                        </div>
                        <p class="text-sm text-slate-500 mb-2">{{ $pesan->email }}</p>
                        <p class="font-semibold text-slate-700 text-[15px] mb-1">{{ $pesan->subjek }}</p>
                        <p class="text-slate-600 text-sm line-clamp-2">{{ Str::limit($pesan->pesan, 150) }}</p>
                        <p class="text-xs text-slate-400 mt-2">{{ $pesan->created_at->format('d M Y, H:i') }} &bull; {{ $pesan->created_at->diffForHumans() }}</p>
                    </div>
                </div>
                <div class="flex flex-wrap items-center gap-2 md:flex-col md:items-end">
                    <a href="{{ route('admin.pesan.show', $pesan->id) }}" class="inline-flex items-center gap-2 px-4 py-2.5 bg-[#1e3a5f] text-white rounded-xl text-sm font-semibold hover:bg-[#2d5a8a] transition-all duration-200 shadow-admin-sm hover:shadow-admin-md">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/></svg>
                        Lihat
                    </a>
                    <form action="{{ route('admin.pesan.toggle', $pesan->id) }}" method="POST" class="inline">
                        @csrf
                        @method('PATCH')
                        <button type="submit" class="inline-flex items-center gap-2 px-4 py-2.5 {{ $pesan->dibaca ? 'bg-amber-100 text-amber-700 hover:bg-amber-200' : 'bg-emerald-100 text-emerald-700 hover:bg-emerald-200' }} rounded-xl text-sm font-semibold transition-all duration-200">
                            @if($pesan->dibaca)
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                            Belum Dibaca
                            @else
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            Sudah Dibaca
                            @endif
                        </button>
                    </form>
                    <form action="{{ route('admin.pesan.destroy', $pesan->id) }}" method="POST" class="inline" onsubmit="return confirm('Yakin ingin menghapus pesan ini?')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="inline-flex items-center gap-2 px-4 py-2.5 bg-red-100 text-red-700 rounded-xl text-sm font-semibold hover:bg-red-200 transition-all duration-200">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/></svg>
                            Hapus
                        </button>
                    </form>
                </div>
            </div>
        </div>
        @empty
        <div class="text-center py-12">
            <div class="w-16 h-16 rounded-2xl bg-slate-100 flex items-center justify-center mx-auto mb-4">
                <svg class="w-8 h-8 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
            </div>
            <p class="text-slate-500 text-[15px]">Belum ada pesan masuk</p>
        </div>
        @endforelse
    </div>
    
    {{ $pesanList->links('components.pagination') }}
</div>

<style>
.line-clamp-2 {
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
}
</style>
@endsection
