@extends('layouts.admin')

@section('title', 'Kelola Profil Gereja')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="flex items-center justify-between">
        <div>
            <h1 class="text-2xl font-bold" style="color: #1e3a5f;">Kelola Profil Gereja</h1>
            <p class="text-gray-600">Atur informasi profil, visi misi, pendeta, dan majelis gereja</p>
        </div>
    </div>

    @if(session('success'))
    <div class="bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded-xl">
        {{ session('success') }}
    </div>
    @endif

    <!-- Profil Gereja -->
    <div class="bg-white rounded-2xl shadow-material-1 overflow-hidden">
        <div class="px-6 py-4 border-b" style="background: rgba(30,58,95,0.05);">
            <h2 class="text-lg font-bold" style="color: #1e3a5f;">Informasi Gereja</h2>
        </div>
        <form action="{{ route('admin.profil.update') }}" method="POST" class="p-6">
            @csrf
            @method('PUT')
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Nama Gereja</label>
                    <input type="text" name="nama_gereja" value="{{ $profil['nama_gereja'] }}" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                </div>
                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Tahun Berdiri</label>
                    <input type="number" name="tahun_berdiri" value="{{ $profil['tahun_berdiri'] }}" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                </div>
                <div class="md:col-span-2">
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Alamat</label>
                    <input type="text" name="alamat" value="{{ $profil['alamat'] }}" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                </div>
                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Telepon</label>
                    <input type="text" name="telepon" value="{{ $profil['telepon'] }}" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                </div>
                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Email</label>
                    <input type="email" name="email" value="{{ $profil['email'] }}" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                </div>
                <div class="md:col-span-2">
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Visi</label>
                    <textarea name="visi" rows="3" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">{{ $profil['visi'] }}</textarea>
                </div>
                <div class="md:col-span-2">
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Misi (pisahkan dengan baris baru)</label>
                    <textarea name="misi" rows="5" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">{{ implode("\n", $profil['misi']) }}</textarea>
                </div>
            </div>
            <div class="mt-6">
                <button type="submit" class="px-6 py-3 rounded-xl font-semibold transition-all shadow-material-1 hover:shadow-material-2" style="background: #1e3a5f; color: #ffffff;">
                    Simpan Perubahan
                </button>
            </div>
        </form>
    </div>

    <!-- Pendeta -->
    <div class="bg-white rounded-2xl shadow-material-1 overflow-hidden">
        <div class="px-6 py-4 border-b" style="background: rgba(212,175,55,0.1);">
            <h2 class="text-lg font-bold" style="color: #1e3a5f;">Data Pendeta</h2>
        </div>
        <div class="p-6">
            <div class="flex flex-col lg:flex-row gap-8">
                <!-- Foto Section (Terpisah) -->
                <div class="lg:w-48 flex-shrink-0">
                    <label class="block text-sm font-semibold mb-4 text-center" style="color: #1e3a5f;">Foto Profil</label>
                    <div class="flex flex-col items-center">
                        <div class="mb-4">
                            <x-profile-photo :foto="$pendeta['foto']" :nama="$pendeta['nama']" size="xl" class="shadow-material-2" />
                        </div>
                        
                        <!-- Form Upload Foto Terpisah -->
                        <form action="{{ route('admin.profil.pendeta') }}" method="POST" enctype="multipart/form-data" class="w-full">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="nama" value="{{ $pendeta['nama'] }}">
                            <input type="hidden" name="jabatan" value="{{ $pendeta['jabatan'] }}">
                            <input type="hidden" name="mulai_melayani" value="{{ $pendeta['mulai_melayani'] }}">
                            <input type="hidden" name="telepon" value="{{ $pendeta['telepon'] }}">
                            <input type="hidden" name="email" value="{{ $pendeta['email'] }}">
                            <label class="block cursor-pointer">
                                <span class="block text-center text-sm text-blue-600 hover:text-blue-800 font-medium mb-2">Pilih Foto</span>
                                <input type="file" name="foto" accept="image/jpeg,image/png,image/webp" 
                                    class="hidden" onchange="this.form.submit()">
                            </label>
                        </form>
                        <p class="text-xs text-gray-500 text-center mt-1">JPG, PNG, WEBP. Maks 2MB</p>
                        
                        @if($pendeta['foto'])
                        <form action="{{ route('admin.profil.pendeta.photo.delete') }}" method="POST" class="mt-2">
                            @csrf
                            @method('DELETE')
                            <button type="submit" onclick="return confirm('Hapus foto pendeta?')" class="text-xs text-red-600 hover:text-red-800 font-medium">
                                Hapus Foto
                            </button>
                        </form>
                        @endif
                    </div>
                </div>
                
                <!-- Data Fields -->
                <div class="flex-1">
                    <form action="{{ route('admin.profil.pendeta') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div class="md:col-span-2">
                                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Nama Lengkap</label>
                                <input type="text" name="nama" value="{{ $pendeta['nama'] }}" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                            </div>
                            <div>
                                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Jabatan</label>
                                <input type="text" name="jabatan" value="{{ $pendeta['jabatan'] }}" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                            </div>
                            <div>
                                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Mulai Melayani</label>
                                <input type="text" name="mulai_melayani" value="{{ $pendeta['mulai_melayani'] }}" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400" placeholder="Tahun">
                            </div>
                            <div>
                                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Telepon</label>
                                <input type="text" name="telepon" value="{{ $pendeta['telepon'] }}" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                            </div>
                            <div>
                                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Email</label>
                                <input type="email" name="email" value="{{ $pendeta['email'] }}" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                            </div>
                        </div>
                        <div class="mt-6">
                            <button type="submit" class="px-6 py-3 rounded-xl font-semibold transition-all shadow-material-1 hover:shadow-material-2" style="background: #d4af37; color: #1e3a5f;">
                                Simpan Data Pendeta
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Majelis -->
    <div class="bg-white rounded-2xl shadow-material-1 overflow-hidden">
        <div class="px-6 py-4 border-b flex items-center justify-between" style="background: rgba(30,58,95,0.05);">
            <h2 class="text-lg font-bold" style="color: #1e3a5f;">Data Majelis</h2>
            <button onclick="document.getElementById('modal-tambah-majelis').classList.remove('hidden')" class="px-4 py-2 rounded-xl font-semibold text-sm transition-all" style="background: #1e3a5f; color: #ffffff;">
                + Tambah Majelis
            </button>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead style="background: rgba(30,58,95,0.03);">
                    <tr>
                        <th class="px-6 py-4 text-left text-sm font-semibold" style="color: #1e3a5f;">Foto</th>
                        <th class="px-6 py-4 text-left text-sm font-semibold" style="color: #1e3a5f;">Nama</th>
                        <th class="px-6 py-4 text-left text-sm font-semibold" style="color: #1e3a5f;">Jabatan</th>
                        <th class="px-6 py-4 text-left text-sm font-semibold" style="color: #1e3a5f;">Bidang</th>
                        <th class="px-6 py-4 text-center text-sm font-semibold" style="color: #1e3a5f;">Aksi</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @foreach($majelis as $anggota)
                    <tr class="hover:bg-slate-50 transition-colors">
                        <td class="px-6 py-4">
                            <x-profile-photo :foto="$anggota['foto']" :nama="$anggota['nama']" size="sm" />
                        </td>
                        <td class="px-6 py-4">
                            <span class="font-medium" style="color: #1e3a5f;">{{ $anggota['nama'] }}</span>
                        </td>
                        <td class="px-6 py-4 text-gray-600">{{ $anggota['jabatan'] }}</td>
                        <td class="px-6 py-4 text-gray-600">{{ $anggota['bidang'] }}</td>
                        <td class="px-6 py-4 text-center">
                            <div class="flex items-center justify-center gap-2">
                                <button onclick="openEditModal({{ json_encode($anggota) }})" class="p-2 rounded-lg hover:bg-blue-50 text-blue-600 transition-colors" title="Edit">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/></svg>
                                </button>
                                @if($anggota['foto'])
                                <form action="{{ route('admin.profil.majelis.photo.delete', $anggota['id']) }}" method="POST" class="inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" onclick="return confirm('Hapus foto?')" class="p-2 rounded-lg hover:bg-orange-50 text-orange-600 transition-colors" title="Hapus Foto">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
                                    </button>
                                </form>
                                @endif
                                <form action="{{ route('admin.profil.majelis.destroy', $anggota['id']) }}" method="POST" class="inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" onclick="return confirm('Hapus anggota majelis ini?')" class="p-2 rounded-lg hover:bg-red-50 text-red-600 transition-colors" title="Hapus">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/></svg>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <!-- Rekening Bank -->
    <div class="bg-white rounded-2xl shadow-material-1 overflow-hidden">
        <div class="px-6 py-4 border-b flex items-center justify-between" style="background: rgba(34,197,94,0.1);">
            <h2 class="text-lg font-bold" style="color: #1e3a5f;">Rekening Bank Donasi</h2>
            <button onclick="document.getElementById('modal-tambah-rekening').classList.remove('hidden')" class="px-4 py-2 rounded-xl font-semibold text-sm transition-all" style="background: #1e3a5f; color: #ffffff;">
                + Tambah Rekening
            </button>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead style="background: rgba(30,58,95,0.03);">
                    <tr>
                        <th class="px-6 py-4 text-left text-sm font-semibold" style="color: #1e3a5f;">Bank</th>
                        <th class="px-6 py-4 text-left text-sm font-semibold" style="color: #1e3a5f;">Nomor Rekening</th>
                        <th class="px-6 py-4 text-left text-sm font-semibold" style="color: #1e3a5f;">Atas Nama</th>
                        <th class="px-6 py-4 text-center text-sm font-semibold" style="color: #1e3a5f;">Status</th>
                        <th class="px-6 py-4 text-center text-sm font-semibold" style="color: #1e3a5f;">Aksi</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @forelse($rekeningList as $rekening)
                    <tr class="hover:bg-slate-50 transition-colors">
                        <td class="px-6 py-4">
                            <span class="font-medium" style="color: #1e3a5f;">{{ $rekening['nama_bank'] }}</span>
                            @if($rekening['is_primary'])
                            <span class="ml-2 px-2 py-0.5 bg-yellow-100 text-yellow-700 text-xs rounded-full">Utama</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 font-mono text-gray-700">{{ $rekening['nomor_rekening'] }}</td>
                        <td class="px-6 py-4 text-gray-600">{{ $rekening['atas_nama'] }}</td>
                        <td class="px-6 py-4 text-center">
                            <span class="px-2 py-1 rounded-full text-xs font-semibold {{ $rekening['aktif'] ? 'bg-green-100 text-green-700' : 'bg-gray-100 text-gray-600' }}">
                                {{ $rekening['aktif'] ? 'Aktif' : 'Nonaktif' }}
                            </span>
                        </td>
                        <td class="px-6 py-4 text-center">
                            <div class="flex items-center justify-center gap-2">
                                <button onclick="openEditRekeningModal({{ json_encode($rekening) }})" class="p-2 rounded-lg hover:bg-blue-50 text-blue-600 transition-colors" title="Edit">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/></svg>
                                </button>
                                <form action="{{ route('admin.profil.rekening.destroy', $rekening['id']) }}" method="POST" class="inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" onclick="return confirm('Hapus rekening ini?')" class="p-2 rounded-lg hover:bg-red-50 text-red-600 transition-colors" title="Hapus">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/></svg>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="px-6 py-8 text-center text-gray-500">
                            Belum ada rekening bank. Klik tombol "Tambah Rekening" untuk menambahkan.
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal Tambah Rekening -->
<div id="modal-tambah-rekening" class="hidden fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-4">
    <div class="bg-white rounded-2xl w-full max-w-md shadow-material-4">
        <div class="px-6 py-4 border-b flex items-center justify-between">
            <h3 class="text-lg font-bold" style="color: #1e3a5f;">Tambah Rekening Bank</h3>
            <button onclick="document.getElementById('modal-tambah-rekening').classList.add('hidden')" class="p-2 hover:bg-gray-100 rounded-lg">
                <svg class="w-5 h-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
            </button>
        </div>
        <form action="{{ route('admin.profil.rekening.store') }}" method="POST" class="p-6 space-y-4">
            @csrf
            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Nama Bank *</label>
                <input type="text" name="nama_bank" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400" placeholder="Contoh: Bank BRI">
            </div>
            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Nomor Rekening *</label>
                <input type="text" name="nomor_rekening" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400" placeholder="Contoh: 1234-5678-9012-3456">
            </div>
            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Atas Nama *</label>
                <input type="text" name="atas_nama" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400" placeholder="Contoh: Gereja Jemaat Buntu Ambaang">
            </div>
            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Kode Bank (Opsional)</label>
                <input type="text" name="kode_bank" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400" placeholder="Contoh: 002">
            </div>
            <div class="flex gap-4">
                <label class="flex items-center">
                    <input type="checkbox" name="is_primary" value="1" class="w-4 h-4 mr-2 rounded border-gray-300">
                    <span class="text-sm" style="color: #1e3a5f;">Rekening Utama</span>
                </label>
                <label class="flex items-center">
                    <input type="checkbox" name="aktif" value="1" checked class="w-4 h-4 mr-2 rounded border-gray-300">
                    <span class="text-sm" style="color: #1e3a5f;">Aktif</span>
                </label>
            </div>
            <div class="flex gap-3 pt-4">
                <button type="button" onclick="document.getElementById('modal-tambah-rekening').classList.add('hidden')" class="flex-1 px-4 py-3 rounded-xl font-semibold border-2 border-gray-200 hover:bg-gray-50 transition-colors">
                    Batal
                </button>
                <button type="submit" class="flex-1 px-4 py-3 rounded-xl font-semibold transition-all" style="background: #1e3a5f; color: #ffffff;">
                    Simpan
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Modal Edit Rekening -->
<div id="modal-edit-rekening" class="hidden fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-4">
    <div class="bg-white rounded-2xl w-full max-w-md shadow-material-4">
        <div class="px-6 py-4 border-b flex items-center justify-between">
            <h3 class="text-lg font-bold" style="color: #1e3a5f;">Edit Rekening Bank</h3>
            <button onclick="document.getElementById('modal-edit-rekening').classList.add('hidden')" class="p-2 hover:bg-gray-100 rounded-lg">
                <svg class="w-5 h-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
            </button>
        </div>
        <form id="form-edit-rekening" action="" method="POST" class="p-6 space-y-4">
            @csrf
            @method('PUT')
            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Nama Bank *</label>
                <input type="text" name="nama_bank" id="edit-nama-bank" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
            </div>
            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Nomor Rekening *</label>
                <input type="text" name="nomor_rekening" id="edit-nomor-rekening" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
            </div>
            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Atas Nama *</label>
                <input type="text" name="atas_nama" id="edit-atas-nama" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
            </div>
            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Kode Bank (Opsional)</label>
                <input type="text" name="kode_bank" id="edit-kode-bank" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
            </div>
            <div class="flex gap-4">
                <label class="flex items-center">
                    <input type="checkbox" name="is_primary" id="edit-is-primary" value="1" class="w-4 h-4 mr-2 rounded border-gray-300">
                    <span class="text-sm" style="color: #1e3a5f;">Rekening Utama</span>
                </label>
                <label class="flex items-center">
                    <input type="checkbox" name="aktif" id="edit-aktif" value="1" class="w-4 h-4 mr-2 rounded border-gray-300">
                    <span class="text-sm" style="color: #1e3a5f;">Aktif</span>
                </label>
            </div>
            <div class="flex gap-3 pt-4">
                <button type="button" onclick="document.getElementById('modal-edit-rekening').classList.add('hidden')" class="flex-1 px-4 py-3 rounded-xl font-semibold border-2 border-gray-200 hover:bg-gray-50 transition-colors">
                    Batal
                </button>
                <button type="submit" class="flex-1 px-4 py-3 rounded-xl font-semibold transition-all" style="background: #1e3a5f; color: #ffffff;">
                    Simpan
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Modal Tambah Majelis -->
<div id="modal-tambah-majelis" class="hidden fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-4">
    <div class="bg-white rounded-2xl w-full max-w-md shadow-material-4">
        <div class="px-6 py-4 border-b flex items-center justify-between">
            <h3 class="text-lg font-bold" style="color: #1e3a5f;">Tambah Anggota Majelis</h3>
            <button onclick="document.getElementById('modal-tambah-majelis').classList.add('hidden')" class="p-2 hover:bg-gray-100 rounded-lg">
                <svg class="w-5 h-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
            </button>
        </div>
        <form action="{{ route('admin.profil.majelis.store') }}" method="POST" enctype="multipart/form-data" class="p-6 space-y-4">
            @csrf
            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Foto Profil</label>
                <input type="file" name="foto" accept="image/jpeg,image/png,image/webp" 
                    class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                <p class="text-xs text-gray-500 mt-1">JPG, PNG, WEBP. Maks 2MB (opsional)</p>
            </div>
            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Nama Lengkap</label>
                <input type="text" name="nama" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
            </div>
            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Jabatan</label>
                <select name="jabatan" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                    <option value="">Pilih Jabatan</option>
                    <option value="Ketua Majelis">Ketua Majelis</option>
                    <option value="Wakil Ketua Majelis">Wakil Ketua Majelis</option>
                    <option value="Sekretaris Majelis">Sekretaris Majelis</option>
                    <option value="Bendahara Majelis">Bendahara Majelis</option>
                    <option value="Anggota Majelis">Anggota Majelis</option>
                </select>
            </div>
            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Bidang</label>
                <input type="text" name="bidang" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400" placeholder="Contoh: Bidang Ibadah">
            </div>
            <div class="flex gap-3 pt-4">
                <button type="button" onclick="document.getElementById('modal-tambah-majelis').classList.add('hidden')" class="flex-1 px-4 py-3 rounded-xl font-semibold border-2 border-gray-200 hover:bg-gray-50 transition-colors">
                    Batal
                </button>
                <button type="submit" class="flex-1 px-4 py-3 rounded-xl font-semibold transition-all" style="background: #1e3a5f; color: #ffffff;">
                    Simpan
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Modal Edit Majelis -->
<div id="modal-edit-majelis" class="hidden fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-4">
    <div class="bg-white rounded-2xl w-full max-w-md shadow-material-4">
        <div class="px-6 py-4 border-b flex items-center justify-between">
            <h3 class="text-lg font-bold" style="color: #1e3a5f;">Edit Anggota Majelis</h3>
            <button onclick="document.getElementById('modal-edit-majelis').classList.add('hidden')" class="p-2 hover:bg-gray-100 rounded-lg">
                <svg class="w-5 h-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
            </button>
        </div>
        <form id="form-edit-majelis" action="" method="POST" enctype="multipart/form-data" class="p-6 space-y-4">
            @csrf
            @method('PUT')
            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Foto Profil</label>
                <div id="edit-foto-preview" class="mb-2"></div>
                <input type="file" name="foto" accept="image/jpeg,image/png,image/webp" 
                    class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                <p class="text-xs text-gray-500 mt-1">JPG, PNG, WEBP. Maks 2MB (kosongkan jika tidak ingin mengubah)</p>
            </div>
            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Nama Lengkap</label>
                <input type="text" name="nama" id="edit-nama" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
            </div>
            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Jabatan</label>
                <select name="jabatan" id="edit-jabatan" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                    <option value="">Pilih Jabatan</option>
                    <option value="Ketua Majelis">Ketua Majelis</option>
                    <option value="Wakil Ketua Majelis">Wakil Ketua Majelis</option>
                    <option value="Sekretaris Majelis">Sekretaris Majelis</option>
                    <option value="Bendahara Majelis">Bendahara Majelis</option>
                    <option value="Anggota Majelis">Anggota Majelis</option>
                </select>
            </div>
            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Bidang</label>
                <input type="text" name="bidang" id="edit-bidang" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
            </div>
            <div class="flex gap-3 pt-4">
                <button type="button" onclick="document.getElementById('modal-edit-majelis').classList.add('hidden')" class="flex-1 px-4 py-3 rounded-xl font-semibold border-2 border-gray-200 hover:bg-gray-50 transition-colors">
                    Batal
                </button>
                <button type="submit" class="flex-1 px-4 py-3 rounded-xl font-semibold transition-all" style="background: #1e3a5f; color: #ffffff;">
                    Simpan
                </button>
            </div>
        </form>
    </div>
</div>

<script>
function openEditModal(anggota) {
    document.getElementById('form-edit-majelis').action = '/admin/profil/majelis/' + anggota.id;
    document.getElementById('edit-nama').value = anggota.nama;
    document.getElementById('edit-jabatan').value = anggota.jabatan;
    document.getElementById('edit-bidang').value = anggota.bidang;
    
    // Show foto preview
    const fotoPreview = document.getElementById('edit-foto-preview');
    if (anggota.foto) {
        fotoPreview.innerHTML = '<img src="/images/' + anggota.foto + '" class="w-16 h-16 rounded-full object-cover mx-auto">';
    } else {
        fotoPreview.innerHTML = '<div class="w-16 h-16 rounded-full flex items-center justify-center mx-auto" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);"><svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/></svg></div>';
    }
    
    document.getElementById('modal-edit-majelis').classList.remove('hidden');
}

function openEditRekeningModal(rekening) {
    document.getElementById('form-edit-rekening').action = '/admin/profil/rekening/' + rekening.id;
    document.getElementById('edit-nama-bank').value = rekening.nama_bank;
    document.getElementById('edit-nomor-rekening').value = rekening.nomor_rekening;
    document.getElementById('edit-atas-nama').value = rekening.atas_nama;
    document.getElementById('edit-kode-bank').value = rekening.kode_bank || '';
    document.getElementById('edit-is-primary').checked = rekening.is_primary;
    document.getElementById('edit-aktif').checked = rekening.aktif;
    
    document.getElementById('modal-edit-rekening').classList.remove('hidden');
}
</script>
@endsection
