@extends('layouts.admin')

@section('title', isset($user) ? 'Edit Pengguna' : 'Tambah Pengguna')
@section('page-title', isset($user) ? 'Edit Pengguna' : 'Tambah Pengguna')

@section('content')
<div class="max-w-2xl">
    <div class="bg-white rounded-xl shadow-md p-6">
        <form action="{{ isset($user) ? route('admin.user.update', $user->id) : route('admin.user.store') }}" method="POST" class="space-y-6">
            @csrf
            @if(isset($user))
                @method('PUT')
            @endif

            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Nama *</label>
                <input type="text" name="name" value="{{ $user->name ?? old('name') }}" required 
                    class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                    placeholder="Nama lengkap">
            </div>

            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Email *</label>
                <input type="email" name="email" value="{{ $user->email ?? old('email') }}" required 
                    class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                    placeholder="email@gereja.org">
            </div>

            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Password {{ isset($user) ? '(kosongkan jika tidak diubah)' : '*' }}</label>
                <input type="password" name="password" {{ isset($user) ? '' : 'required' }}
                    class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                    placeholder="Minimal 6 karakter">
            </div>

            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Role *</label>
                <select name="role" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                    <option value="">Pilih Role</option>
                    @foreach(\App\Models\User::getRoles() as $value => $label)
                    <option value="{{ $value }}" {{ (isset($user) && $user->role == $value) ? 'selected' : '' }}>{{ $label }}</option>
                    @endforeach
                </select>
                <p class="text-xs text-gray-500 mt-1">Admin: Akses penuh | Pendeta: Akses terbatas (read-only)</p>
            </div>

            <div>
                <label class="flex items-center">
                    <input type="checkbox" name="is_active" value="1" {{ (isset($user) && $user->is_active) ? 'checked' : (!isset($user) ? 'checked' : '') }} 
                        class="w-5 h-5 mr-3 rounded border-gray-300">
                    <span class="text-sm font-semibold" style="color: #1e3a5f;">Akun Aktif</span>
                </label>
            </div>

            <div class="flex items-center gap-4 pt-4">
                <button type="submit" class="px-6 py-3 rounded-xl font-semibold transition-all shadow-material-1 hover:shadow-material-2" style="background: #1e3a5f; color: #ffffff;">
                    {{ isset($user) ? 'Update Pengguna' : 'Simpan Pengguna' }}
                </button>
                <a href="{{ route('admin.user.index') }}" class="px-6 py-3 rounded-xl font-semibold bg-gray-200 text-gray-700 hover:bg-gray-300 transition-all">
                    Batal
                </a>
            </div>
        </form>
    </div>
</div>
@endsection
