@props([
    'foto' => null,
    'nama' => '',
    'size' => 'md', // sm, md, lg, xl
    'class' => ''
])

@php
$sizes = [
    'sm' => ['container' => 'w-12 h-12', 'icon' => 'w-6 h-6'],
    'md' => ['container' => 'w-16 h-16', 'icon' => 'w-8 h-8'],
    'lg' => ['container' => 'w-24 h-24', 'icon' => 'w-12 h-12'],
    'xl' => ['container' => 'w-32 h-32', 'icon' => 'w-16 h-16'],
];
$sizeClass = $sizes[$size] ?? $sizes['md'];
$hasPhoto = $foto && file_exists(public_path('images/' . $foto));
@endphp

@if($hasPhoto)
    <img 
        src="{{ asset('images/' . $foto) }}" 
        alt="Foto {{ $nama }}"
        class="rounded-full object-cover {{ $sizeClass['container'] }} {{ $class }}"
        onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';"
    >
    {{-- Fallback jika gambar gagal load --}}
    <div 
        class="rounded-full flex items-center justify-center {{ $sizeClass['container'] }} {{ $class }}" 
        style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%); display: none;"
    >
        <svg class="{{ $sizeClass['icon'] }} text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
        </svg>
    </div>
@else
    {{-- Default icon ketika tidak ada foto --}}
    <div 
        class="rounded-full flex items-center justify-center {{ $sizeClass['container'] }} {{ $class }}" 
        style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);"
    >
        <svg class="{{ $sizeClass['icon'] }} text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
        </svg>
    </div>
@endif
