<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Pendeta Dashboard') - Gereja Buntu Ambaang</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <style>
        /* Pendeta-specific base styles - matching Admin structure */
        .pendeta-layout {
            font-family: 'Nunito', sans-serif;
        }

        .pendeta-layout * {
            font-family: inherit;
        }

        /* Smooth scrollbar for sidebar */
        .pendeta-sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .pendeta-sidebar::-webkit-scrollbar-track {
            background: transparent;
        }

        .pendeta-sidebar::-webkit-scrollbar-thumb {
            background: rgba(255, 255, 255, 0.2);
            border-radius: 3px;
        }

        .pendeta-sidebar::-webkit-scrollbar-thumb:hover {
            background: rgba(255, 255, 255, 0.3);
        }

        /* Focus visible for accessibility */
        .pendeta-layout *:focus-visible {
            outline: 2px solid #d4af37;
            outline-offset: 2px;
        }

        /* Material ripple effect */
        .pendeta-ripple {
            position: relative;
            overflow: hidden;
        }

        .pendeta-ripple::after {
            content: '';
            position: absolute;
            inset: 0;
            background: radial-gradient(circle, rgba(255, 255, 255, 0.3) 10%, transparent 10%);
            transform: scale(10);
            opacity: 0;
            transition: transform 0.5s, opacity 0.3s;
        }

        .pendeta-ripple:active::after {
            transform: scale(0);
            opacity: 1;
            transition: 0s;
        }
    </style>
</head>

<body class="pendeta-layout bg-slate-50 text-slate-700 antialiased">
    <div class="flex min-h-screen">

        <!-- ===== SIDEBAR ===== -->
        <aside id="sidebar"
            class="pendeta-sidebar w-[280px] bg-gradient-to-b from-[#1e3a5f] to-[#152a45] text-white fixed h-full z-40 transform -translate-x-full lg:translate-x-0 transition-all duration-300 ease-in-out shadow-2xl overflow-y-auto">

            <!-- Logo Section -->
            <div class="px-6 py-6 border-b border-white/10">
                <div class="flex items-center gap-3">
                    <div class="w-11 h-11 rounded-xl bg-[#d4af37] flex items-center justify-center shadow-lg">
                        <svg class="w-6 h-6 text-[#1e3a5f]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                        </svg>
                    </div>
                    <div>
                        <h1 class="text-lg font-bold text-[#d4af37] leading-tight">Panel Pendeta</h1>
                        <p class="text-xs text-slate-300 font-medium">Gereja Buntu Ambaang</p>
                    </div>
                </div>
            </div>

            <!-- Navigation -->
            <nav class="p-4 space-y-1.5">
                <!-- Menu Label -->
                <p class="px-4 py-2 text-xs font-semibold text-slate-400 uppercase tracking-wider">Menu Utama</p>

                <!-- Dashboard -->
                <a href="{{ route('pendeta.dashboard') }}"
                    class="pendeta-nav-item group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] transition-all duration-200 {{ request()->routeIs('pendeta.dashboard') ? 'bg-white/15 text-white shadow-inner' : 'text-slate-300 hover:bg-white/10 hover:text-white' }}">
                    <span
                        class="w-9 h-9 rounded-lg flex items-center justify-center transition-all duration-200 {{ request()->routeIs('pendeta.dashboard') ? 'bg-[#d4af37] text-[#1e3a5f]' : 'bg-white/10 group-hover:bg-white/15' }}">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z" />
                        </svg>
                    </span>
                    Dashboard
                </a>

                <!-- Divider -->
                <div class="my-4 border-t border-white/10"></div>
                <p class="px-4 py-2 text-xs font-semibold text-slate-400 uppercase tracking-wider">Pelayanan</p>

                <!-- Data Jemaat (Read-Only) -->
                <a href="{{ route('pendeta.jemaat.index') }}"
                    class="pendeta-nav-item group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] transition-all duration-200 {{ request()->routeIs('pendeta.jemaat.*') ? 'bg-white/15 text-white shadow-inner' : 'text-slate-300 hover:bg-white/10 hover:text-white' }}">
                    <span
                        class="w-9 h-9 rounded-lg flex items-center justify-center transition-all duration-200 {{ request()->routeIs('pendeta.jemaat.*') ? 'bg-[#d4af37] text-[#1e3a5f]' : 'bg-white/10 group-hover:bg-white/15' }}">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0z" />
                        </svg>
                    </span>
                    Data Jemaat
                </a>

                <!-- Formulir Doa & Konseling (Read-Only) -->
                <a href="{{ route('pendeta.formulir.index') }}"
                    class="pendeta-nav-item group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] transition-all duration-200 {{ request()->routeIs('pendeta.formulir.*') ? 'bg-white/15 text-white shadow-inner' : 'text-slate-300 hover:bg-white/10 hover:text-white' }}">
                    <span
                        class="w-9 h-9 rounded-lg flex items-center justify-center transition-all duration-200 {{ request()->routeIs('pendeta.formulir.*') ? 'bg-[#d4af37] text-[#1e3a5f]' : 'bg-white/10 group-hover:bg-white/15' }}">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                        </svg>
                    </span>
                    Doa & Konseling
                </a>

                <!-- Pesan Masuk (Read-Only) -->
                <a href="{{ route('pendeta.pesan.index') }}"
                    class="pendeta-nav-item group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] transition-all duration-200 {{ request()->routeIs('pendeta.pesan.*') ? 'bg-white/15 text-white shadow-inner' : 'text-slate-300 hover:bg-white/10 hover:text-white' }}">
                    <span
                        class="w-9 h-9 rounded-lg flex items-center justify-center transition-all duration-200 {{ request()->routeIs('pendeta.pesan.*') ? 'bg-[#d4af37] text-[#1e3a5f]' : 'bg-white/10 group-hover:bg-white/15' }}">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                        </svg>
                    </span>
                    <span class="flex items-center gap-2">
                        Pesan Masuk
                        @php
                            $pesanBelumDibaca = \App\Models\PesanKontak::jumlahBelumDibaca();
                        @endphp
                        @if($pesanBelumDibaca > 0)
                            <span
                                class="px-2 py-0.5 text-xs font-bold bg-red-500 text-white rounded-full">{{ $pesanBelumDibaca }}</span>
                        @endif
                    </span>
                </a>

                <!-- Spacer -->
                <div class="h-4"></div>

                <!-- Divider -->
                <div class="my-4 border-t border-white/10"></div>

                <!-- Lihat Website -->
                <a href="{{ route('beranda') }}" target="_blank"
                    class="group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] text-slate-400 hover:bg-white/5 hover:text-slate-300 transition-all duration-200">
                    <span
                        class="w-9 h-9 rounded-lg bg-white/5 flex items-center justify-center group-hover:bg-white/10 transition-all duration-200">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" />
                        </svg>
                    </span>
                    Lihat Website
                </a>

                <!-- Logout -->
                <form method="POST" action="{{ route('admin.logout') }}">
                    @csrf
                    <button type="submit"
                        class="w-full group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] text-red-300 hover:bg-red-500/20 hover:text-red-200 transition-all duration-200">
                        <span
                            class="w-9 h-9 rounded-lg bg-red-500/10 flex items-center justify-center group-hover:bg-red-500/20 transition-all duration-200">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                            </svg>
                        </span>
                        Keluar
                    </button>
                </form>
            </nav>
        </aside>

        <!-- ===== MAIN CONTENT ===== -->
        <div class="flex-1 lg:ml-[280px] min-h-screen flex flex-col">

            <!-- Top Header -->
            <header class="bg-white/80 backdrop-blur-xl sticky top-0 z-30 border-b border-slate-200/80">
                <div class="flex items-center justify-between px-6 lg:px-8 py-4">
                    <!-- Mobile Menu Toggle -->
                    <button id="sidebar-toggle"
                        class="lg:hidden p-2.5 rounded-xl hover:bg-slate-100 active:bg-slate-200 transition-colors duration-200">
                        <svg class="w-6 h-6 text-slate-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                    </button>

                    <!-- Page Title -->
                    <div class="flex-1 lg:flex-none">
                        <h2 class="text-xl lg:text-2xl font-bold text-[#1e3a5f]">@yield('page-title', 'Dashboard')</h2>
                    </div>

                    <!-- User Info -->
                    <div class="flex items-center gap-4">
                        <div class="hidden sm:flex items-center gap-3 px-4 py-2 bg-slate-50 rounded-xl">
                            <div
                                class="w-9 h-9 rounded-full bg-gradient-to-br from-[#1e3a5f] to-[#2d5a8a] flex items-center justify-center text-white font-bold text-sm shadow-md">
                                {{ substr(Auth::user()->name ?? 'P', 0, 1) }}
                            </div>
                            <div class="text-right">
                                <p class="text-sm font-semibold text-slate-700">{{ Auth::user()->name ?? 'Pendeta' }}
                                </p>
                                <p class="text-xs text-slate-500">Pendeta</p>
                            </div>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Page Content -->
            <main class="flex-1 p-6 lg:p-8">
                <!-- Success Alert -->
                @if(session('success'))
                    <div
                        class="mb-6 flex items-center gap-3 px-5 py-4 bg-emerald-50 border border-emerald-200 text-emerald-700 rounded-xl shadow-sm animate-fade-in">
                        <span class="flex-shrink-0 w-10 h-10 rounded-full bg-emerald-100 flex items-center justify-center">
                            <svg class="w-5 h-5 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                            </svg>
                        </span>
                        <p class="font-medium text-[15px]">{{ session('success') }}</p>
                    </div>
                @endif

                <!-- Error Alert -->
                @if(session('error'))
                    <div
                        class="mb-6 flex items-center gap-3 px-5 py-4 bg-red-50 border border-red-200 text-red-700 rounded-xl shadow-sm animate-fade-in">
                        <span class="flex-shrink-0 w-10 h-10 rounded-full bg-red-100 flex items-center justify-center">
                            <svg class="w-5 h-5 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </span>
                        <p class="font-medium text-[15px]">{{ session('error') }}</p>
                    </div>
                @endif

                <!-- Page Content -->
                @yield('content')
            </main>

            <!-- Footer -->
            <footer class="px-6 lg:px-8 py-4 border-t border-slate-200/80 bg-white/50">
                <p class="text-center text-sm text-slate-500">&copy; {{ date('Y') }} Gereja Jemaat Buntu Ambaang. Panel
                    Pendeta.</p>
            </footer>
        </div>
    </div>

    <!-- Mobile Sidebar Overlay -->
    <div id="sidebar-overlay"
        class="fixed inset-0 bg-black/60 backdrop-blur-sm z-30 hidden lg:hidden transition-opacity duration-300"></div>

    <script>
        // Sidebar Toggle
        const sidebar = document.getElementById('sidebar');
        const sidebarToggle = document.getElementById('sidebar-toggle');
        const sidebarOverlay = document.getElementById('sidebar-overlay');

        sidebarToggle?.addEventListener('click', () => {
            sidebar.classList.toggle('-translate-x-full');
            sidebarOverlay.classList.toggle('hidden');
        });

        sidebarOverlay?.addEventListener('click', () => {
            sidebar.classList.add('-translate-x-full');
            sidebarOverlay.classList.add('hidden');
        });

        // Auto-hide alerts after 5 seconds
        document.querySelectorAll('.animate-fade-in').forEach(alert => {
            setTimeout(() => {
                alert.style.opacity = '0';
                alert.style.transform = 'translateY(-10px)';
                setTimeout(() => alert.remove(), 300);
            }, 5000);
        });
    </script>

    <style>
        .animate-fade-in {
            animation: fadeIn 0.3s ease-out;
            transition: opacity 0.3s, transform 0.3s;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    </style>
</body>

</html>