@extends('layouts.pendeta')

@section('title', 'Dashboard Pendeta')
@section('page-title', 'Dashboard Pendeta')

@section('content')
<!-- Info Banner -->
<div class="mb-6 bg-amber-50 border border-amber-200 rounded-xl p-4">
    <div class="flex items-center gap-3">
        <svg class="w-6 h-6 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
        <p class="text-amber-800 text-sm font-medium">Panel ini memiliki akses terbatas (read-only). Untuk mengelola data, silakan hubungi Administrator.</p>
    </div>
</div>

<!-- Stats Cards -->
<div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-4 gap-5 lg:gap-6 mb-8">
    <!-- Total Jemaat -->
    <div class="bg-white rounded-2xl shadow-md hover:shadow-lg transition-shadow duration-300 p-6 border border-slate-100">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-slate-500 text-[15px] font-medium mb-1">Total Jemaat</p>
                <p class="text-3xl font-bold text-[#1e3a5f]">{{ $totalJemaat }}</p>
            </div>
            <div class="w-14 h-14 bg-gradient-to-br from-blue-100 to-blue-50 rounded-2xl flex items-center justify-center">
                <svg class="w-7 h-7 text-[#1e3a5f]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
            </div>
        </div>
        <div class="mt-4 pt-4 border-t border-slate-100">
            <a href="{{ route('pendeta.jemaat.index') }}" class="text-sm text-[#1e3a5f] hover:text-[#d4af37] font-medium">Lihat Data Jemaat &rarr;</a>
        </div>
    </div>

    <!-- Permohonan Doa -->
    <div class="bg-white rounded-2xl shadow-md hover:shadow-lg transition-shadow duration-300 p-6 border border-slate-100">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-slate-500 text-[15px] font-medium mb-1">Permohonan Doa</p>
                <p class="text-3xl font-bold text-[#d4af37]">{{ $permohonanDoa }}</p>
            </div>
            <div class="w-14 h-14 bg-gradient-to-br from-amber-100 to-amber-50 rounded-2xl flex items-center justify-center">
                <svg class="w-7 h-7 text-[#d4af37]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/></svg>
            </div>
        </div>
        <div class="mt-4 pt-4 border-t border-slate-100">
            <span class="text-sm text-slate-500">Menunggu didoakan</span>
        </div>
    </div>

    <!-- Konseling Pending -->
    <div class="bg-white rounded-2xl shadow-md hover:shadow-lg transition-shadow duration-300 p-6 border border-slate-100">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-slate-500 text-[15px] font-medium mb-1">Konseling Pending</p>
                <p class="text-3xl font-bold text-rose-600">{{ $konselingPending }}</p>
            </div>
            <div class="w-14 h-14 bg-gradient-to-br from-rose-100 to-rose-50 rounded-2xl flex items-center justify-center">
                <svg class="w-7 h-7 text-rose-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/></svg>
            </div>
        </div>
        <div class="mt-4 pt-4 border-t border-slate-100">
            <a href="{{ route('pendeta.formulir.index') }}" class="text-sm text-[#1e3a5f] hover:text-[#d4af37] font-medium">Lihat Formulir &rarr;</a>
        </div>
    </div>

    <!-- Pesan Belum Dibaca -->
    <div class="bg-white rounded-2xl shadow-md hover:shadow-lg transition-shadow duration-300 p-6 border border-slate-100">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-slate-500 text-[15px] font-medium mb-1">Pesan Masuk</p>
                <p class="text-3xl font-bold text-purple-600">{{ $pesanBelumDibaca }}</p>
            </div>
            <div class="w-14 h-14 bg-gradient-to-br from-purple-100 to-purple-50 rounded-2xl flex items-center justify-center">
                <svg class="w-7 h-7 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
            </div>
        </div>
        <div class="mt-4 pt-4 border-t border-slate-100">
            <a href="{{ route('pendeta.pesan.index') }}" class="text-sm text-[#1e3a5f] hover:text-[#d4af37] font-medium">Lihat Pesan &rarr;</a>
        </div>
    </div>
</div>

<!-- Notifikasi & Jadwal -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-5 lg:gap-6">
    <!-- Notifikasi Terbaru -->
    <div class="bg-white rounded-2xl shadow-md p-6 border border-slate-100">
        <h3 class="text-lg font-bold text-[#1e3a5f] mb-5 flex items-center gap-2">
            <span class="w-1.5 h-6 bg-[#d4af37] rounded-full"></span>
            Notifikasi Terbaru
        </h3>
        <div class="space-y-3">
            @forelse($notifikasi as $notif)
            <div class="flex items-start gap-4 p-4 bg-slate-50 rounded-xl hover:bg-slate-100 transition-colors duration-200">
                <div class="w-11 h-11 rounded-xl flex items-center justify-center flex-shrink-0 shadow-sm
                    {{ $notif['type'] == 'doa' ? 'bg-amber-100' : ($notif['type'] == 'pesan' ? 'bg-purple-100' : 'bg-blue-100') }}">
                    @if($notif['type'] == 'doa')
                    <svg class="w-5 h-5 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/></svg>
                    @elseif($notif['type'] == 'pesan')
                    <svg class="w-5 h-5 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                    @else
                    <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/></svg>
                    @endif
                </div>
                <div class="flex-grow min-w-0">
                    <p class="text-slate-700 font-medium text-[15px]">{{ $notif['pesan'] }}</p>
                    <p class="text-sm text-slate-500 mt-1">{{ $notif['waktu'] }}</p>
                </div>
            </div>
            @empty
            <div class="text-center py-8 text-slate-500">
                <svg class="w-12 h-12 mx-auto mb-3 text-slate-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"/></svg>
                <p>Belum ada notifikasi</p>
            </div>
            @endforelse
        </div>
    </div>

    <!-- Jadwal Ibadah -->
    <div class="bg-white rounded-2xl shadow-md p-6 border border-slate-100">
        <h3 class="text-lg font-bold text-[#1e3a5f] mb-5 flex items-center gap-2">
            <span class="w-1.5 h-6 bg-[#d4af37] rounded-full"></span>
            Jadwal Ibadah Minggu Ini
        </h3>
        <div class="overflow-x-auto rounded-xl border border-slate-200">
            <table class="w-full">
                <thead>
                    <tr class="bg-slate-50">
                        <th class="text-left py-3 px-4 text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Ibadah</th>
                        <th class="text-left py-3 px-4 text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Hari</th>
                        <th class="text-left py-3 px-4 text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Waktu</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-slate-100">
                    @forelse($jadwalMingguIni as $jadwal)
                    <tr class="hover:bg-slate-50/50 transition-colors duration-150">
                        <td class="py-3 px-4 font-semibold text-slate-800 text-[15px]">{{ $jadwal['nama'] }}</td>
                        <td class="py-3 px-4 text-slate-600 text-[15px]">{{ $jadwal['tanggal'] }}</td>
                        <td class="py-3 px-4 text-slate-600 text-[15px]">{{ $jadwal['waktu'] }}</td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="3" class="py-8 text-center text-slate-500">Belum ada jadwal</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
