@extends('layouts.pendeta')

@section('title', 'Detail Jemaat')
@section('page-title', 'Detail Jemaat')

@section('content')
<!-- Back Button -->
<div class="mb-6">
    <a href="{{ route('pendeta.jemaat.index') }}" class="inline-flex items-center gap-2 px-4 py-2 text-slate-600 hover:text-[#1e3a5f] font-semibold rounded-xl hover:bg-slate-100 transition-all duration-200">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/></svg>
        Kembali
    </a>
</div>

<!-- Detail Card -->
<div class="bg-white rounded-2xl shadow-md overflow-hidden">
    <!-- Header -->
    <div class="bg-gradient-to-r from-[#1e3a5f] to-[#2d5a8a] p-6">
        <div class="flex items-center gap-4">
            <div class="w-16 h-16 rounded-xl bg-white/20 flex items-center justify-center text-white font-bold text-2xl">
                {{ substr($jemaat->nama, 0, 1) }}
            </div>
            <div>
                <h2 class="text-xl font-bold text-white">{{ $jemaat->nama }}</h2>
                <p class="text-white/70 text-sm">{{ $jemaat->kode ?? 'N/A' }}</p>
            </div>
        </div>
    </div>

    <!-- Content -->
    <div class="p-6">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div class="space-y-4">
                <div>
                    <p class="text-sm text-slate-500">Jenis Kelamin</p>
                    <p class="font-semibold text-slate-800">{{ $jemaat->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan' }}</p>
                </div>
                <div>
                    <p class="text-sm text-slate-500">Tempat, Tanggal Lahir</p>
                    <p class="font-semibold text-slate-800">{{ $jemaat->tempat_lahir ?? '-' }}, {{ $jemaat->tanggal_lahir ? $jemaat->tanggal_lahir->format('d F Y') : '-' }}</p>
                </div>
                <div>
                    <p class="text-sm text-slate-500">Status Pernikahan</p>
                    <p class="font-semibold text-slate-800">{{ $jemaat->status_pernikahan ?? '-' }}</p>
                </div>
                <div>
                    <p class="text-sm text-slate-500">Pekerjaan</p>
                    <p class="font-semibold text-slate-800">{{ $jemaat->pekerjaan ?? '-' }}</p>
                </div>
            </div>
            <div class="space-y-4">
                <div>
                    <p class="text-sm text-slate-500">Nomor Telepon</p>
                    <p class="font-semibold text-slate-800">{{ $jemaat->telepon ?? '-' }}</p>
                </div>
                <div>
                    <p class="text-sm text-slate-500">Email</p>
                    <p class="font-semibold text-slate-800">{{ $jemaat->email ?? '-' }}</p>
                </div>
                <div>
                    <p class="text-sm text-slate-500">Alamat</p>
                    <p class="font-semibold text-slate-800">{{ $jemaat->alamat ?? '-' }}</p>
                </div>
                <div>
                    <p class="text-sm text-slate-500">Terdaftar Sejak</p>
                    <p class="font-semibold text-slate-800">{{ $jemaat->created_at->format('d F Y') }}</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
