@extends('layouts.pendeta')

@section('title', 'Detail Pesan')
@section('page-title', 'Detail Pesan')

@section('content')
<!-- Back Button -->
<div class="mb-6">
    <a href="{{ route('pendeta.pesan.index') }}" class="inline-flex items-center gap-2 px-4 py-2 text-slate-600 hover:text-[#1e3a5f] font-semibold rounded-xl hover:bg-slate-100 transition-all duration-200">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/></svg>
        Kembali
    </a>
</div>

<!-- Detail Card -->
<div class="bg-white rounded-2xl shadow-md overflow-hidden">
    <!-- Header -->
    <div class="bg-gradient-to-r from-[#1e3a5f] to-[#2d5a8a] p-6">
        <div class="flex items-start gap-4">
            <div class="w-14 h-14 rounded-xl bg-white/20 flex items-center justify-center flex-shrink-0">
                <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
            </div>
            <div>
                <h2 class="text-xl font-bold text-white mb-1">{{ $pesan->subjek }}</h2>
                <p class="text-white/70 text-sm">Dikirim pada {{ $pesan->created_at->format('d F Y, H:i') }} WIB</p>
            </div>
        </div>
    </div>

    <!-- Content -->
    <div class="p-6">
        <!-- Sender Info -->
        <div class="bg-slate-50 rounded-xl p-5 mb-6">
            <h3 class="text-sm font-semibold text-slate-500 uppercase tracking-wider mb-4">Informasi Pengirim</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <p class="text-sm text-slate-500 mb-1">Nama</p>
                    <p class="font-semibold text-[#1e3a5f] text-lg">{{ $pesan->nama }}</p>
                </div>
                <div>
                    <p class="text-sm text-slate-500 mb-1">Email</p>
                    <p class="font-semibold text-[#1e3a5f] text-lg">{{ $pesan->email }}</p>
                </div>
            </div>
        </div>

        <!-- Message Content -->
        <div class="mb-6">
            <h3 class="text-sm font-semibold text-slate-500 uppercase tracking-wider mb-4">Isi Pesan</h3>
            <div class="bg-slate-50 rounded-xl p-5">
                <p class="text-slate-700 text-[15px] leading-relaxed whitespace-pre-wrap">{{ $pesan->pesan }}</p>
            </div>
        </div>

        <!-- Status -->
        <div class="flex items-center gap-2 text-sm text-slate-500">
            @if($pesan->dibaca)
            <svg class="w-4 h-4 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
            <span>Sudah dibaca</span>
            @else
            <svg class="w-4 h-4 text-amber-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
            <span>Belum dibaca</span>
            @endif
        </div>
    </div>
</div>
@endsection
