@extends('layouts.public')

@section('title', 'Permohonan Doa - Gereja Jemaat Buntu Ambaang')

@section('content')
<!-- Header with Material Design -->
<section class="relative py-12 md:py-16 overflow-hidden" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
    <!-- Decorative elements -->
    <div class="absolute top-0 right-0 w-48 h-48 rounded-full opacity-10" style="background: #d4af37; filter: blur(50px);"></div>
    
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <a href="{{ route('formulir.index') }}" class="inline-flex items-center mb-4 transition-colors" style="color: #d4af37;">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/></svg>
            Kembali
        </a>
        <h1 class="text-3xl md:text-4xl font-bold" style="color: #ffffff; text-shadow: 0 2px 4px rgba(0,0,0,0.1);">
            Formulir Permohonan Doa
        </h1>
    </div>
</section>

<!-- Form -->
<section class="py-12 bg-slate-50">
    <div class="max-w-2xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="bg-white rounded-2xl shadow-material-2 p-8">
            <p class="text-gray-600 mb-8 text-lg">Sampaikan permohonan doa Anda. Pendeta dan majelis akan mendoakan Anda dalam persekutuan doa.</p>
            
            <form action="{{ route('formulir.doa.submit') }}" method="POST" class="space-y-6">
                @csrf
                <div>
                    <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Nama Lengkap *</label>
                    <input type="text" name="nama" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none transition-colors" style="focus:border-color: #1e3a5f;" placeholder="Masukkan nama lengkap Anda">
                </div>
                
                <div>
                    <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Nomor Telepon / WhatsApp *</label>
                    <input type="tel" name="telepon" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none transition-colors" placeholder="Contoh: 08123456789">
                </div>
                
                <div>
                    <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Alamat Email</label>
                    <input type="email" name="email" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none transition-colors" placeholder="email@contoh.com">
                </div>
                
                <div>
                    <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Kategori Permohonan *</label>
                    <select name="kategori" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none transition-colors">
                        <option value="">Pilih kategori</option>
                        <option value="kesehatan">Kesehatan</option>
                        <option value="keluarga">Keluarga</option>
                        <option value="pekerjaan">Pekerjaan / Usaha</option>
                        <option value="pendidikan">Pendidikan</option>
                        <option value="rohani">Pertumbuhan Rohani</option>
                        <option value="lainnya">Lainnya</option>
                    </select>
                </div>
                
                <div>
                    <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Isi Permohonan Doa *</label>
                    <textarea name="permohonan" rows="5" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none transition-colors" placeholder="Tuliskan permohonan doa Anda dengan lengkap..."></textarea>
                </div>
                
                <div class="flex items-start">
                    <input type="checkbox" name="privasi" id="privasi" class="mt-1 mr-3 w-5 h-5 rounded">
                    <label for="privasi" class="text-gray-600">Permohonan doa ini bersifat rahasia dan hanya disampaikan kepada pendeta</label>
                </div>
                
                <button type="submit" class="w-full px-8 py-4 rounded-xl font-bold text-lg transition-all shadow-material-1 hover:shadow-material-2" style="background: #1e3a5f; color: #ffffff;">
                    Kirim Permohonan Doa
                </button>
            </form>
        </div>
    </div>
</section>
@endsection
