@extends('layouts.public')

@section('title', 'Pendaftaran Anggota Jemaat - Gereja Jemaat Buntu Ambaang')

@section('content')
<!-- Header with Material Design -->
<section class="relative py-12 md:py-16 overflow-hidden" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
    <!-- Decorative elements -->
    <div class="absolute top-0 right-0 w-48 h-48 rounded-full opacity-10" style="background: #d4af37; filter: blur(50px);"></div>
    
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <a href="{{ route('formulir.index') }}" class="inline-flex items-center mb-4 transition-colors" style="color: #d4af37;">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/></svg>
            Kembali
        </a>
        <h1 class="text-3xl md:text-4xl font-bold" style="color: #ffffff; text-shadow: 0 2px 4px rgba(0,0,0,0.1);">
            Formulir Pendaftaran Anggota Jemaat
        </h1>
    </div>
</section>

<!-- Form -->
<section class="py-12 bg-slate-50">
    <div class="max-w-2xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="bg-white rounded-2xl shadow-material-2 p-8">
            <p class="text-gray-600 mb-8 text-lg">Daftarkan diri Anda sebagai anggota jemaat Gereja Buntu Ambaang. Semua field bertanda (*) wajib diisi.</p>
            
            @if($errors->any())
            <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-xl">
                <ul class="list-disc list-inside text-red-600 text-sm">
                    @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
            @endif
            
            <form action="{{ route('formulir.jemaat.submit') }}" method="POST" class="space-y-6">
                @csrf
                
                <!-- Nama Lengkap -->
                <div>
                    <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Nama Lengkap *</label>
                    <input type="text" name="nama" value="{{ old('nama') }}" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none focus:border-blue-500 transition-colors @error('nama') border-red-500 @enderror" placeholder="Masukkan nama lengkap">
                </div>
                
                <!-- Jenis Kelamin -->
                <div>
                    <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Jenis Kelamin *</label>
                    <div class="flex gap-6">
                        <label class="flex items-center cursor-pointer">
                            <input type="radio" name="jenis_kelamin" value="L" {{ old('jenis_kelamin') == 'L' ? 'checked' : '' }} required class="w-5 h-5 text-blue-600">
                            <span class="ml-2 text-base">Laki-laki</span>
                        </label>
                        <label class="flex items-center cursor-pointer">
                            <input type="radio" name="jenis_kelamin" value="P" {{ old('jenis_kelamin') == 'P' ? 'checked' : '' }} class="w-5 h-5 text-blue-600">
                            <span class="ml-2 text-base">Perempuan</span>
                        </label>
                    </div>
                </div>
                
                <!-- Tempat & Tanggal Lahir -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Tempat Lahir *</label>
                        <input type="text" name="tempat_lahir" value="{{ old('tempat_lahir') }}" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none focus:border-blue-500 transition-colors @error('tempat_lahir') border-red-500 @enderror" placeholder="Kota/Kabupaten">
                    </div>
                    <div>
                        <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Tanggal Lahir *</label>
                        <input type="date" name="tanggal_lahir" value="{{ old('tanggal_lahir') }}" required max="{{ date('Y-m-d') }}" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none focus:border-blue-500 transition-colors @error('tanggal_lahir') border-red-500 @enderror">
                    </div>
                </div>
                
                <!-- Alamat -->
                <div>
                    <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Alamat Lengkap *</label>
                    <textarea name="alamat" rows="3" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none focus:border-blue-500 transition-colors @error('alamat') border-red-500 @enderror" placeholder="Masukkan alamat lengkap (jalan, RT/RW, kelurahan, kecamatan)">{{ old('alamat') }}</textarea>
                </div>
                
                <!-- Telepon & Email -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Nomor Telepon/WhatsApp *</label>
                        <input type="tel" name="telepon" value="{{ old('telepon') }}" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none focus:border-blue-500 transition-colors @error('telepon') border-red-500 @enderror" placeholder="08xxxxxxxxxx">
                    </div>
                    <div>
                        <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Email</label>
                        <input type="email" name="email" value="{{ old('email') }}" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none focus:border-blue-500 transition-colors @error('email') border-red-500 @enderror" placeholder="email@contoh.com">
                    </div>
                </div>
                
                <!-- Status Pernikahan -->
                <div>
                    <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Status Pernikahan *</label>
                    <select name="status_pernikahan" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none focus:border-blue-500 transition-colors @error('status_pernikahan') border-red-500 @enderror">
                        <option value="">Pilih status pernikahan</option>
                        <option value="Belum Menikah" {{ old('status_pernikahan') == 'Belum Menikah' ? 'selected' : '' }}>Belum Menikah</option>
                        <option value="Menikah" {{ old('status_pernikahan') == 'Menikah' ? 'selected' : '' }}>Menikah</option>
                        <option value="Duda" {{ old('status_pernikahan') == 'Duda' ? 'selected' : '' }}>Duda</option>
                        <option value="Janda" {{ old('status_pernikahan') == 'Janda' ? 'selected' : '' }}>Janda</option>
                    </select>
                </div>
                
                <!-- Pekerjaan -->
                <div>
                    <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Pekerjaan *</label>
                    <input type="text" name="pekerjaan" value="{{ old('pekerjaan') }}" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none focus:border-blue-500 transition-colors @error('pekerjaan') border-red-500 @enderror" placeholder="Contoh: Pegawai Negeri, Wiraswasta, Pelajar, dll">
                </div>
                
                <!-- Info -->
                <div class="p-4 bg-blue-50 border border-blue-200 rounded-xl">
                    <div class="flex items-start gap-3">
                        <svg class="w-6 h-6 text-blue-500 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                        <div class="text-sm text-blue-700">
                            <p class="font-semibold mb-1">Informasi Penting:</p>
                            <ul class="list-disc list-inside space-y-1">
                                <li>Pendaftaran akan diverifikasi oleh admin gereja</li>
                                <li>Anda akan mendapat kode pendaftaran setelah submit</li>
                                <li>Status keanggotaan akan dikonfirmasi melalui telepon/email</li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <button type="submit" class="w-full px-8 py-4 rounded-xl font-bold text-lg transition-all shadow-material-1 hover:shadow-material-2" style="background: #1e3a5f; color: #ffffff;">
                    Daftar Sebagai Jemaat
                </button>
            </form>
        </div>
    </div>
</section>
@endsection
