@extends('layouts.public')

@section('title', 'Pendaftaran Kegiatan - Gereja Jemaat Buntu Ambaang')

@section('content')
    <!-- Header with Material Design -->
    <section class="relative py-12 md:py-16 overflow-hidden"
        style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
        <!-- Decorative elements -->
        <div class="absolute top-0 right-0 w-48 h-48 rounded-full opacity-10"
            style="background: #d4af37; filter: blur(50px);"></div>

        <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <a href="{{ route('formulir.index') }}" class="inline-flex items-center mb-4 transition-colors"
                style="color: #d4af37;">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                </svg>
                Kembali
            </a>
            <h1 class="text-3xl md:text-4xl font-bold" style="color: #ffffff; text-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                Formulir Pendaftaran Kegiatan
            </h1>
        </div>
    </section>

    <!-- Form -->
    <section class="py-12 bg-slate-50">
        <div class="max-w-2xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="bg-white rounded-2xl shadow-material-2 p-8">
                <p class="text-gray-600 mb-8 text-lg">Daftarkan diri Anda untuk mengikuti kegiatan dan program gereja.</p>

                <form action="{{ route('formulir.pendaftaran.submit') }}" method="POST" class="space-y-6">
                    @csrf
                    <div>
                        <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Nama Lengkap *</label>
                        <input type="text" name="nama" required
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none transition-colors">
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Nomor Telepon
                                *</label>
                            <input type="tel" name="telepon" required
                                class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none transition-colors">
                        </div>
                        <div>
                            <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Usia</label>
                            <input type="number" name="usia"
                                class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none transition-colors">
                        </div>
                    </div>

                    <div>
                        <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Alamat Email</label>
                        <input type="email" name="email"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none transition-colors">
                    </div>

                    <div>
                        <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Nama Kegiatan *</label>
                        <input type="text" name="kegiatan" required
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none transition-colors"
                            placeholder="Masukkan nama kegiatan...">
                    </div>

                    <div>
                        <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Catatan Tambahan</label>
                        <textarea name="catatan" rows="3"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none transition-colors"
                            placeholder="Informasi tambahan jika ada..."></textarea>
                    </div>

                    <button type="submit"
                        class="w-full px-8 py-4 rounded-xl font-bold text-lg transition-all shadow-material-1 hover:shadow-material-2"
                        style="background: #1e3a5f; color: #ffffff;">
                        Daftar Kegiatan
                    </button>
                </form>
            </div>
        </div>
    </section>
@endsection