@extends('layouts.public')

@section('title', 'Kalender Gereja - Gereja Jemaat Buntu Ambaang')

@section('content')
<!-- Header with Material Design -->
<section class="relative py-16 md:py-20 overflow-hidden" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
    <!-- Decorative elements -->
    <div class="absolute top-0 right-0 w-64 h-64 rounded-full opacity-10" style="background: #d4af37; filter: blur(60px);"></div>
    <div class="absolute bottom-0 left-0 w-48 h-48 rounded-full opacity-10" style="background: #ffffff; filter: blur(40px);"></div>
    
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <span class="inline-block px-4 py-1.5 rounded-full text-sm font-medium mb-4" style="background: rgba(212,175,55,0.2); color: #d4af37;">
            Jadwal & Agenda
        </span>
        <h1 class="text-3xl md:text-4xl lg:text-5xl font-bold mb-4" style="color: #ffffff; text-shadow: 0 2px 4px rgba(0,0,0,0.1);">
            Kalender Gereja
        </h1>
        <p class="text-lg md:text-xl max-w-2xl mx-auto" style="color: rgba(255,255,255,0.85);">
            Jadwal kegiatan dan ibadah bulanan
        </p>
    </div>
</section>

{{-- 
=============================================================================
DISABLED: Filter Kategori Kalender
Status: Dinonaktifkan sementara - Kode dipertahankan untuk aktivasi kembali
=============================================================================
--}}
{{-- 
<section class="py-6 bg-white border-b">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex flex-wrap gap-3 justify-center">
            <button class="px-6 py-2 rounded-full font-semibold transition-all" style="background: #1e3a5f; color: #ffffff;">Semua</button>
            <button class="px-6 py-2 rounded-full bg-gray-100 text-gray-700 font-semibold hover:bg-gray-200 transition-all">Ibadah</button>
            <button class="px-6 py-2 rounded-full bg-gray-100 text-gray-700 font-semibold hover:bg-gray-200 transition-all">OIG</button>
            <button class="px-6 py-2 rounded-full bg-gray-100 text-gray-700 font-semibold hover:bg-gray-200 transition-all">Acara Khusus</button>
        </div>
    </div>
</section>
--}}

{{-- 
=============================================================================
DISABLED: Kalender Grid UI  
Status: Dinonaktifkan sementara - Kode dipertahankan untuk aktivasi kembali
=============================================================================
--}}
{{-- 
<section class="py-12 bg-slate-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="bg-white rounded-2xl shadow-material-2 overflow-hidden">
            <div class="flex items-center justify-between px-6 py-4 border-b" style="background: #1e3a5f;">
                <button class="p-2 rounded-lg hover:bg-white/10 transition-colors">
                    <svg class="w-5 h-5" style="color: #ffffff;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/></svg>
                </button>
                <h3 class="text-xl font-bold" style="color: #ffffff;">{{ $bulan }} {{ $tahun }}</h3>
                <button class="p-2 rounded-lg hover:bg-white/10 transition-colors">
                    <svg class="w-5 h-5" style="color: #ffffff;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
                </button>
            </div>
            <div class="grid grid-cols-7 border-b">
                @foreach(['Min', 'Sen', 'Sel', 'Rab', 'Kam', 'Jum', 'Sab'] as $day)
                <div class="py-3 text-center text-sm font-semibold" style="color: #1e3a5f; background: rgba(30,58,95,0.05);">{{ $day }}</div>
                @endforeach
            </div>
            <div class="grid grid-cols-7">
                @foreach($kalender as $hari)
                <div class="min-h-24 p-2 border-b border-r {{ $hari['bulan_ini'] ? 'bg-white' : 'bg-gray-50' }} {{ $hari['hari_ini'] ? 'ring-2 ring-inset' : '' }}" style="{{ $hari['hari_ini'] ? 'ring-color: #d4af37;' : '' }}">
                    <span class="inline-flex items-center justify-center w-7 h-7 rounded-full text-sm {{ $hari['hari_ini'] ? 'font-bold' : '' }}" style="{{ $hari['hari_ini'] ? 'background: #d4af37; color: #1e3a5f;' : ($hari['bulan_ini'] ? 'color: #374151;' : 'color: #9ca3af;') }}">
                        {{ $hari['tanggal'] }}
                    </span>
                    @if(!empty($hari['events']))
                        @foreach(array_slice($hari['events'], 0, 2) as $event)
                        <div class="mt-1 px-2 py-1 rounded text-xs truncate" style="background: {{ $event['warna'] }}20; color: {{ $event['warna'] }};">
                            {{ $event['nama'] }}
                        </div>
                        @endforeach
                        @if(count($hari['events']) > 2)
                        <div class="mt-1 text-xs text-gray-500 px-2">+{{ count($hari['events']) - 2 }} lainnya</div>
                        @endif
                    @endif
                </div>
                @endforeach
            </div>
        </div>
    </div>
</section>
--}}

<!-- Event List -->
<section class="py-12 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-2xl font-bold mb-8" style="color: #1e3a5f;">Agenda Bulan Ini</h2>
        <div class="space-y-4">
            @foreach($agendaBulanIni as $event)
            <div class="bg-white rounded-2xl shadow-material-1 p-6 hover:shadow-material-2 transition-all border-l-4" style="border-color: {{ $event['warna'] }};">
                <div class="flex items-start gap-4">
                    <div class="text-center p-3 rounded-xl" style="background: {{ $event['warna'] }}15;">
                        <span class="block text-2xl font-bold" style="color: {{ $event['warna'] }};">{{ $event['hari'] }}</span>
                        <span class="text-sm text-gray-500">{{ $event['bulan_singkat'] }}</span>
                    </div>
                    <div class="flex-1">
                        <span class="inline-block px-2 py-0.5 rounded text-xs font-medium mb-2" style="background: {{ $event['warna'] }}20; color: {{ $event['warna'] }};">{{ $event['kategori'] }}</span>
                        <h3 class="text-lg font-bold" style="color: #1e3a5f;">{{ $event['nama'] }}</h3>
                        <p class="text-gray-600 text-sm mt-1">{{ $event['waktu'] }} - {{ $event['tempat'] }}</p>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>
@endsection
