@extends('layouts.public')

@section('title', $kegiatan['nama'] . ' - Gereja Jemaat Buntu Ambaang')

@section('content')
<!-- Header -->
<section class="bg-gereja-biru text-white py-12">
    <div class="container mx-auto px-4">
        <a href="{{ route('kegiatan.index') }}" class="inline-flex items-center text-gereja-emas hover:text-yellow-400 mb-4">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/></svg>
            Kembali ke Daftar Kegiatan
        </a>
        <h1 class="text-3xl md:text-4xl font-bold">{{ $kegiatan['nama'] }}</h1>
    </div>
</section>

<!-- Detail Kegiatan -->
<section class="py-12 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto">
            <!-- Info -->
            <div class="bg-gray-50 rounded-xl p-8 mb-8">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
                    <div class="text-center p-4 bg-white rounded-lg">
                        <svg class="w-8 h-8 mx-auto text-gereja-emas mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
                        <p class="text-gray-500 text-sm">Tanggal</p>
                        <p class="font-bold text-gereja-biru">{{ $kegiatan['tanggal'] }}</p>
                    </div>
                    <div class="text-center p-4 bg-white rounded-lg">
                        <svg class="w-8 h-8 mx-auto text-gereja-emas mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                        <p class="text-gray-500 text-sm">Waktu</p>
                        <p class="font-bold text-gereja-biru">{{ $kegiatan['waktu'] }}</p>
                    </div>
                    <div class="text-center p-4 bg-white rounded-lg">
                        <svg class="w-8 h-8 mx-auto text-gereja-emas mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/></svg>
                        <p class="text-gray-500 text-sm">Tempat</p>
                        <p class="font-bold text-gereja-biru">{{ $kegiatan['tempat'] }}</p>
                    </div>
                </div>
                <h2 class="text-2xl font-bold text-gereja-biru mb-4">Deskripsi</h2>
                <p class="text-gray-600 text-lg leading-relaxed">{{ $kegiatan['deskripsi'] }}</p>
            </div>

            <!-- Dokumentasi -->
            @if(isset($kegiatan['dokumentasi']) && count($kegiatan['dokumentasi']) > 0)
            <div class="bg-gray-50 rounded-xl p-8">
                <h2 class="text-2xl font-bold text-gereja-biru mb-6">Dokumentasi</h2>
                <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
                    @foreach($kegiatan['dokumentasi'] as $foto)
                    <div class="aspect-square bg-gray-300 rounded-lg overflow-hidden">
                        <img src="{{ $foto }}" alt="Dokumentasi" class="w-full h-full object-cover">
                    </div>
                    @endforeach
                </div>
            </div>
            @endif
        </div>
    </div>
</section>
@endsection

