@extends('layouts.public')

@section('title', 'Kontak & Komunikasi Rohani - Gereja Jemaat Buntu Ambaang')

@section('content')
<!-- Header -->
<section class="bg-gereja-biru text-white py-12">
    <div class="container mx-auto px-4 text-center">
        <h1 class="text-3xl md:text-4xl font-bold mb-4">Kontak & Komunikasi Rohani</h1>
        <p class="text-xl text-gray-300">Terhubung dengan gereja secara daring</p>
    </div>
</section>

<!-- Jadwal Ibadah Online -->
<section class="py-12 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto">
            <h2 class="text-2xl font-bold text-gereja-biru mb-8 text-center">Jadwal Ibadah & Pertemuan Daring</h2>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                @foreach($jadwalOnline as $jadwal)
                <div class="bg-gray-50 rounded-xl p-6 hover:shadow-lg transition">
                    <div class="flex items-start justify-between mb-4">
                        <div>
                            <h3 class="text-xl font-bold text-gereja-biru">{{ $jadwal['nama'] }}</h3>
                            <p class="text-gray-600">{{ $jadwal['hari'] }}, {{ $jadwal['waktu'] }}</p>
                        </div>
                        @if($jadwal['is_live'])
                        <span class="px-3 py-1 bg-red-500 text-white rounded-full text-sm font-bold animate-pulse">LIVE</span>
                        @endif
                    </div>
                    <p class="text-gray-600 mb-4">{{ $jadwal['deskripsi'] }}</p>
                    <div class="flex flex-col sm:flex-row gap-3">
                        @if($jadwal['zoom_link'])
                        <a href="{{ $jadwal['zoom_link'] }}" target="_blank" class="flex items-center justify-center px-6 py-3 bg-blue-600 text-white rounded-lg font-bold hover:bg-blue-700 transition">
                            <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 24 24"><path d="M4 3h16a2 2 0 012 2v14a2 2 0 01-2 2H4a2 2 0 01-2-2V5a2 2 0 012-2zm0 2v14h16V5H4zm2 2h6v2H6V7zm0 4h6v2H6v-2zm0 4h12v2H6v-2zm8-8h4v6h-4V7z"/></svg>
                            Zoom
                        </a>
                        @endif
                        @if($jadwal['meet_link'])
                        <a href="{{ $jadwal['meet_link'] }}" target="_blank" class="flex items-center justify-center px-6 py-3 bg-green-600 text-white rounded-lg font-bold hover:bg-green-700 transition">
                            <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/></svg>
                            Google Meet
                        </a>
                        @endif
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</section>

<!-- Permohonan Doa Sebelum Pertemuan -->
<section class="py-12 bg-gereja-emas">
    <div class="container mx-auto px-4">
        <div class="max-w-2xl mx-auto text-center">
            <h2 class="text-2xl font-bold text-gereja-biru mb-4">Permohonan Doa Sebelum Pertemuan</h2>
            <p class="text-gereja-biru mb-6">Sampaikan permohonan doa Anda sebelum mengikuti ibadah atau pertemuan daring</p>
            <a href="{{ route('formulir.doa') }}" class="inline-block bg-gereja-biru text-white px-8 py-4 rounded-lg font-bold text-lg hover:bg-gereja-biru-light transition">
                Kirim Permohonan Doa
            </a>
        </div>
    </div>
</section>

<!-- Kontak Gereja -->
<section class="py-12 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto">
            <h2 class="text-2xl font-bold text-gereja-biru mb-8 text-center">Hubungi Kami</h2>
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div class="bg-white rounded-xl p-6 text-center shadow-md">
                    <div class="w-16 h-16 mx-auto mb-4 bg-gereja-biru rounded-full flex items-center justify-center">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                    </div>
                    <h3 class="text-lg font-bold text-gereja-biru mb-2">Alamat</h3>
                    <p class="text-gray-600">Jl. Gereja No. 1<br>Buntu Ambaang<br>Sulawesi Selatan</p>
                </div>
                
                <div class="bg-white rounded-xl p-6 text-center shadow-md">
                    <div class="w-16 h-16 mx-auto mb-4 bg-gereja-biru rounded-full flex items-center justify-center">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/></svg>
                    </div>
                    <h3 class="text-lg font-bold text-gereja-biru mb-2">Telepon</h3>
                    <p class="text-gray-600">(0423) xxx-xxxx</p>
                    <p class="text-gray-600">+62 812-xxxx-xxxx</p>
                </div>
                
                <div class="bg-white rounded-xl p-6 text-center shadow-md">
                    <div class="w-16 h-16 mx-auto mb-4 bg-gereja-biru rounded-full flex items-center justify-center">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                    </div>
                    <h3 class="text-lg font-bold text-gereja-biru mb-2">Email</h3>
                    <p class="text-gray-600">info@gerejabuntuambaang.org</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Form Kontak -->
<section class="py-12 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-2xl mx-auto">
            <h2 class="text-2xl font-bold text-gereja-biru mb-8 text-center">Kirim Pesan</h2>
            <form action="{{ route('kontak.submit') }}" method="POST" class="space-y-6">
                @csrf
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-lg font-semibold text-gereja-biru mb-2">Nama *</label>
                        <input type="text" name="nama" required class="w-full px-4 py-4 border-2 border-gray-300 rounded-lg text-lg focus:border-gereja-biru focus:outline-none">
                    </div>
                    <div>
                        <label class="block text-lg font-semibold text-gereja-biru mb-2">Email *</label>
                        <input type="email" name="email" required class="w-full px-4 py-4 border-2 border-gray-300 rounded-lg text-lg focus:border-gereja-biru focus:outline-none">
                    </div>
                </div>
                <div>
                    <label class="block text-lg font-semibold text-gereja-biru mb-2">Subjek *</label>
                    <input type="text" name="subjek" required class="w-full px-4 py-4 border-2 border-gray-300 rounded-lg text-lg focus:border-gereja-biru focus:outline-none">
                </div>
                <div>
                    <label class="block text-lg font-semibold text-gereja-biru mb-2">Pesan *</label>
                    <textarea name="pesan" rows="5" required class="w-full px-4 py-4 border-2 border-gray-300 rounded-lg text-lg focus:border-gereja-biru focus:outline-none"></textarea>
                </div>
                <button type="submit" class="w-full bg-gereja-biru text-white px-8 py-4 rounded-lg font-bold text-lg hover:bg-gereja-biru-light transition">
                    Kirim Pesan
                </button>
            </form>
        </div>
    </div>
</section>
@endsection

