@extends('layouts.public')

@section('title', 'OIG - Gereja Jemaat Buntu Ambaang')

@section('content')
<!-- Header with Material Design -->
<section class="relative py-16 md:py-20 overflow-hidden" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
    <!-- Decorative elements -->
    <div class="absolute top-0 right-0 w-64 h-64 rounded-full opacity-10" style="background: #d4af37; filter: blur(60px);"></div>
    <div class="absolute bottom-0 left-0 w-48 h-48 rounded-full opacity-10" style="background: #ffffff; filter: blur(40px);"></div>
    
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <span class="inline-block px-4 py-1.5 rounded-full text-sm font-medium mb-4" style="background: rgba(212,175,55,0.2); color: #d4af37;">
            Organisasi Gereja
        </span>
        <h1 class="text-3xl md:text-4xl lg:text-5xl font-bold mb-4" style="color: #ffffff; text-shadow: 0 2px 4px rgba(0,0,0,0.1);">
            Organisasi Intra Gereja (OIG)
        </h1>
        <p class="text-lg md:text-xl max-w-2xl mx-auto" style="color: rgba(255,255,255,0.85);">
            Wadah persekutuan dan pelayanan jemaat
        </p>
    </div>
</section>

<!-- Daftar OIG -->
<section class="py-12 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
            @foreach($oigList as $oig)
            <div class="bg-white rounded-2xl shadow-material-1 overflow-hidden hover:shadow-material-3 transition-all duration-300">
                <div class="px-6 py-4" style="background: #1e3a5f;">
                    <h3 class="text-xl font-bold" style="color: #ffffff;">{{ $oig['nama'] }}</h3>
                </div>
                <div class="p-6">
                    <p class="text-gray-600 mb-4">{{ $oig['deskripsi'] }}</p>
                    <div class="border-t pt-4 mt-4 space-y-2">
                        <p class="text-sm text-gray-500 flex items-center gap-2">
                            <svg class="w-4 h-4" style="color: #d4af37;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/></svg>
                            <strong style="color: #1e3a5f;">Ketua:</strong> {{ $oig['ketua'] }}
                        </p>
                        <p class="text-sm text-gray-500 flex items-center gap-2">
                            <svg class="w-4 h-4" style="color: #d4af37;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                            <strong style="color: #1e3a5f;">Jadwal:</strong> {{ $oig['jadwal'] }}
                        </p>
                    </div>
                    <a href="{{ route('oig.show', $oig['slug']) }}" class="mt-4 inline-flex items-center font-semibold transition-colors" style="color: #d4af37;">
                        Lihat Detail
                        <svg class="w-4 h-4 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
                    </a>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>
@endsection
