@extends('layouts.public')

@section('title', $oig['nama'] . ' - Gereja Jemaat Buntu Ambaang')

@section('content')
    <!-- Header -->
    <section class="bg-gereja-biru text-white py-12">
        <div class="container mx-auto px-4">
            <a href="{{ route('oig.index') }}" class="inline-flex items-center text-gereja-emas hover:text-yellow-400 mb-4">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                </svg>
                Kembali ke Daftar OIG
            </a>
            <h1 class="text-3xl md:text-4xl font-bold">{{ $oig['nama'] }}</h1>
        </div>
    </section>

    <!-- Detail OIG -->
    <section class="py-12 bg-white">
        <div class="container mx-auto px-4">
            <div class="max-w-4xl mx-auto">
                <!-- Deskripsi -->
                <div class="bg-gray-50 rounded-xl p-8 mb-8">
                    <h2 class="text-2xl font-bold text-gereja-biru mb-4">Tentang {{ $oig['nama'] }}</h2>
                    <p class="text-gray-600 text-lg leading-relaxed">{{ $oig['deskripsi'] }}</p>
                </div>

                <!-- Struktur Pengurus -->
                <div class="bg-gray-50 rounded-xl p-8 mb-8">
                    <h2 class="text-2xl font-bold text-gereja-biru mb-6">Struktur Pengurus</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        @foreach($oig['pengurus'] as $p)
                            <div class="bg-white rounded-lg p-4 flex items-center">
                                <div class="w-12 h-12 bg-gereja-biru rounded-full flex items-center justify-center mr-4">
                                    <span class="text-white font-bold">{{ substr($p['nama'] ?? '', 0, 1) }}</span>
                                </div>
                                <div>
                                    <p class="font-bold text-gereja-biru">{{ $p['nama'] ?? '-' }}</p>
                                    <p class="text-sm text-gray-500">{{ $p['jabatan'] ?? '-' }}</p>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Jadwal Pertemuan -->
                <div class="bg-gereja-emas rounded-xl p-8">
                    <h2 class="text-2xl font-bold text-gereja-biru mb-4">Jadwal Pertemuan</h2>
                    <div class="flex items-center text-gereja-biru">
                        <svg class="w-8 h-8 mr-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                        </svg>
                        <p class="text-xl font-semibold">{{ $oig['jadwal'] }}</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection