<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PublicSite\BerandaController;
use App\Http\Controllers\PublicSite\JadwalIbadahController;
use App\Http\Controllers\PublicSite\OigController;
use App\Http\Controllers\PublicSite\KegiatanController;
use App\Http\Controllers\PublicSite\KalenderController;
use App\Http\Controllers\PublicSite\FormulirController;
use App\Http\Controllers\PublicSite\DonasiController;
use App\Http\Controllers\PublicSite\LaporanKeuanganController;
use App\Http\Controllers\PublicSite\KontakController;
use App\Http\Controllers\PublicSite\ProfilController;
use App\Http\Controllers\PublicSite\BeritaController;
use App\Http\Controllers\PublicSite\JemaatController;
use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\ProfilController as AdminProfilController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\JadwalController as AdminJadwalController;
use App\Http\Controllers\Admin\OigController as AdminOigController;
use App\Http\Controllers\Admin\KegiatanController as AdminKegiatanController;
use App\Http\Controllers\Admin\KalenderController as AdminKalenderController;
use App\Http\Controllers\Admin\FormulirController as AdminFormulirController;
use App\Http\Controllers\Admin\KeuanganController;
use App\Http\Controllers\Admin\KomunikasiController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\DonasiController as AdminDonasiController;
use App\Http\Controllers\Admin\BeritaController as AdminBeritaController;
use App\Http\Controllers\Admin\PengumumanController as AdminPengumumanController;
use App\Http\Controllers\Admin\PesanController;
use App\Http\Controllers\Admin\IbadahKhususController;
use App\Http\Controllers\Pendeta\DashboardController as PendetaDashboardController;
use App\Http\Controllers\Pendeta\JemaatController as PendetaJemaatController;
use App\Http\Controllers\Pendeta\PesanController as PendetaPesanController;
use App\Http\Controllers\Pendeta\FormulirController as PendetaFormulirController;

// ============================================
// PUBLIC ROUTES
// ============================================
Route::get('/', [BerandaController::class, 'index'])->name('beranda');
Route::get('/jadwal-ibadah', [JadwalIbadahController::class, 'index'])->name('jadwal-ibadah');

Route::get('/oig', [OigController::class, 'index'])->name('oig.index');
Route::get('/oig/{slug}', [OigController::class, 'show'])->name('oig.show');

Route::get('/kegiatan', [KegiatanController::class, 'index'])->name('kegiatan.index');
Route::get('/kegiatan/{slug}', [KegiatanController::class, 'show'])->name('kegiatan.show');

Route::get('/kalender', [KalenderController::class, 'index'])->name('kalender');

Route::get('/formulir', [FormulirController::class, 'index'])->name('formulir.index');
Route::get('/formulir/doa', [FormulirController::class, 'doa'])->name('formulir.doa');
Route::post('/formulir/doa', [FormulirController::class, 'doaSubmit'])->name('formulir.doa.submit');
Route::get('/formulir/pendaftaran', [FormulirController::class, 'pendaftaran'])->name('formulir.pendaftaran');
Route::post('/formulir/pendaftaran', [FormulirController::class, 'pendaftaranSubmit'])->name('formulir.pendaftaran.submit');
Route::get('/formulir/konseling', [FormulirController::class, 'konseling'])->name('formulir.konseling');
Route::post('/formulir/konseling', [FormulirController::class, 'konselingSubmit'])->name('formulir.konseling.submit');
Route::get('/formulir/jemaat', [JemaatController::class, 'create'])->name('formulir.jemaat');
Route::post('/formulir/jemaat', [JemaatController::class, 'store'])->name('formulir.jemaat.submit');

Route::get('/donasi', [DonasiController::class, 'index'])->name('donasi');
Route::post('/donasi/konfirmasi', [DonasiController::class, 'konfirmasi'])->name('donasi.konfirmasi');

Route::get('/laporan-keuangan', [LaporanKeuanganController::class, 'index'])->name('laporan-keuangan');

Route::get('/kontak', [KontakController::class, 'index'])->name('kontak');
Route::post('/kontak', [KontakController::class, 'submit'])->name('kontak.submit');

Route::get('/profil', [ProfilController::class, 'index'])->name('profil');

Route::get('/berita', [BeritaController::class, 'index'])->name('berita.index');
Route::get('/berita/{slug}', [BeritaController::class, 'show'])->name('berita.show');

// ============================================
// ADMIN ROUTES
// ============================================
Route::prefix('admin')->group(function () {
    Route::get('/login', [AuthController::class, 'showLogin'])->name('admin.login');
    Route::post('/login', [AuthController::class, 'login'])->name('admin.login.submit');
    Route::post('/logout', [AuthController::class, 'logout'])->name('admin.logout');

    // Protected admin routes (prototype without middleware)
    Route::get('/', [DashboardController::class, 'index'])->name('admin.dashboard');

    // Jadwal
    Route::get('/jadwal', [AdminJadwalController::class, 'index'])->name('admin.jadwal.index');
    Route::get('/jadwal/create', [AdminJadwalController::class, 'create'])->name('admin.jadwal.create');
    Route::post('/jadwal', [AdminJadwalController::class, 'store'])->name('admin.jadwal.store');
    Route::get('/jadwal/{id}/edit', [AdminJadwalController::class, 'edit'])->name('admin.jadwal.edit');
    Route::put('/jadwal/{id}', [AdminJadwalController::class, 'update'])->name('admin.jadwal.update');
    Route::delete('/jadwal/{id}', [AdminJadwalController::class, 'destroy'])->name('admin.jadwal.destroy');

    // Ibadah Khusus
    Route::get('/ibadah-khusus', [IbadahKhususController::class, 'index'])->name('admin.ibadah-khusus.index');
    Route::get('/ibadah-khusus/create', [IbadahKhususController::class, 'create'])->name('admin.ibadah-khusus.create');
    Route::post('/ibadah-khusus', [IbadahKhususController::class, 'store'])->name('admin.ibadah-khusus.store');
    Route::get('/ibadah-khusus/{id}/edit', [IbadahKhususController::class, 'edit'])->name('admin.ibadah-khusus.edit');
    Route::put('/ibadah-khusus/{id}', [IbadahKhususController::class, 'update'])->name('admin.ibadah-khusus.update');
    Route::delete('/ibadah-khusus/{id}', [IbadahKhususController::class, 'destroy'])->name('admin.ibadah-khusus.destroy');

    // OIG
    Route::get('/oig', [AdminOigController::class, 'index'])->name('admin.oig.index');
    Route::get('/oig/create', [AdminOigController::class, 'create'])->name('admin.oig.create');
    Route::post('/oig', [AdminOigController::class, 'store'])->name('admin.oig.store');
    Route::get('/oig/{id}/edit', [AdminOigController::class, 'edit'])->name('admin.oig.edit');
    Route::put('/oig/{id}', [AdminOigController::class, 'update'])->name('admin.oig.update');
    Route::delete('/oig/{id}', [AdminOigController::class, 'destroy'])->name('admin.oig.destroy');

    // Kegiatan
    Route::get('/kegiatan', [AdminKegiatanController::class, 'index'])->name('admin.kegiatan.index');
    Route::get('/kegiatan/create', [AdminKegiatanController::class, 'create'])->name('admin.kegiatan.create');
    Route::post('/kegiatan', [AdminKegiatanController::class, 'store'])->name('admin.kegiatan.store');
    Route::get('/kegiatan/{id}/edit', [AdminKegiatanController::class, 'edit'])->name('admin.kegiatan.edit');
    Route::put('/kegiatan/{id}', [AdminKegiatanController::class, 'update'])->name('admin.kegiatan.update');
    Route::delete('/kegiatan/{id}', [AdminKegiatanController::class, 'destroy'])->name('admin.kegiatan.destroy');

    // Berita
    Route::get('/berita', [AdminBeritaController::class, 'index'])->name('admin.berita.index');
    Route::get('/berita/create', [AdminBeritaController::class, 'create'])->name('admin.berita.create');
    Route::post('/berita', [AdminBeritaController::class, 'store'])->name('admin.berita.store');
    Route::get('/berita/{id}/edit', [AdminBeritaController::class, 'edit'])->name('admin.berita.edit');
    Route::put('/berita/{id}', [AdminBeritaController::class, 'update'])->name('admin.berita.update');
    Route::patch('/berita/{id}/toggle', [AdminBeritaController::class, 'toggleStatus'])->name('admin.berita.toggle');
    Route::delete('/berita/{id}', [AdminBeritaController::class, 'destroy'])->name('admin.berita.destroy');

    // Pengumuman
    Route::get('/pengumuman', [AdminPengumumanController::class, 'index'])->name('admin.pengumuman.index');
    Route::get('/pengumuman/create', [AdminPengumumanController::class, 'create'])->name('admin.pengumuman.create');
    Route::post('/pengumuman', [AdminPengumumanController::class, 'store'])->name('admin.pengumuman.store');
    Route::get('/pengumuman/{id}/edit', [AdminPengumumanController::class, 'edit'])->name('admin.pengumuman.edit');
    Route::put('/pengumuman/{id}', [AdminPengumumanController::class, 'update'])->name('admin.pengumuman.update');
    Route::patch('/pengumuman/{id}/toggle', [AdminPengumumanController::class, 'toggleStatus'])->name('admin.pengumuman.toggle');
    Route::delete('/pengumuman/{id}', [AdminPengumumanController::class, 'destroy'])->name('admin.pengumuman.destroy');

    // Kalender
    Route::get('/kalender', [AdminKalenderController::class, 'index'])->name('admin.kalender.index');
    Route::get('/kalender/create', [AdminKalenderController::class, 'create'])->name('admin.kalender.create');
    Route::post('/kalender', [AdminKalenderController::class, 'store'])->name('admin.kalender.store');
    Route::get('/kalender/{id}/edit', [AdminKalenderController::class, 'edit'])->name('admin.kalender.edit');
    Route::put('/kalender/{id}', [AdminKalenderController::class, 'update'])->name('admin.kalender.update');
    Route::delete('/kalender/{id}', [AdminKalenderController::class, 'destroy'])->name('admin.kalender.destroy');

    // Formulir
    Route::get('/formulir', [AdminFormulirController::class, 'index'])->name('admin.formulir.index');
    Route::get('/formulir/doa/{id}/status/{status}', [AdminFormulirController::class, 'updateStatusDoa'])->name('admin.formulir.doa.status');
    Route::patch('/formulir/doa/{id}/catatan', [AdminFormulirController::class, 'updateCatatanDoa'])->name('admin.formulir.doa.catatan');
    Route::delete('/formulir/doa/{id}', [AdminFormulirController::class, 'deleteDoa'])->name('admin.formulir.doa.delete');
    Route::delete('/formulir/pendaftaran/{id}', [AdminFormulirController::class, 'deletePendaftaran'])->name('admin.formulir.pendaftaran.delete');
    Route::patch('/formulir/pendaftaran/{id}/catatan', [AdminFormulirController::class, 'updateCatatanPendaftaran'])->name('admin.formulir.pendaftaran.catatan');
    Route::delete('/formulir/konseling/{id}', [AdminFormulirController::class, 'deleteKonseling'])->name('admin.formulir.konseling.delete');
    Route::get('/formulir/konseling/{id}/status/{status}', [AdminFormulirController::class, 'updateStatusKonseling'])->name('admin.formulir.konseling.status');
    Route::patch('/formulir/konseling/{id}/catatan', [AdminFormulirController::class, 'updateCatatanKonseling'])->name('admin.formulir.konseling.catatan');

    // Keuangan
    Route::get('/keuangan', [KeuanganController::class, 'index'])->name('admin.keuangan.index');
    Route::post('/keuangan', [KeuanganController::class, 'store'])->name('admin.keuangan.store');
    Route::delete('/keuangan/{id}', [KeuanganController::class, 'destroy'])->name('admin.keuangan.destroy');
    Route::get('/keuangan/export', [KeuanganController::class, 'export'])->name('admin.keuangan.export');

    // Donasi
    Route::get('/donasi', [AdminDonasiController::class, 'index'])->name('admin.donasi.index');
    Route::get('/donasi/create', [AdminDonasiController::class, 'create'])->name('admin.donasi.create');
    Route::post('/donasi', [AdminDonasiController::class, 'store'])->name('admin.donasi.store');
    Route::get('/donasi/{id}/edit', [AdminDonasiController::class, 'edit'])->name('admin.donasi.edit');
    Route::put('/donasi/{id}', [AdminDonasiController::class, 'update'])->name('admin.donasi.update');
    Route::patch('/donasi/{id}/status', [AdminDonasiController::class, 'updateStatus'])->name('admin.donasi.status');
    Route::delete('/donasi/{id}', [AdminDonasiController::class, 'destroy'])->name('admin.donasi.destroy');

    // Komunikasi
    Route::get('/komunikasi', [KomunikasiController::class, 'index'])->name('admin.komunikasi.index');
    Route::get('/komunikasi/create', [KomunikasiController::class, 'create'])->name('admin.komunikasi.create');
    Route::post('/komunikasi', [KomunikasiController::class, 'store'])->name('admin.komunikasi.store');
    Route::get('/komunikasi/{id}/edit', [KomunikasiController::class, 'edit'])->name('admin.komunikasi.edit');
    Route::put('/komunikasi/{id}', [KomunikasiController::class, 'update'])->name('admin.komunikasi.update');
    Route::delete('/komunikasi/{id}', [KomunikasiController::class, 'destroy'])->name('admin.komunikasi.destroy');

    // User
    Route::get('/user', [UserController::class, 'index'])->name('admin.user.index');
    Route::get('/user/create', [UserController::class, 'create'])->name('admin.user.create');
    Route::post('/user', [UserController::class, 'store'])->name('admin.user.store');
    Route::get('/user/{id}/edit', [UserController::class, 'edit'])->name('admin.user.edit');
    Route::put('/user/{id}', [UserController::class, 'update'])->name('admin.user.update');
    Route::delete('/user/{id}', [UserController::class, 'destroy'])->name('admin.user.destroy');
    Route::post('/user/{id}/reset', [UserController::class, 'reset'])->name('admin.user.reset');

    // Jemaat
    Route::post('/jemaat', [UserController::class, 'storeJemaat'])->name('admin.jemaat.store');
    Route::get('/jemaat/{id}', [UserController::class, 'showJemaat'])->name('admin.jemaat.show');
    Route::put('/jemaat/{id}', [UserController::class, 'updateJemaat'])->name('admin.jemaat.update');
    Route::patch('/jemaat/{id}/status', [UserController::class, 'updateStatusJemaat'])->name('admin.jemaat.status');
    Route::delete('/jemaat/{id}', [UserController::class, 'destroyJemaat'])->name('admin.jemaat.destroy');

    // Profil Gereja
    Route::get('/profil', [AdminProfilController::class, 'index'])->name('admin.profil.index');
    Route::put('/profil', [AdminProfilController::class, 'updateProfil'])->name('admin.profil.update');
    Route::put('/profil/pendeta', [AdminProfilController::class, 'updatePendeta'])->name('admin.profil.pendeta');
    Route::delete('/profil/pendeta/foto', [AdminProfilController::class, 'deletePendetaPhoto'])->name('admin.profil.pendeta.photo.delete');
    Route::post('/profil/majelis', [AdminProfilController::class, 'storeMajelis'])->name('admin.profil.majelis.store');
    Route::put('/profil/majelis/{id}', [AdminProfilController::class, 'updateMajelis'])->name('admin.profil.majelis.update');
    Route::delete('/profil/majelis/{id}', [AdminProfilController::class, 'destroyMajelis'])->name('admin.profil.majelis.destroy');
    Route::delete('/profil/majelis/{id}/foto', [AdminProfilController::class, 'deleteMajelisPhoto'])->name('admin.profil.majelis.photo.delete');

    // Rekening Bank
    Route::post('/profil/rekening', [AdminProfilController::class, 'storeRekening'])->name('admin.profil.rekening.store');
    Route::put('/profil/rekening/{id}', [AdminProfilController::class, 'updateRekening'])->name('admin.profil.rekening.update');
    Route::delete('/profil/rekening/{id}', [AdminProfilController::class, 'destroyRekening'])->name('admin.profil.rekening.destroy');

    // Pesan Kontak
    Route::get('/pesan', [PesanController::class, 'index'])->name('admin.pesan.index');
    Route::get('/pesan/{id}', [PesanController::class, 'show'])->name('admin.pesan.show');
    Route::patch('/pesan/{id}/toggle', [PesanController::class, 'toggleStatus'])->name('admin.pesan.toggle');
    Route::delete('/pesan/{id}', [PesanController::class, 'destroy'])->name('admin.pesan.destroy');
});

// ============================================
// PENDETA ROUTES (Read-Only Access)
// ============================================
Route::prefix('pendeta')->middleware('role:pendeta,admin')->group(function () {
    Route::get('/', [PendetaDashboardController::class, 'index'])->name('pendeta.dashboard');

    // Jemaat (Read-Only)
    Route::get('/jemaat', [PendetaJemaatController::class, 'index'])->name('pendeta.jemaat.index');
    Route::get('/jemaat/{id}', [PendetaJemaatController::class, 'show'])->name('pendeta.jemaat.show');

    // Pesan Kontak (Read-Only)
    Route::get('/pesan', [PendetaPesanController::class, 'index'])->name('pendeta.pesan.index');
    Route::get('/pesan/{id}', [PendetaPesanController::class, 'show'])->name('pendeta.pesan.show');

    // Formulir - Doa & Konseling (Full Access)
    Route::get('/formulir', [PendetaFormulirController::class, 'index'])->name('pendeta.formulir.index');
    Route::get('/formulir/doa/{id}/status/{status}', [PendetaFormulirController::class, 'updateStatusDoa'])->name('pendeta.formulir.doa.status');
    Route::patch('/formulir/doa/{id}/catatan', [PendetaFormulirController::class, 'updateCatatanDoa'])->name('pendeta.formulir.doa.catatan');
    Route::delete('/formulir/doa/{id}', [PendetaFormulirController::class, 'deleteDoa'])->name('pendeta.formulir.doa.delete');
    Route::get('/formulir/konseling/{id}/status/{status}', [PendetaFormulirController::class, 'updateStatusKonseling'])->name('pendeta.formulir.konseling.status');
    Route::patch('/formulir/konseling/{id}/catatan', [PendetaFormulirController::class, 'updateCatatanKonseling'])->name('pendeta.formulir.konseling.catatan');
    Route::delete('/formulir/konseling/{id}', [PendetaFormulirController::class, 'deleteKonseling'])->name('pendeta.formulir.konseling.delete');
});
