<?php $__env->startSection('title', 'Beranda - Gereja Jemaat Buntu Ambaang'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Hero Section with Background Image -->
    <section class="relative min-h-[90vh] flex items-center overflow-hidden">
        <!-- Background Image with Strong Darkening -->
        <div class="absolute inset-0">
            <img src="<?php echo e(asset('images/hero-section.jpg')); ?>" alt="Gereja Jemaat Buntu Ambaang"
                class="w-full h-full object-cover" style="filter: brightness(0.4);">
            <!-- Strong Dark Blue Overlay -->
            <div class="absolute inset-0"
                style="background: linear-gradient(to right, rgba(30,58,95,0.95) 0%, rgba(30,58,95,0.85) 50%, rgba(30,58,95,0.7) 100%);">
            </div>
        </div>

        <!-- Blue Accent Strip on Left -->
        <div class="absolute top-0 left-0 w-2 h-full" style="background-color: #d4af37;"></div>
        <div class="absolute top-0 left-0 h-full"
            style="width: 40%; background: linear-gradient(to right, rgba(30,58,95,0.9) 0%, transparent 100%);"></div>

        <!-- Decorative Circles -->
        <div class="absolute bottom-10 right-10 w-72 h-72 rounded-full"
            style="background: rgba(30,58,95,0.4); filter: blur(60px);"></div>
        <div class="absolute top-20 right-32 w-48 h-48 rounded-full"
            style="background: rgba(212,175,55,0.2); filter: blur(40px);"></div>

        <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20 lg:py-32 w-full">
            <div class="grid lg:grid-cols-2 gap-12 items-center">
                <div class="text-center lg:text-left">
                    <!-- Badge -->
                    <div class="inline-flex items-center gap-2 bg-white/10 backdrop-blur-sm rounded-full px-4 py-2 mb-6">
                        <span class="w-2 h-2 bg-secondary rounded-full animate-pulse"></span>
                        <span class="text-white/90 text-sm font-medium">Selamat datang di rumah Tuhan</span>
                    </div>

                    <!-- Verse -->
                    <blockquote class="text-secondary text-lg md:text-xl italic mb-4">
                        "Karena di mana dua atau tiga orang berkumpul dalam nama-Ku, di situ Aku ada di tengah-tengah
                        mereka."
                    </blockquote>
                    <p class="text-white/70 mb-8">— Matius 18:20</p>

                    <!-- Heading -->
                    <h1 class="text-4xl md:text-5xl lg:text-6xl font-extrabold text-white mb-6 leading-tight">
                        Gereja Jemaat<br>
                        <span class="text-secondary">Buntu Ambaang</span>
                    </h1>

                    <p class="text-lg text-white/80 mb-10 max-w-xl mx-auto lg:mx-0">
                        Melayani dengan kasih, bertumbuh dalam iman, menjangkau jiwa-jiwa bagi Kristus.
                    </p>

                    <!-- CTA Buttons -->
                    <div class="flex flex-col sm:flex-row gap-4 justify-center lg:justify-start">
                        <a href="<?php echo e(route('jadwal-ibadah')); ?>"
                            class="inline-flex items-center justify-center gap-2 px-8 py-4 bg-secondary text-primary font-bold rounded-2xl shadow-material-2 hover:shadow-material-3 hover:bg-secondary-light transition-all duration-300">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                            </svg>
                            Jadwal Ibadah
                        </a>
                        <a href="<?php echo e(route('kontak')); ?>"
                            class="inline-flex items-center justify-center gap-2 px-8 py-4 bg-white/10 backdrop-blur-sm text-white font-bold rounded-2xl border-2 border-white/30 hover:bg-white hover:text-primary transition-all duration-300">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z" />
                            </svg>
                            Ibadah Online
                        </a>
                    </div>
                </div>

                <!-- Right side - decorative elements (visible on larger screens) -->
                <div class="hidden lg:block"></div>
            </div>
        </div>

        <!-- Wave Divider -->
        <div class="absolute bottom-0 left-0 right-0">
            <svg viewBox="0 0 1440 120" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M0 120L60 110C120 100 240 80 360 70C480 60 600 60 720 65C840 70 960 80 1080 85C1200 90 1320 90 1380 90L1440 90V120H1380C1320 120 1200 120 1080 120C960 120 840 120 720 120C600 120 480 120 360 120C240 120 120 120 60 120H0Z"
                    fill="#f8fafc" />
            </svg>
        </div>
    </section>

    <!-- Quick Access Cards -->
    <section class="py-16 bg-slate-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-2 md:grid-cols-4 gap-4 md:gap-6 -mt-24 relative z-10">
                <a href="<?php echo e(route('jadwal-ibadah')); ?>"
                    class="group bg-white rounded-2xl p-6 shadow-material-1 hover:shadow-material-3 transition-all duration-300 hover:-translate-y-1">
                    <div
                        class="w-14 h-14 bg-primary/10 rounded-2xl flex items-center justify-center mb-4 group-hover:bg-primary group-hover:scale-110 transition-all duration-300">
                        <svg class="w-7 h-7 text-primary group-hover:text-white transition-colors" fill="none"
                            stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-1">Jadwal Ibadah</h3>
                    <p class="text-sm text-gray-500">Lihat jadwal ibadah</p>
                </a>

                <a href="<?php echo e(route('formulir.doa')); ?>"
                    class="group bg-white rounded-2xl p-6 shadow-material-1 hover:shadow-material-3 transition-all duration-300 hover:-translate-y-1">
                    <div
                        class="w-14 h-14 bg-red-50 rounded-2xl flex items-center justify-center mb-4 group-hover:bg-red-500 group-hover:scale-110 transition-all duration-300">
                        <svg class="w-7 h-7 text-red-500 group-hover:text-white transition-colors" fill="none"
                            stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-1">Permohonan Doa</h3>
                    <p class="text-sm text-gray-500">Sampaikan doa Anda</p>
                </a>

                <a href="<?php echo e(route('donasi')); ?>"
                    class="group bg-white rounded-2xl p-6 shadow-material-1 hover:shadow-material-3 transition-all duration-300 hover:-translate-y-1">
                    <div
                        class="w-14 h-14 bg-green-50 rounded-2xl flex items-center justify-center mb-4 group-hover:bg-green-500 group-hover:scale-110 transition-all duration-300">
                        <svg class="w-7 h-7 text-green-500 group-hover:text-white transition-colors" fill="none"
                            stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-1">Donasi</h3>
                    <p class="text-sm text-gray-500">Berikan persembahan</p>
                </a>

                <a href="<?php echo e(route('kontak')); ?>"
                    class="group bg-white rounded-2xl p-6 shadow-material-1 hover:shadow-material-3 transition-all duration-300 hover:-translate-y-1">
                    <div
                        class="w-14 h-14 bg-secondary/10 rounded-2xl flex items-center justify-center mb-4 group-hover:bg-secondary group-hover:scale-110 transition-all duration-300">
                        <svg class="w-7 h-7 text-secondary group-hover:text-primary transition-colors" fill="none"
                            stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z" />
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-1">Ibadah Online</h3>
                    <p class="text-sm text-gray-500">Bergabung via Zoom</p>
                </a>
            </div>
        </div>
    </section>

    <!-- Announcements Section -->
    <section class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Section Header -->
            <div class="text-center mb-12">
                <span
                    class="inline-block px-4 py-1.5 bg-primary/10 text-primary text-sm font-semibold rounded-full mb-4">Informasi
                    Terkini</span>
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Pengumuman Terbaru</h2>
                <p class="text-gray-600 max-w-2xl mx-auto">Tetap terhubung dengan berita dan informasi terbaru dari gereja
                </p>
            </div>

            <!-- Cards Grid -->
            <div class="grid md:grid-cols-3 gap-6">
                <?php $__currentLoopData = $pengumuman; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <article
                        class="group bg-white rounded-2xl shadow-material-1 hover:shadow-material-3 transition-all duration-300 hover:-translate-y-1 overflow-hidden">
                        <div
                            class="h-2 bg-gradient-to-r <?php echo e($index == 0 ? 'from-secondary to-yellow-400' : ($index == 1 ? 'from-primary to-blue-400' : 'from-green-500 to-emerald-400')); ?>">
                        </div>
                        <div class="p-6">
                            <div class="flex items-center gap-2 mb-4">
                                <span
                                    class="px-3 py-1 bg-slate-100 text-slate-600 text-xs font-medium rounded-full"><?php echo e($item['tanggal']); ?></span>
                            </div>
                            <h3 class="text-xl font-bold text-gray-900 mb-3 group-hover:text-primary transition-colors">
                                <?php echo e($item['judul']); ?>

                            </h3>
                            <p class="text-gray-600 leading-relaxed"><?php echo e($item['deskripsi']); ?></p>
                        </div>
                    </article>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>

    <!-- News Section -->
    <section class="py-12 bg-slate-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <span
                    class="inline-block px-4 py-1.5 bg-primary/10 text-primary text-sm font-semibold rounded-full mb-4">Berita
                    Terkini</span>
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Berita Terbaru</h2>
                <p class="text-gray-600 max-w-2xl mx-auto">Dapatkan update terbaru seputar kegiatan, pengumuman, dan berita
                    dari gereja kami.</p>
            </div>
            <?php if($beritaList->count() > 0): ?>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <?php $__currentLoopData = $beritaList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $berita): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <article
                            class="bg-white rounded-2xl shadow-material-1 overflow-hidden hover:shadow-material-3 transition-all duration-300 group">
                            <!-- Thumbnail -->
                            <a href="<?php echo e(route('berita.show', $berita->slug)); ?>" class="block">
                                <div class="relative h-48 overflow-hidden">
                                    <?php if($berita->gambar): ?>
                                        <img src="<?php echo e(asset('images/' . $berita->gambar)); ?>" alt="<?php echo e($berita->judul); ?>"
                                            class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                                    <?php else: ?>
                                        <div class="w-full h-full flex items-center justify-center"
                                            style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
                                            <svg class="w-16 h-16 text-white/30" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                                    d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z" />
                                            </svg>
                                        </div>
                                    <?php endif; ?>
                                    <div class="absolute top-4 left-4">
                                        <span class="px-3 py-1 rounded-full text-xs font-semibold bg-white/90 backdrop-blur-sm"
                                            style="color: #1e3a5f;">
                                            <?php echo e($berita->tanggal_publikasi->translatedFormat('d M Y')); ?>

                                        </span>
                                    </div>
                                </div>
                            </a>

                            <!-- Content -->
                            <div class="p-6">
                                <a href="<?php echo e(route('berita.show', $berita->slug)); ?>">
                                    <h3 class="text-lg font-bold mb-2 line-clamp-2 group-hover:text-primary transition-colors"
                                        style="color: #1e3a5f;">
                                        <?php echo e($berita->judul); ?>

                                    </h3>
                                </a>
                                <p class="text-gray-600 text-sm mb-4 line-clamp-3"><?php echo e($berita->ringkasan); ?></p>

                                <a href="<?php echo e(route('berita.show', $berita->slug)); ?>"
                                    class="inline-flex items-center text-sm font-semibold transition-all" style="color: #d4af37;">
                                    Baca Selengkapnya
                                    <svg class="w-4 h-4 ml-2 group-hover:translate-x-1 transition-transform" fill="none"
                                        stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                    </svg>
                                </a>
                            </div>
                        </article>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <!-- Pagination -->
                <div class="mt-10">
                    <?php echo e($beritaList->links()); ?>

                </div>
            <?php else: ?>
                <!-- Empty State -->
                <div class="text-center py-16">
                    <div class="w-20 h-20 rounded-full mx-auto mb-6 flex items-center justify-center"
                        style="background: rgba(30,58,95,0.1);">
                        <svg class="w-10 h-10" style="color: #1e3a5f;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold mb-2" style="color: #1e3a5f;">Belum Ada Berita</h3>
                    <p class="text-gray-500 max-w-md mx-auto">Berita dan informasi gereja akan ditampilkan di sini.</p>
                </div>
            <?php endif; ?>
        </div>
    </section>

    <!-- Schedule Section -->
    <section class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid lg:grid-cols-2 gap-12 items-center">
                <!-- Left Content -->
                <div>
                    <span
                        class="inline-block px-4 py-1.5 bg-secondary/20 text-primary text-sm font-semibold rounded-full mb-4">Jadwal
                        Minggu Ini</span>
                    <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-6">Bergabunglah Bersama Kami dalam Ibadah
                    </h2>
                    <p class="text-gray-600 mb-8">Mari bersama-sama memuji dan memuliakan Tuhan. Ibadah kami terbuka untuk
                        semua orang.</p>

                    <a href="<?php echo e(route('jadwal-ibadah')); ?>"
                        class="inline-flex items-center gap-2 px-6 py-3 bg-primary text-white font-semibold rounded-xl shadow-material-1 hover:shadow-material-2 hover:bg-primary-light transition-all duration-200">
                        Lihat Semua Jadwal
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M17 8l4 4m0 0l-4 4m4-4H3" />
                        </svg>
                    </a>
                </div>

                <!-- Schedule Cards -->
                <div class="space-y-4">
                    <?php $__currentLoopData = $jadwalMingguIni; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jadwal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div
                            class="bg-white rounded-2xl p-6 shadow-material-1 hover:shadow-material-2 transition-all duration-300 flex items-center gap-6">
                            <div
                                class="flex-shrink-0 w-16 h-16 bg-gradient-primary rounded-2xl flex items-center justify-center">
                                <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                            </div>
                            <div class="flex-grow">
                                <h3 class="font-bold text-gray-900 text-lg"><?php echo e($jadwal['nama']); ?></h3>
                                <p class="text-gray-500"><?php echo e($jadwal['hari']); ?>, <?php echo e($jadwal['tanggal']); ?></p>
                            </div>
                            <div class="text-right">
                                <p class="text-2xl font-bold text-secondary"><?php echo e($jadwal['waktu']); ?></p>
                                <p class="text-sm text-gray-500"><?php echo e($jadwal['tempat']); ?></p>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="py-20 bg-gradient-primary relative overflow-hidden">
        <div class="absolute inset-0 opacity-10">
            <svg class="w-full h-full" viewBox="0 0 100 100" preserveAspectRatio="none">
                <circle cx="20" cy="20" r="20" fill="white" />
                <circle cx="80" cy="80" r="30" fill="white" />
            </svg>
        </div>

        <div class="relative max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h2 class="text-3xl md:text-4xl font-bold text-white mb-6">Butuh Pelayanan Rohani?</h2>
            <p class="text-white/80 text-lg mb-10 max-w-2xl mx-auto">
                Kami siap melayani Anda. Sampaikan permohonan doa atau ajukan konseling dengan pendeta kami.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="<?php echo e(route('formulir.doa')); ?>"
                    class="inline-flex items-center justify-center gap-2 px-8 py-4 bg-secondary text-primary font-bold rounded-2xl shadow-material-2 hover:shadow-material-3 hover:bg-secondary-light transition-all duration-300">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                    </svg>
                    Permohonan Doa
                </a>
                <a href="<?php echo e(route('formulir.konseling')); ?>"
                    class="inline-flex items-center justify-center gap-2 px-8 py-4 bg-white/10 backdrop-blur-sm text-white font-bold rounded-2xl border-2 border-white/30 hover:bg-white hover:text-primary transition-all duration-300">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z" />
                    </svg>
                    Konseling Rohani
                </a>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.public', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/public/beranda.blade.php ENDPATH**/ ?>