<?php $__env->startSection('title', 'Kegiatan Gereja - Gereja Jemaat Buntu Ambaang'); ?>

<?php $__env->startSection('content'); ?>
<!-- Header (Konsisten dengan halaman lain) -->
<section class="relative py-16 md:py-20 overflow-hidden" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
    <div class="absolute top-0 right-0 w-64 h-64 rounded-full opacity-10" style="background: #d4af37; filter: blur(60px);"></div>
    <div class="absolute bottom-0 left-0 w-48 h-48 rounded-full opacity-10" style="background: #ffffff; filter: blur(40px);"></div>
    
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <span class="inline-block px-4 py-1.5 rounded-full text-sm font-medium mb-4" style="background: rgba(212,175,55,0.2); color: #d4af37;">
            Aktivitas & Program
        </span>
        <h1 class="text-3xl md:text-4xl lg:text-5xl font-bold mb-4" style="color: #ffffff; text-shadow: 0 2px 4px rgba(0,0,0,0.1);">
            Kegiatan Gereja
        </h1>
        <p class="text-lg md:text-xl max-w-2xl mx-auto" style="color: rgba(255,255,255,0.85);">
            Berbagai aktivitas dan program pelayanan gereja
        </p>
    </div>
</section>

<!-- Kegiatan Rutin -->
<section class="py-12 bg-slate-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Section Header -->
        <div class="flex items-center gap-4 mb-8">
            <div class="w-12 h-12 rounded-xl flex items-center justify-center" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                </svg>
            </div>
            <div>
                <h2 class="text-2xl font-bold" style="color: #1e3a5f;">Kegiatan Rutin</h2>
                <p class="text-gray-500 text-sm">Aktivitas mingguan yang rutin dilaksanakan</p>
            </div>
        </div>

        <!-- Cards Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php $__currentLoopData = $kegiatanRutin; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kegiatan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bg-white rounded-2xl shadow-material-1 overflow-hidden hover:shadow-material-3 transition-all duration-300 group">
                <!-- Card Header dengan Icon -->
                <div class="px-6 py-5 border-b border-gray-100" style="background: linear-gradient(135deg, rgba(30,58,95,0.03) 0%, rgba(30,58,95,0.08) 100%);">
                    <div class="flex items-center gap-4">
                        <div class="w-12 h-12 rounded-xl flex items-center justify-center flex-shrink-0" style="background: rgba(212,175,55,0.15);">
                            <svg class="w-6 h-6" style="color: #d4af37;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                            </svg>
                        </div>
                        <h3 class="text-lg font-bold leading-tight" style="color: #1e3a5f;"><?php echo e($kegiatan['nama']); ?></h3>
                    </div>
                </div>
                
                <!-- Card Body -->
                <div class="px-6 py-5">
                    <p class="text-gray-600 text-sm mb-4 line-clamp-2"><?php echo e($kegiatan['deskripsi']); ?></p>
                    
                    <!-- Jadwal Badge -->
                    <div class="flex items-center gap-2 mb-4">
                        <span class="inline-flex items-center px-3 py-1.5 rounded-lg text-sm font-medium" style="background: rgba(30,58,95,0.08); color: #1e3a5f;">
                            <svg class="w-4 h-4 mr-2" style="color: #d4af37;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            <?php echo e($kegiatan['jadwal']); ?>

                        </span>
                    </div>
                    
                    <!-- Link Detail -->
                    <a href="<?php echo e(route('kegiatan.show', $kegiatan['slug'])); ?>" class="inline-flex items-center text-sm font-semibold transition-all group-hover:gap-3" style="color: #d4af37;">
                        Lihat Detail
                        <svg class="w-4 h-4 ml-2 transition-transform group-hover:translate-x-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                        </svg>
                    </a>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- Kegiatan Khusus -->
<section class="py-12 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Section Header -->
        <div class="flex items-center gap-4 mb-8">
            <div class="w-12 h-12 rounded-xl flex items-center justify-center" style="background: linear-gradient(135deg, #d4af37 0%, #c9a227 100%);">
                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                </svg>
            </div>
            <div>
                <h2 class="text-2xl font-bold" style="color: #1e3a5f;">Kegiatan Khusus</h2>
                <p class="text-gray-500 text-sm">Event dan kegiatan yang akan datang</p>
            </div>
        </div>

        <!-- Cards Grid -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <?php $__currentLoopData = $kegiatanKhusus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kegiatan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bg-white rounded-2xl shadow-material-1 overflow-hidden hover:shadow-material-3 transition-all duration-300 flex">
                <!-- Date Badge (Calendar Style) -->
                <div class="w-28 flex-shrink-0 flex flex-col items-center justify-center text-center px-4 py-6" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
                    <span class="text-3xl font-bold text-white leading-none"><?php echo e($kegiatan['tanggal_hari']); ?></span>
                    <span class="text-sm font-medium uppercase tracking-wide mt-1" style="color: #d4af37;"><?php echo e($kegiatan['tanggal_bulan']); ?></span>
                </div>
                
                <!-- Content -->
                <div class="flex-1 px-6 py-5">
                    <!-- Kategori Badge -->
                    <span class="inline-block px-3 py-1 rounded-full text-xs font-semibold mb-2" style="background: rgba(212,175,55,0.15); color: #1e3a5f;">
                        <?php echo e($kegiatan['kategori']); ?>

                    </span>
                    
                    <!-- Title -->
                    <h3 class="text-lg font-bold mb-2" style="color: #1e3a5f;"><?php echo e($kegiatan['nama']); ?></h3>
                    
                    <!-- Description -->
                    <p class="text-gray-600 text-sm mb-3 line-clamp-2"><?php echo e($kegiatan['deskripsi']); ?></p>
                    
                    <!-- Meta Info -->
                    <div class="flex flex-wrap items-center gap-4 text-sm text-gray-500">
                        <?php if($kegiatan['waktu']): ?>
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1.5" style="color: #d4af37;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            <?php echo e($kegiatan['waktu']); ?>

                        </span>
                        <?php endif; ?>
                        <?php if($kegiatan['tempat']): ?>
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1.5" style="color: #d4af37;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                            </svg>
                            <?php echo e($kegiatan['tempat']); ?>

                        </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Empty State jika tidak ada kegiatan khusus -->
        <?php if(count($kegiatanKhusus) == 0): ?>
        <div class="text-center py-12">
            <div class="w-16 h-16 rounded-full mx-auto mb-4 flex items-center justify-center" style="background: rgba(30,58,95,0.1);">
                <svg class="w-8 h-8" style="color: #1e3a5f;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                </svg>
            </div>
            <h3 class="text-lg font-semibold mb-2" style="color: #1e3a5f;">Belum Ada Kegiatan Khusus</h3>
            <p class="text-gray-500">Kegiatan khusus akan diumumkan di sini</p>
        </div>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.public', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/public/kegiatan/index.blade.php ENDPATH**/ ?>