<?php $__env->startSection('title', 'Laporan Keuangan - Gereja Jemaat Buntu Ambaang'); ?>

<?php $__env->startSection('content'); ?>
<!-- Header with Material Design -->
<section class="relative py-16 md:py-20 overflow-hidden" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
    <!-- Decorative elements -->
    <div class="absolute top-0 right-0 w-64 h-64 rounded-full opacity-10" style="background: #d4af37; filter: blur(60px);"></div>
    <div class="absolute bottom-0 left-0 w-48 h-48 rounded-full opacity-10" style="background: #ffffff; filter: blur(40px);"></div>
    
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <span class="inline-block px-4 py-1.5 rounded-full text-sm font-medium mb-4" style="background: rgba(212,175,55,0.2); color: #d4af37;">
            Transparansi Keuangan
        </span>
        <h1 class="text-3xl md:text-4xl lg:text-5xl font-bold mb-4" style="color: #ffffff; text-shadow: 0 2px 4px rgba(0,0,0,0.1);">
            Laporan Keuangan
        </h1>
        <p class="text-lg md:text-xl max-w-2xl mx-auto" style="color: rgba(255,255,255,0.85);">
            Transparansi pengelolaan keuangan gereja
        </p>
    </div>
</section>

<!-- Filter Periode -->
<section class="py-6 bg-white border-b">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex flex-col sm:flex-row items-center justify-between gap-4">
            <h2 class="text-xl font-bold" style="color: #1e3a5f;">
                <svg class="w-5 h-5 inline-block mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
                Periode: <?php echo e($periode); ?>

            </h2>
            <select class="px-4 py-2 border-2 border-gray-200 rounded-xl focus:outline-none transition-colors text-gray-700" style="background: #ffffff;">
                <option>Desember 2024</option>
                <option>November 2024</option>
                <option>Oktober 2024</option>
            </select>
        </div>
    </div>
</section>

<!-- Summary Cards -->
<section class="py-8 bg-slate-50">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <!-- Pemasukan -->
            <div class="bg-white rounded-2xl p-6 shadow-material-1 border-t-4" style="border-color: #22c55e;">
                <div class="flex items-center gap-3 mb-3">
                    <div class="w-10 h-10 rounded-full flex items-center justify-center" style="background: rgba(34,197,94,0.1);">
                        <svg class="w-5 h-5 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 11l5-5m0 0l5 5m-5-5v12"/></svg>
                    </div>
                    <span class="text-gray-600 font-medium">Total Pemasukan</span>
                </div>
                <p class="text-2xl md:text-3xl font-bold text-green-600">Rp <?php echo e(number_format($totalPemasukan, 0, ',', '.')); ?></p>
            </div>
            
            <!-- Pengeluaran -->
            <div class="bg-white rounded-2xl p-6 shadow-material-1 border-t-4" style="border-color: #ef4444;">
                <div class="flex items-center gap-3 mb-3">
                    <div class="w-10 h-10 rounded-full flex items-center justify-center" style="background: rgba(239,68,68,0.1);">
                        <svg class="w-5 h-5 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 13l-5 5m0 0l-5-5m5 5V6"/></svg>
                    </div>
                    <span class="text-gray-600 font-medium">Total Pengeluaran</span>
                </div>
                <p class="text-2xl md:text-3xl font-bold text-red-600">Rp <?php echo e(number_format($totalPengeluaran, 0, ',', '.')); ?></p>
            </div>
            
            <!-- Saldo -->
            <div class="bg-white rounded-2xl p-6 shadow-material-1 border-t-4" style="border-color: #1e3a5f;">
                <div class="flex items-center gap-3 mb-3">
                    <div class="w-10 h-10 rounded-full flex items-center justify-center" style="background: rgba(30,58,95,0.1);">
                        <svg class="w-5 h-5" style="color: #1e3a5f;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                    </div>
                    <span class="text-gray-600 font-medium">Saldo</span>
                </div>
                <p class="text-2xl md:text-3xl font-bold" style="color: #1e3a5f;">Rp <?php echo e(number_format($saldo, 0, ',', '.')); ?></p>
            </div>
        </div>
    </div>
</section>

<!-- Detail Tables -->
<section class="py-8 bg-slate-50">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <!-- Rincian Pemasukan -->
            <div class="bg-white rounded-2xl shadow-material-1 overflow-hidden">
                <div class="px-6 py-4 border-b" style="background: rgba(34,197,94,0.05);">
                    <h3 class="text-lg font-bold text-green-700 flex items-center gap-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 11l5-5m0 0l5 5m-5-5v12"/></svg>
                        Rincian Pemasukan
                    </h3>
                </div>
                <div class="p-4">
                    <table class="w-full">
                        <tbody class="divide-y divide-gray-100">
                            <?php $__currentLoopData = $pemasukan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="hover:bg-slate-50 transition-colors">
                                <td class="py-3 px-2 text-gray-700"><?php echo e($item['sumber']); ?></td>
                                <td class="py-3 px-2 text-right font-semibold text-green-600">Rp <?php echo e(number_format($item['jumlah'], 0, ',', '.')); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Rincian Pengeluaran -->
            <div class="bg-white rounded-2xl shadow-material-1 overflow-hidden">
                <div class="px-6 py-4 border-b" style="background: rgba(239,68,68,0.05);">
                    <h3 class="text-lg font-bold text-red-700 flex items-center gap-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 13l-5 5m0 0l-5-5m5 5V6"/></svg>
                        Rincian Pengeluaran
                    </h3>
                </div>
                <div class="p-4">
                    <table class="w-full">
                        <tbody class="divide-y divide-gray-100">
                            <?php $__currentLoopData = $pengeluaran; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="hover:bg-slate-50 transition-colors">
                                <td class="py-3 px-2 text-gray-700"><?php echo e($item['keperluan']); ?></td>
                                <td class="py-3 px-2 text-right font-semibold text-red-600">Rp <?php echo e(number_format($item['jumlah'], 0, ',', '.')); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Download Section -->
<section class="py-8 bg-white">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <p class="text-gray-600 mb-4">Unduh laporan keuangan lengkap dalam format PDF</p>
        <button class="inline-flex items-center gap-2 px-6 py-3 rounded-xl font-semibold transition-all shadow-material-1 hover:shadow-material-2" style="background: #1e3a5f; color: #ffffff;">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/></svg>
            Download Laporan PDF
        </button>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.public', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/public/laporan-keuangan.blade.php ENDPATH**/ ?>