<?php $__env->startSection('title', 'Manajemen Keuangan'); ?>
<?php $__env->startSection('page-title', 'Manajemen Donasi & Keuangan'); ?>

<?php $__env->startSection('content'); ?>
<!-- Summary Cards -->
<div class="grid grid-cols-1 md:grid-cols-3 gap-5 lg:gap-6 mb-6">
    <!-- Total Pemasukan -->
    <div class="bg-white rounded-2xl shadow-admin-md hover:shadow-admin-lg transition-shadow duration-300 p-6 border border-slate-100 relative overflow-hidden">
        <div class="absolute top-0 left-0 w-1.5 h-full bg-emerald-500 rounded-l-2xl"></div>
        <div class="flex items-center justify-between">
            <div class="pl-2">
                <p class="text-slate-500 text-[15px] font-medium mb-1">Total Pemasukan</p>
                <p class="text-2xl font-bold text-emerald-600">Rp <?php echo e(number_format($totalPemasukan, 0, ',', '.')); ?></p>
            </div>
            <div class="w-14 h-14 bg-gradient-to-br from-emerald-100 to-emerald-50 rounded-2xl flex items-center justify-center">
                <svg class="w-7 h-7 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M7 11l5-5m0 0l5 5m-5-5v12"/></svg>
            </div>
        </div>
    </div>
    
    <!-- Total Pengeluaran -->
    <div class="bg-white rounded-2xl shadow-admin-md hover:shadow-admin-lg transition-shadow duration-300 p-6 border border-slate-100 relative overflow-hidden">
        <div class="absolute top-0 left-0 w-1.5 h-full bg-rose-500 rounded-l-2xl"></div>
        <div class="flex items-center justify-between">
            <div class="pl-2">
                <p class="text-slate-500 text-[15px] font-medium mb-1">Total Pengeluaran</p>
                <p class="text-2xl font-bold text-rose-600">Rp <?php echo e(number_format($totalPengeluaran, 0, ',', '.')); ?></p>
            </div>
            <div class="w-14 h-14 bg-gradient-to-br from-rose-100 to-rose-50 rounded-2xl flex items-center justify-center">
                <svg class="w-7 h-7 text-rose-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17 13l-5 5m0 0l-5-5m5 5V6"/></svg>
            </div>
        </div>
    </div>
    
    <!-- Saldo -->
    <div class="bg-white rounded-2xl shadow-admin-md hover:shadow-admin-lg transition-shadow duration-300 p-6 border border-slate-100 relative overflow-hidden">
        <div class="absolute top-0 left-0 w-1.5 h-full bg-[#1e3a5f] rounded-l-2xl"></div>
        <div class="flex items-center justify-between">
            <div class="pl-2">
                <p class="text-slate-500 text-[15px] font-medium mb-1">Saldo</p>
                <p class="text-2xl font-bold text-[#1e3a5f]">Rp <?php echo e(number_format($saldo, 0, ',', '.')); ?></p>
            </div>
            <div class="w-14 h-14 bg-gradient-to-br from-blue-100 to-blue-50 rounded-2xl flex items-center justify-center">
                <svg class="w-7 h-7 text-[#1e3a5f]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
            </div>
        </div>
    </div>
</div>

<!-- Input Forms -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-5 lg:gap-6">
    <!-- Input Pemasukan -->
    <div class="bg-white rounded-2xl shadow-admin-md border border-slate-100 p-6">
        <div class="flex items-center gap-3 mb-6">
            <div class="w-10 h-10 rounded-xl bg-emerald-100 flex items-center justify-center">
                <svg class="w-5 h-5 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 11l5-5m0 0l5 5m-5-5v12"/></svg>
            </div>
            <h2 class="text-xl font-bold text-emerald-600">Input Pemasukan</h2>
        </div>
        <form action="<?php echo e(route('admin.keuangan.store')); ?>" method="POST" class="space-y-5">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="type" value="pemasukan">
            <div>
                <label class="block text-slate-700 font-semibold text-[15px] mb-2">Sumber *</label>
                <select name="kategori" required class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-emerald-500 focus:bg-white focus:outline-none transition-all duration-200">
                    <option value="">Pilih Sumber</option>
                    <option value="Persembahan Mingguan">Persembahan Mingguan</option>
                    <option value="Persembahan Syukur">Persembahan Syukur</option>
                    <option value="Diakonia">Diakonia</option>
                    <option value="Pembangunan">Pembangunan</option>
                    <option value="Lainnya">Lainnya</option>
                </select>
            </div>
            <div>
                <label class="block text-slate-700 font-semibold text-[15px] mb-2">Jumlah *</label>
                <input type="number" name="jumlah" required class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-emerald-500 focus:bg-white focus:outline-none transition-all duration-200" placeholder="Rp">
            </div>
            <div>
                <label class="block text-slate-700 font-semibold text-[15px] mb-2">Tanggal *</label>
                <input type="date" name="tanggal" required class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-emerald-500 focus:bg-white focus:outline-none transition-all duration-200">
            </div>
            <div>
                <label class="block text-slate-700 font-semibold text-[15px] mb-2">Keterangan</label>
                <input type="text" name="keterangan" class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-emerald-500 focus:bg-white focus:outline-none transition-all duration-200" placeholder="Tambahkan keterangan...">
            </div>
            <button type="submit" class="w-full py-3.5 bg-emerald-600 text-white rounded-xl font-bold text-[15px] hover:bg-emerald-700 transition-all duration-200 shadow-admin-sm hover:shadow-admin-md flex items-center justify-center gap-2">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                Simpan Pemasukan
            </button>
        </form>
    </div>

    <!-- Input Pengeluaran -->
    <div class="bg-white rounded-2xl shadow-admin-md border border-slate-100 p-6">
        <div class="flex items-center gap-3 mb-6">
            <div class="w-10 h-10 rounded-xl bg-rose-100 flex items-center justify-center">
                <svg class="w-5 h-5 text-rose-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 13l-5 5m0 0l-5-5m5 5V6"/></svg>
            </div>
            <h2 class="text-xl font-bold text-rose-600">Input Pengeluaran</h2>
        </div>
        <form action="<?php echo e(route('admin.keuangan.store')); ?>" method="POST" class="space-y-5">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="type" value="pengeluaran">
            <div>
                <label class="block text-slate-700 font-semibold text-[15px] mb-2">Keperluan *</label>
                <select name="kategori" required class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-rose-500 focus:bg-white focus:outline-none transition-all duration-200">
                    <option value="">Pilih Keperluan</option>
                    <option value="Operasional">Operasional</option>
                    <option value="Gaji Pegawai">Gaji Pegawai</option>
                    <option value="Listrik & Air">Listrik & Air</option>
                    <option value="Pembangunan">Pembangunan</option>
                    <option value="Diakonia">Diakonia</option>
                    <option value="Kegiatan">Kegiatan</option>
                    <option value="Lainnya">Lainnya</option>
                </select>
            </div>
            <div>
                <label class="block text-slate-700 font-semibold text-[15px] mb-2">Jumlah *</label>
                <input type="number" name="jumlah" required class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-rose-500 focus:bg-white focus:outline-none transition-all duration-200" placeholder="Rp">
            </div>
            <div>
                <label class="block text-slate-700 font-semibold text-[15px] mb-2">Tanggal *</label>
                <input type="date" name="tanggal" required class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-rose-500 focus:bg-white focus:outline-none transition-all duration-200">
            </div>
            <div>
                <label class="block text-slate-700 font-semibold text-[15px] mb-2">Keterangan</label>
                <input type="text" name="keterangan" class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-rose-500 focus:bg-white focus:outline-none transition-all duration-200" placeholder="Tambahkan keterangan...">
            </div>
            <button type="submit" class="w-full py-3.5 bg-rose-600 text-white rounded-xl font-bold text-[15px] hover:bg-rose-700 transition-all duration-200 shadow-admin-sm hover:shadow-admin-md flex items-center justify-center gap-2">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                Simpan Pengeluaran
            </button>
        </form>
    </div>
</div>

<!-- Riwayat Transaksi -->
<div class="mt-6 bg-white rounded-2xl shadow-admin-md border border-slate-100 p-6">
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4 mb-6">
        <div class="flex items-center gap-2">
            <span class="w-1.5 h-7 bg-[#d4af37] rounded-full"></span>
            <h2 class="text-xl font-bold text-[#1e3a5f]">Riwayat Transaksi</h2>
        </div>
        <a href="<?php echo e(route('admin.keuangan.export')); ?>" class="inline-flex items-center justify-center gap-2 px-5 py-2.5 bg-[#d4af37] text-[#1e3a5f] rounded-xl font-bold text-sm hover:bg-[#e6c85a] transition-all duration-200 shadow-admin-sm hover:shadow-admin-md">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/></svg>
            Export PDF
        </a>
    </div>
    
    <div class="overflow-x-auto rounded-xl border border-slate-200">
        <table class="w-full">
            <thead>
                <tr class="bg-slate-50">
                    <th class="px-5 py-4 text-left text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Tanggal</th>
                    <th class="px-5 py-4 text-left text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Kategori</th>
                    <th class="px-5 py-4 text-left text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Keterangan</th>
                    <th class="px-5 py-4 text-right text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Jumlah</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-slate-100">
                <?php $__empty_1 = true; $__currentLoopData = $transaksi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="hover:bg-slate-50/50 transition-colors duration-150">
                    <td class="px-5 py-4 text-slate-600 text-[15px]"><?php echo e($item['tanggal']); ?></td>
                    <td class="px-5 py-4">
                        <span class="inline-flex items-center gap-1.5 px-3 py-1.5 rounded-full text-xs font-semibold <?php echo e($item['type'] == 'pemasukan' ? 'bg-emerald-100 text-emerald-700' : 'bg-rose-100 text-rose-700'); ?>">
                            <?php echo e($item['kategori']); ?>

                        </span>
                    </td>
                    <td class="px-5 py-4 text-slate-600 text-[15px]"><?php echo e($item['keterangan']); ?></td>
                    <td class="px-5 py-4 text-right">
                        <span class="font-bold text-[15px] <?php echo e($item['type'] == 'pemasukan' ? 'text-emerald-600' : 'text-rose-600'); ?>">
                            <?php echo e($item['type'] == 'pemasukan' ? '+' : '-'); ?> Rp <?php echo e(number_format($item['jumlah'], 0, ',', '.')); ?>

                        </span>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="4" class="py-12 text-center text-slate-500">Belum ada transaksi</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/admin/keuangan/index.blade.php ENDPATH**/ ?>