<?php $__env->startSection('title', 'Berita Gereja - Gereja Jemaat Buntu Ambaang'); ?>

<?php $__env->startSection('content'); ?>
<!-- Header -->
<section class="relative py-16 md:py-20 overflow-hidden" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
    <div class="absolute top-0 right-0 w-64 h-64 rounded-full opacity-10" style="background: #d4af37; filter: blur(60px);"></div>
    <div class="absolute bottom-0 left-0 w-48 h-48 rounded-full opacity-10" style="background: #ffffff; filter: blur(40px);"></div>
    
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <span class="inline-block px-4 py-1.5 rounded-full text-sm font-medium mb-4" style="background: rgba(212,175,55,0.2); color: #d4af37;">
            Informasi & Kabar
        </span>
        <h1 class="text-3xl md:text-4xl lg:text-5xl font-bold mb-4" style="color: #ffffff; text-shadow: 0 2px 4px rgba(0,0,0,0.1);">
            Berita Gereja
        </h1>
        <p class="text-lg md:text-xl max-w-2xl mx-auto" style="color: rgba(255,255,255,0.85);">
            Berita dan informasi terbaru dari Gereja Jemaat Buntu Ambaang
        </p>
    </div>
</section>

<!-- Berita List -->
<section class="py-12 bg-slate-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <?php if($beritaList->count() > 0): ?>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php $__currentLoopData = $beritaList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $berita): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <article class="bg-white rounded-2xl shadow-material-1 overflow-hidden hover:shadow-material-3 transition-all duration-300 group">
                <!-- Thumbnail -->
                <a href="<?php echo e(route('berita.show', $berita->slug)); ?>" class="block">
                    <div class="relative h-48 overflow-hidden">
                        <?php if($berita->gambar): ?>
                        <img src="<?php echo e(asset('images/' . $berita->gambar)); ?>" alt="<?php echo e($berita->judul); ?>" class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                        <?php else: ?>
                        <div class="w-full h-full flex items-center justify-center" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
                            <svg class="w-16 h-16 text-white/30" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"/>
                            </svg>
                        </div>
                        <?php endif; ?>
                        <div class="absolute top-4 left-4">
                            <span class="px-3 py-1 rounded-full text-xs font-semibold bg-white/90 backdrop-blur-sm" style="color: #1e3a5f;">
                                <?php echo e($berita->tanggal_publikasi->translatedFormat('d M Y')); ?>

                            </span>
                        </div>
                    </div>
                </a>
                
                <!-- Content -->
                <div class="p-6">
                    <a href="<?php echo e(route('berita.show', $berita->slug)); ?>">
                        <h3 class="text-lg font-bold mb-2 line-clamp-2 group-hover:text-primary transition-colors" style="color: #1e3a5f;">
                            <?php echo e($berita->judul); ?>

                        </h3>
                    </a>
                    <p class="text-gray-600 text-sm mb-4 line-clamp-3"><?php echo e($berita->ringkasan); ?></p>
                    
                    <a href="<?php echo e(route('berita.show', $berita->slug)); ?>" class="inline-flex items-center text-sm font-semibold transition-all" style="color: #d4af37;">
                        Baca Selengkapnya
                        <svg class="w-4 h-4 ml-2 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                        </svg>
                    </a>
                </div>
            </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        
        <!-- Pagination -->
        <div class="mt-10">
            <?php echo e($beritaList->links()); ?>

        </div>
        <?php else: ?>
        <!-- Empty State -->
        <div class="text-center py-16">
            <div class="w-20 h-20 rounded-full mx-auto mb-6 flex items-center justify-center" style="background: rgba(30,58,95,0.1);">
                <svg class="w-10 h-10" style="color: #1e3a5f;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"/>
                </svg>
            </div>
            <h3 class="text-xl font-bold mb-2" style="color: #1e3a5f;">Belum Ada Berita</h3>
            <p class="text-gray-500 max-w-md mx-auto">Berita dan informasi gereja akan ditampilkan di sini.</p>
        </div>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.public', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/public/berita/index.blade.php ENDPATH**/ ?>