<?php $__env->startSection('title', 'Manajemen Berita'); ?>
<?php $__env->startSection('page-title', 'Manajemen Berita'); ?>

<?php $__env->startSection('content'); ?>
<!-- Summary Cards -->
<div class="grid grid-cols-1 md:grid-cols-3 gap-5 lg:gap-6 mb-6">
    <div class="bg-white rounded-2xl shadow-admin-md hover:shadow-admin-lg transition-shadow duration-300 p-6 border border-slate-100 relative overflow-hidden">
        <div class="absolute top-0 left-0 w-1.5 h-full bg-[#1e3a5f] rounded-l-2xl"></div>
        <div class="flex items-center justify-between">
            <div class="pl-2">
                <p class="text-slate-500 text-[15px] font-medium mb-1">Total Berita</p>
                <p class="text-2xl font-bold text-[#1e3a5f]"><?php echo e($beritaList->total()); ?></p>
            </div>
            <div class="w-14 h-14 bg-gradient-to-br from-blue-100 to-blue-50 rounded-2xl flex items-center justify-center">
                <svg class="w-7 h-7 text-[#1e3a5f]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"/></svg>
            </div>
        </div>
    </div>
    
    <div class="bg-white rounded-2xl shadow-admin-md hover:shadow-admin-lg transition-shadow duration-300 p-6 border border-slate-100 relative overflow-hidden">
        <div class="absolute top-0 left-0 w-1.5 h-full bg-emerald-500 rounded-l-2xl"></div>
        <div class="flex items-center justify-between">
            <div class="pl-2">
                <p class="text-slate-500 text-[15px] font-medium mb-1">Published</p>
                <p class="text-2xl font-bold text-emerald-600"><?php echo e($beritaList->where('status', 'published')->count()); ?></p>
            </div>
            <div class="w-14 h-14 bg-gradient-to-br from-emerald-100 to-emerald-50 rounded-2xl flex items-center justify-center">
                <svg class="w-7 h-7 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
            </div>
        </div>
    </div>
    
    <div class="bg-white rounded-2xl shadow-admin-md hover:shadow-admin-lg transition-shadow duration-300 p-6 border border-slate-100 relative overflow-hidden">
        <div class="absolute top-0 left-0 w-1.5 h-full bg-amber-500 rounded-l-2xl"></div>
        <div class="flex items-center justify-between">
            <div class="pl-2">
                <p class="text-slate-500 text-[15px] font-medium mb-1">Draft</p>
                <p class="text-2xl font-bold text-amber-600"><?php echo e($beritaList->where('status', 'draft')->count()); ?></p>
            </div>
            <div class="w-14 h-14 bg-gradient-to-br from-amber-100 to-amber-50 rounded-2xl flex items-center justify-center">
                <svg class="w-7 h-7 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/></svg>
            </div>
        </div>
    </div>
</div>

<!-- Main Card -->
<div class="bg-white rounded-2xl shadow-admin-md border border-slate-100 p-6">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-6">
        <div class="flex items-center gap-2">
            <span class="w-1.5 h-7 bg-[#d4af37] rounded-full"></span>
            <h2 class="text-xl font-bold text-[#1e3a5f]">Daftar Berita</h2>
        </div>
        <a href="<?php echo e(route('admin.berita.create')); ?>" class="inline-flex items-center justify-center gap-2 px-6 py-3 bg-[#1e3a5f] text-white rounded-xl font-bold text-[15px] hover:bg-[#2d5a8a] transition-all duration-200 shadow-admin-sm hover:shadow-admin-md">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/></svg>
            Tambah Berita
        </a>
    </div>

    <?php if($beritaList->total() > 0): ?>
    <div class="overflow-x-auto rounded-xl border border-slate-200">
        <table class="w-full">
            <thead>
                <tr class="bg-slate-50">
                    <th class="px-5 py-4 text-left text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Berita</th>
                    <th class="px-5 py-4 text-left text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Tanggal</th>
                    <th class="px-5 py-4 text-left text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Status</th>
                    <th class="px-5 py-4 text-center text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Aksi</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-slate-100">
                <?php $__currentLoopData = $beritaList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $berita): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="hover:bg-slate-50/50 transition-colors duration-150">
                    <td class="px-5 py-4">
                        <div class="flex items-center gap-4">
                            <?php if($berita->gambar): ?>
                            <img src="<?php echo e(asset('images/' . $berita->gambar)); ?>" alt="<?php echo e($berita->judul); ?>" class="w-16 h-12 rounded-lg object-cover">
                            <?php else: ?>
                            <div class="w-16 h-12 rounded-lg flex items-center justify-center" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
                                <svg class="w-6 h-6 text-white/50" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"/></svg>
                            </div>
                            <?php endif; ?>
                            <div class="min-w-0">
                                <p class="font-semibold text-slate-800 text-[15px] truncate max-w-xs"><?php echo e($berita->judul); ?></p>
                                <p class="text-sm text-slate-500 truncate max-w-xs"><?php echo e(Str::limit($berita->ringkasan, 50)); ?></p>
                            </div>
                        </div>
                    </td>
                    <td class="px-5 py-4 text-slate-600 text-[15px]"><?php echo e($berita->tanggal_publikasi->format('d M Y')); ?></td>
                    <td class="px-5 py-4">
                        <form action="<?php echo e(route('admin.berita.toggle', $berita->id)); ?>" method="POST" class="inline">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PATCH'); ?>
                            <button type="submit" class="inline-flex items-center gap-1.5 px-3 py-1.5 rounded-full text-xs font-semibold cursor-pointer transition-all duration-200 hover:opacity-80
                                <?php echo e($berita->status == 'published' ? 'bg-emerald-100 text-emerald-700' : 'bg-amber-100 text-amber-700'); ?>">
                                <span class="w-1.5 h-1.5 rounded-full <?php echo e($berita->status == 'published' ? 'bg-emerald-500' : 'bg-amber-500'); ?>"></span>
                                <?php echo e($berita->status == 'published' ? 'Published' : 'Draft'); ?>

                            </button>
                        </form>
                    </td>
                    <td class="px-5 py-4">
                        <div class="flex items-center justify-center gap-2">
                            <a href="<?php echo e(route('berita.show', $berita->slug)); ?>" target="_blank" class="p-2.5 text-slate-600 hover:bg-slate-100 rounded-xl transition-all duration-200" title="Lihat">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/></svg>
                            </a>
                            <a href="<?php echo e(route('admin.berita.edit', $berita->id)); ?>" class="p-2.5 text-[#1e3a5f] hover:bg-blue-50 rounded-xl transition-all duration-200" title="Edit">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/></svg>
                            </a>
                            <form action="<?php echo e(route('admin.berita.destroy', $berita->id)); ?>" method="POST" onsubmit="return confirm('Yakin ingin menghapus berita ini?')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="p-2.5 text-rose-600 hover:bg-rose-50 rounded-xl transition-all duration-200" title="Hapus">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/></svg>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    
    <?php echo e($beritaList->links('components.pagination')); ?>

    <?php else: ?>
    <div class="text-center py-16">
        <div class="w-20 h-20 rounded-2xl bg-slate-100 flex items-center justify-center mx-auto mb-5">
            <svg class="w-10 h-10 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"/></svg>
        </div>
        <p class="text-slate-500 text-lg font-medium mb-2">Belum ada berita</p>
        <p class="text-slate-400 text-[15px] mb-6">Mulai tambahkan berita pertama</p>
        <a href="<?php echo e(route('admin.berita.create')); ?>" class="inline-flex items-center gap-2 px-6 py-3 bg-[#1e3a5f] text-white rounded-xl font-semibold hover:bg-[#2d5a8a] transition-all duration-200 shadow-admin-sm hover:shadow-admin-md">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/></svg>
            Tambah Berita Pertama
        </a>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/admin/berita/index.blade.php ENDPATH**/ ?>