<?php $__env->startSection('title', isset($kegiatan) ? 'Edit Kegiatan' : 'Tambah Kegiatan'); ?>
<?php $__env->startSection('page-title', isset($kegiatan) ? 'Edit Kegiatan' : 'Tambah Kegiatan'); ?>

<?php $__env->startSection('content'); ?>
    <div class="max-w-3xl">
        <div class="bg-white rounded-xl shadow-md p-6">
            <form
                action="<?php echo e(isset($kegiatan) ? route('admin.kegiatan.update', $kegiatan->id) : route('admin.kegiatan.store')); ?>"
                method="POST" class="space-y-6">
                <?php echo csrf_field(); ?>
                <?php if(isset($kegiatan)): ?>
                    <?php echo method_field('PUT'); ?>
                <?php endif; ?>

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Nama Kegiatan *</label>
                    <input type="text" name="nama" value="<?php echo e($kegiatan->nama ?? old('nama')); ?>" required
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                        placeholder="Contoh: Persekutuan Doa">
                </div>

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Tipe Kegiatan *</label>
                    <select name="tipe" required
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                        <option value="">Pilih Tipe</option>
                        <option value="rutin" <?php echo e((isset($kegiatan) && $kegiatan->tipe == 'rutin') ? 'selected' : ''); ?>>Rutin
                        </option>
                        <option value="khusus" <?php echo e((isset($kegiatan) && $kegiatan->tipe == 'khusus') ? 'selected' : ''); ?>>
                            Khusus</option>
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Kategori</label>
                    <select name="kategori"
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                        <option value="">Pilih Kategori</option>
                        <option value="ibadah" <?php echo e((isset($kegiatan) && $kegiatan->kategori == 'ibadah') ? 'selected' : ''); ?>>
                            Ibadah</option>
                        <option value="persekutuan" <?php echo e((isset($kegiatan) && $kegiatan->kategori == 'persekutuan') ? 'selected' : ''); ?>>Persekutuan</option>
                        <option value="pelayanan" <?php echo e((isset($kegiatan) && $kegiatan->kategori == 'pelayanan') ? 'selected' : ''); ?>>Pelayanan</option>
                        <option value="sosial" <?php echo e((isset($kegiatan) && $kegiatan->kategori == 'sosial') ? 'selected' : ''); ?>>
                            Sosial</option>
                        <option value="pendidikan" <?php echo e((isset($kegiatan) && $kegiatan->kategori == 'pendidikan') ? 'selected' : ''); ?>>Pendidikan</option>
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Jadwal (untuk kegiatan
                        rutin)</label>
                    <input type="text" name="jadwal" value="<?php echo e($kegiatan->jadwal ?? old('jadwal')); ?>"
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                        placeholder="Contoh: Setiap Rabu, 18:00 WIB">
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Tanggal (untuk kegiatan
                            khusus)</label>
                        <input type="date" name="tanggal"
                            value="<?php echo e(isset($kegiatan) && $kegiatan->tanggal ? $kegiatan->tanggal->format('Y-m-d') : old('tanggal')); ?>"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                    </div>
                    <div>
                        <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Waktu</label>
                        <input type="time" name="waktu"
                            value="<?php echo e(isset($kegiatan) ? substr($kegiatan->waktu ?? '', 0, 5) : old('waktu')); ?>"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Tempat</label>
                    <input type="text" name="tempat" value="<?php echo e($kegiatan->tempat ?? old('tempat')); ?>"
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                        placeholder="Contoh: Gedung Gereja Utama">
                </div>

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Deskripsi</label>
                    <textarea name="deskripsi" rows="4"
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                        placeholder="Deskripsi kegiatan"><?php echo e($kegiatan->deskripsi ?? old('deskripsi')); ?></textarea>
                </div>

                <div>
                    <label class="flex items-center">
                        <input type="checkbox" name="aktif" value="1" <?php echo e((isset($kegiatan) && $kegiatan->aktif) ? 'checked' : (!isset($kegiatan) ? 'checked' : '')); ?> class="w-5 h-5 mr-3 rounded border-gray-300">
                        <span class="text-sm font-semibold" style="color: #1e3a5f;">Kegiatan Aktif</span>
                    </label>
                </div>

                <div class="flex items-center gap-4 pt-4">
                    <button type="submit"
                        class="px-6 py-3 rounded-xl font-semibold transition-all shadow-material-1 hover:shadow-material-2"
                        style="background: #1e3a5f; color: #ffffff;">
                        <?php echo e(isset($kegiatan) ? 'Update Kegiatan' : 'Simpan Kegiatan'); ?>

                    </button>
                    <a href="<?php echo e(route('admin.kegiatan.index')); ?>"
                        class="px-6 py-3 rounded-xl font-semibold bg-gray-200 text-gray-700 hover:bg-gray-300 transition-all">
                        Batal
                    </a>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/admin/kegiatan/form.blade.php ENDPATH**/ ?>