<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('page-title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<!-- Stats Cards -->
<div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-4 gap-5 lg:gap-6 mb-8">
    <!-- Jemaat Online -->
    <div class="bg-white rounded-2xl shadow-admin-md hover:shadow-admin-lg transition-shadow duration-300 p-6 border border-slate-100">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-slate-500 text-[15px] font-medium mb-1">Jemaat Online</p>
                <p class="text-3xl font-bold text-[#1e3a5f]"><?php echo e($jemaatOnline); ?></p>
            </div>
            <div class="w-14 h-14 bg-gradient-to-br from-blue-100 to-blue-50 rounded-2xl flex items-center justify-center">
                <svg class="w-7 h-7 text-[#1e3a5f]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
            </div>
        </div>
        <div class="mt-4 pt-4 border-t border-slate-100">
            <span class="text-sm text-slate-500">Terdaftar di sistem</span>
        </div>
    </div>

    <!-- Permohonan Doa -->
    <div class="bg-white rounded-2xl shadow-admin-md hover:shadow-admin-lg transition-shadow duration-300 p-6 border border-slate-100">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-slate-500 text-[15px] font-medium mb-1">Permohonan Doa</p>
                <p class="text-3xl font-bold text-[#d4af37]"><?php echo e($permohonanDoa); ?></p>
            </div>
            <div class="w-14 h-14 bg-gradient-to-br from-amber-100 to-amber-50 rounded-2xl flex items-center justify-center">
                <svg class="w-7 h-7 text-[#d4af37]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/></svg>
            </div>
        </div>
        <div class="mt-4 pt-4 border-t border-slate-100">
            <span class="text-sm text-slate-500">Menunggu diproses</span>
        </div>
    </div>

    <!-- Donasi Bulan Ini -->
    <div class="bg-white rounded-2xl shadow-admin-md hover:shadow-admin-lg transition-shadow duration-300 p-6 border border-slate-100">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-slate-500 text-[15px] font-medium mb-1">Donasi Bulan Ini</p>
                <p class="text-2xl font-bold text-emerald-600">Rp <?php echo e(number_format($donasiBulanIni, 0, ',', '.')); ?></p>
            </div>
            <div class="w-14 h-14 bg-gradient-to-br from-emerald-100 to-emerald-50 rounded-2xl flex items-center justify-center">
                <svg class="w-7 h-7 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
            </div>
        </div>
        <div class="mt-4 pt-4 border-t border-slate-100">
            <span class="text-sm text-slate-500">Total terkonfirmasi</span>
        </div>
    </div>

    <!-- Konseling Pending -->
    <div class="bg-white rounded-2xl shadow-admin-md hover:shadow-admin-lg transition-shadow duration-300 p-6 border border-slate-100">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-slate-500 text-[15px] font-medium mb-1">Konseling Pending</p>
                <p class="text-3xl font-bold text-rose-600"><?php echo e($konselingPending); ?></p>
            </div>
            <div class="w-14 h-14 bg-gradient-to-br from-rose-100 to-rose-50 rounded-2xl flex items-center justify-center">
                <svg class="w-7 h-7 text-rose-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/></svg>
            </div>
        </div>
        <div class="mt-4 pt-4 border-t border-slate-100">
            <span class="text-sm text-slate-500">Perlu ditindaklanjuti</span>
        </div>
    </div>
</div>

<!-- Recent Activity & Quick Actions -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-5 lg:gap-6">
    <!-- Notifikasi Terbaru -->
    <div class="bg-white rounded-2xl shadow-admin-md p-6 border border-slate-100">
        <h3 class="text-lg font-bold text-[#1e3a5f] mb-5 flex items-center gap-2">
            <span class="w-1.5 h-6 bg-[#d4af37] rounded-full"></span>
            Notifikasi Terbaru
        </h3>
        <div class="space-y-3">
            <?php $__empty_1 = true; $__currentLoopData = $notifikasi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notif): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="flex items-start gap-4 p-4 bg-slate-50 rounded-xl hover:bg-slate-100 transition-colors duration-200">
                <div class="w-11 h-11 rounded-xl flex items-center justify-center flex-shrink-0 shadow-admin-sm
                    <?php echo e($notif['type'] == 'doa' ? 'bg-amber-100' : ($notif['type'] == 'donasi' ? 'bg-emerald-100' : ($notif['type'] == 'pesan' ? 'bg-purple-100' : 'bg-blue-100'))); ?>">
                    <?php if($notif['type'] == 'doa'): ?>
                    <svg class="w-5 h-5 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/></svg>
                    <?php elseif($notif['type'] == 'donasi'): ?>
                    <svg class="w-5 h-5 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                    <?php elseif($notif['type'] == 'pesan'): ?>
                    <svg class="w-5 h-5 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                    <?php else: ?>
                    <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/></svg>
                    <?php endif; ?>
                </div>
                <div class="flex-grow min-w-0">
                    <p class="text-slate-700 font-medium text-[15px]"><?php echo e($notif['pesan']); ?></p>
                    <p class="text-sm text-slate-500 mt-1"><?php echo e($notif['waktu']); ?></p>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-center py-8 text-slate-500">
                <svg class="w-12 h-12 mx-auto mb-3 text-slate-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"/></svg>
                <p>Belum ada notifikasi</p>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Aksi Cepat -->
    <div class="bg-white rounded-2xl shadow-admin-md p-6 border border-slate-100">
        <h3 class="text-lg font-bold text-[#1e3a5f] mb-5 flex items-center gap-2">
            <span class="w-1.5 h-6 bg-[#d4af37] rounded-full"></span>
            Aksi Cepat
        </h3>
        <div class="grid grid-cols-2 gap-4">
            <a href="<?php echo e(route('admin.jadwal.create')); ?>" class="group flex flex-col items-center p-5 bg-slate-50 rounded-xl hover:bg-[#1e3a5f] transition-all duration-300 hover:shadow-admin-lg">
                <div class="w-14 h-14 rounded-xl bg-white group-hover:bg-white/20 flex items-center justify-center mb-3 shadow-admin-sm group-hover:shadow-none transition-all duration-300">
                    <svg class="w-7 h-7 text-[#1e3a5f] group-hover:text-white transition-colors duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
                </div>
                <span class="text-[15px] font-semibold text-slate-700 group-hover:text-white text-center transition-colors duration-300">Tambah Jadwal</span>
            </a>
            <a href="<?php echo e(route('admin.kegiatan.create')); ?>" class="group flex flex-col items-center p-5 bg-slate-50 rounded-xl hover:bg-[#1e3a5f] transition-all duration-300 hover:shadow-admin-lg">
                <div class="w-14 h-14 rounded-xl bg-white group-hover:bg-white/20 flex items-center justify-center mb-3 shadow-admin-sm group-hover:shadow-none transition-all duration-300">
                    <svg class="w-7 h-7 text-[#1e3a5f] group-hover:text-white transition-colors duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/></svg>
                </div>
                <span class="text-[15px] font-semibold text-slate-700 group-hover:text-white text-center transition-colors duration-300">Tambah Kegiatan</span>
            </a>
            <a href="<?php echo e(route('admin.formulir.index')); ?>" class="group flex flex-col items-center p-5 bg-slate-50 rounded-xl hover:bg-[#1e3a5f] transition-all duration-300 hover:shadow-admin-lg">
                <div class="w-14 h-14 rounded-xl bg-white group-hover:bg-white/20 flex items-center justify-center mb-3 shadow-admin-sm group-hover:shadow-none transition-all duration-300">
                    <svg class="w-7 h-7 text-[#1e3a5f] group-hover:text-white transition-colors duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/></svg>
                </div>
                <span class="text-[15px] font-semibold text-slate-700 group-hover:text-white text-center transition-colors duration-300">Lihat Formulir</span>
            </a>
            <a href="<?php echo e(route('admin.komunikasi.create')); ?>" class="group flex flex-col items-center p-5 bg-slate-50 rounded-xl hover:bg-[#1e3a5f] transition-all duration-300 hover:shadow-admin-lg">
                <div class="w-14 h-14 rounded-xl bg-white group-hover:bg-white/20 flex items-center justify-center mb-3 shadow-admin-sm group-hover:shadow-none transition-all duration-300">
                    <svg class="w-7 h-7 text-[#1e3a5f] group-hover:text-white transition-colors duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z"/></svg>
                </div>
                <span class="text-[15px] font-semibold text-slate-700 group-hover:text-white text-center transition-colors duration-300">Buat Meeting</span>
            </a>
        </div>
    </div>
</div>

<!-- Jadwal Ibadah Minggu Ini -->
<div class="mt-6 bg-white rounded-2xl shadow-admin-md p-6 border border-slate-100">
    <div class="flex items-center justify-between mb-5">
        <h3 class="text-lg font-bold text-[#1e3a5f] flex items-center gap-2">
            <span class="w-1.5 h-6 bg-[#d4af37] rounded-full"></span>
            Jadwal Ibadah Minggu Ini
        </h3>
        <a href="<?php echo e(route('admin.jadwal.index')); ?>" class="inline-flex items-center gap-1 px-4 py-2 text-[#1e3a5f] hover:text-[#d4af37] font-semibold text-sm rounded-lg hover:bg-slate-50 transition-all duration-200">
            Lihat Semua
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
        </a>
    </div>
    <div class="overflow-x-auto rounded-xl border border-slate-200">
        <table class="w-full">
            <thead>
                <tr class="bg-slate-50">
                    <th class="text-left py-4 px-5 text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Ibadah</th>
                    <th class="text-left py-4 px-5 text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Hari/Tanggal</th>
                    <th class="text-left py-4 px-5 text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Waktu</th>
                    <th class="text-left py-4 px-5 text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Pelayan</th>
                    <th class="text-left py-4 px-5 text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Status</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-slate-100">
                <?php $__empty_1 = true; $__currentLoopData = $jadwalMingguIni; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jadwal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="hover:bg-slate-50/50 transition-colors duration-150">
                    <td class="py-4 px-5 font-semibold text-slate-800 text-[15px]"><?php echo e($jadwal['nama']); ?></td>
                    <td class="py-4 px-5 text-slate-600 text-[15px]"><?php echo e($jadwal['tanggal']); ?></td>
                    <td class="py-4 px-5 text-slate-600 text-[15px]"><?php echo e($jadwal['waktu']); ?></td>
                    <td class="py-4 px-5 text-slate-600 text-[15px]"><?php echo e($jadwal['pelayan']); ?></td>
                    <td class="py-4 px-5">
                        <span class="inline-flex items-center gap-1.5 px-3 py-1.5 rounded-full text-xs font-semibold <?php echo e($jadwal['online'] ? 'bg-emerald-100 text-emerald-700' : 'bg-slate-100 text-slate-600'); ?>">
                            <span class="w-1.5 h-1.5 rounded-full <?php echo e($jadwal['online'] ? 'bg-emerald-500' : 'bg-slate-400'); ?>"></span>
                            <?php echo e($jadwal['online'] ? 'Online' : 'Offline'); ?>

                        </span>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="5" class="py-8 text-center text-slate-500">Belum ada jadwal minggu ini</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>