<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'Admin Dashboard'); ?> - Gereja Buntu Ambaang</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <style>
        /* Admin-specific base styles */
        .admin-layout {
            font-family: 'Nunito', sans-serif;
        }

        .admin-layout * {
            font-family: inherit;
        }

        /* Smooth scrollbar for sidebar */
        .admin-sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .admin-sidebar::-webkit-scrollbar-track {
            background: transparent;
        }

        .admin-sidebar::-webkit-scrollbar-thumb {
            background: rgba(255, 255, 255, 0.2);
            border-radius: 3px;
        }

        .admin-sidebar::-webkit-scrollbar-thumb:hover {
            background: rgba(255, 255, 255, 0.3);
        }

        /* Focus visible for accessibility */
        .admin-layout *:focus-visible {
            outline: 2px solid #d4af37;
            outline-offset: 2px;
        }

        /* Material ripple effect */
        .admin-ripple {
            position: relative;
            overflow: hidden;
        }

        .admin-ripple::after {
            content: '';
            position: absolute;
            inset: 0;
            background: radial-gradient(circle, rgba(255, 255, 255, 0.3) 10%, transparent 10%);
            transform: scale(10);
            opacity: 0;
            transition: transform 0.5s, opacity 0.3s;
        }

        .admin-ripple:active::after {
            transform: scale(0);
            opacity: 1;
            transition: 0s;
        }
    </style>
</head>

<body class="admin-layout bg-slate-50 text-slate-700 antialiased">
    <div class="flex min-h-screen">

        <!-- ===== SIDEBAR ===== -->
        <aside id="sidebar"
            class="admin-sidebar w-[280px] bg-gradient-to-b from-[#1e3a5f] to-[#152a45] text-white fixed h-full z-40 transform -translate-x-full lg:translate-x-0 transition-all duration-300 ease-admin shadow-admin-xl overflow-y-auto">

            <!-- Logo Section -->
            <div class="px-6 py-6 border-b border-white/10">
                <div class="flex items-center gap-3">
                    <div class="w-11 h-11 rounded-xl bg-[#d4af37] flex items-center justify-center shadow-admin-md">
                        <svg class="w-6 h-6 text-[#1e3a5f]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                        </svg>
                    </div>
                    <div>
                        <h1 class="text-lg font-bold text-[#d4af37] leading-tight">Admin Panel</h1>
                        <p class="text-xs text-slate-300 font-medium">Gereja Buntu Ambaang</p>
                    </div>
                </div>
            </div>

            <!-- Navigation -->
            <nav class="p-4 space-y-1.5">
                <!-- Menu Label -->
                <p class="px-4 py-2 text-xs font-semibold text-slate-400 uppercase tracking-wider">Menu Utama</p>

                <!-- Dashboard -->
                <a href="<?php echo e(route('admin.dashboard')); ?>"
                    class="admin-nav-item group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] transition-all duration-200 <?php echo e(request()->routeIs('admin.dashboard') ? 'bg-white/15 text-white shadow-admin-inner' : 'text-slate-300 hover:bg-white/10 hover:text-white'); ?>">
                    <span
                        class="w-9 h-9 rounded-lg flex items-center justify-center transition-all duration-200 <?php echo e(request()->routeIs('admin.dashboard') ? 'bg-[#d4af37] text-[#1e3a5f]' : 'bg-white/10 group-hover:bg-white/15'); ?>">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z" />
                        </svg>
                    </span>
                    Dashboard
                </a>

                <!-- Profil Gereja -->
                <a href="<?php echo e(route('admin.profil.index')); ?>"
                    class="admin-nav-item group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] transition-all duration-200 <?php echo e(request()->routeIs('admin.profil.*') ? 'bg-white/15 text-white shadow-admin-inner' : 'text-slate-300 hover:bg-white/10 hover:text-white'); ?>">
                    <span
                        class="w-9 h-9 rounded-lg flex items-center justify-center transition-all duration-200 <?php echo e(request()->routeIs('admin.profil.*') ? 'bg-[#d4af37] text-[#1e3a5f]' : 'bg-white/10 group-hover:bg-white/15'); ?>">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                        </svg>
                    </span>
                    Profil Gereja
                </a>

                <!-- Jadwal Ibadah -->
                <a href="<?php echo e(route('admin.jadwal.index')); ?>"
                    class="admin-nav-item group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] transition-all duration-200 <?php echo e(request()->routeIs('admin.jadwal.*') ? 'bg-white/15 text-white shadow-admin-inner' : 'text-slate-300 hover:bg-white/10 hover:text-white'); ?>">
                    <span
                        class="w-9 h-9 rounded-lg flex items-center justify-center transition-all duration-200 <?php echo e(request()->routeIs('admin.jadwal.*') ? 'bg-[#d4af37] text-[#1e3a5f]' : 'bg-white/10 group-hover:bg-white/15'); ?>">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                        </svg>
                    </span>
                    Jadwal Ibadah
                </a>

                <!-- Ibadah Khusus -->
                <a href="<?php echo e(route('admin.ibadah-khusus.index')); ?>"
                    class="admin-nav-item group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] transition-all duration-200 <?php echo e(request()->routeIs('admin.ibadah-khusus.*') ? 'bg-white/15 text-white shadow-admin-inner' : 'text-slate-300 hover:bg-white/10 hover:text-white'); ?>">
                    <span
                        class="w-9 h-9 rounded-lg flex items-center justify-center transition-all duration-200 <?php echo e(request()->routeIs('admin.ibadah-khusus.*') ? 'bg-[#d4af37] text-[#1e3a5f]' : 'bg-white/10 group-hover:bg-white/15'); ?>">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-7.714 2.143L11 21l-2.286-6.857L1 12l7.714-2.143L11 3z" />
                        </svg>
                    </span>
                    Ibadah Khusus
                </a>

                <!-- OIG -->
                <a href="<?php echo e(route('admin.oig.index')); ?>"
                    class="admin-nav-item group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] transition-all duration-200 <?php echo e(request()->routeIs('admin.oig.*') ? 'bg-white/15 text-white shadow-admin-inner' : 'text-slate-300 hover:bg-white/10 hover:text-white'); ?>">
                    <span
                        class="w-9 h-9 rounded-lg flex items-center justify-center transition-all duration-200 <?php echo e(request()->routeIs('admin.oig.*') ? 'bg-[#d4af37] text-[#1e3a5f]' : 'bg-white/10 group-hover:bg-white/15'); ?>">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0z" />
                        </svg>
                    </span>
                    OIG
                </a>

                <!-- Kegiatan -->
                <a href="<?php echo e(route('admin.kegiatan.index')); ?>"
                    class="admin-nav-item group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] transition-all duration-200 <?php echo e(request()->routeIs('admin.kegiatan.*') ? 'bg-white/15 text-white shadow-admin-inner' : 'text-slate-300 hover:bg-white/10 hover:text-white'); ?>">
                    <span
                        class="w-9 h-9 rounded-lg flex items-center justify-center transition-all duration-200 <?php echo e(request()->routeIs('admin.kegiatan.*') ? 'bg-[#d4af37] text-[#1e3a5f]' : 'bg-white/10 group-hover:bg-white/15'); ?>">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                        </svg>
                    </span>
                    Kegiatan
                </a>

                <!-- Berita -->
                <a href="<?php echo e(route('admin.berita.index')); ?>"
                    class="admin-nav-item group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] transition-all duration-200 <?php echo e(request()->routeIs('admin.berita.*') ? 'bg-white/15 text-white shadow-admin-inner' : 'text-slate-300 hover:bg-white/10 hover:text-white'); ?>">
                    <span
                        class="w-9 h-9 rounded-lg flex items-center justify-center transition-all duration-200 <?php echo e(request()->routeIs('admin.berita.*') ? 'bg-[#d4af37] text-[#1e3a5f]' : 'bg-white/10 group-hover:bg-white/15'); ?>">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z" />
                        </svg>
                    </span>
                    Berita
                </a>

                <!-- Pengumuman -->
                <a href="<?php echo e(route('admin.pengumuman.index')); ?>"
                    class="admin-nav-item group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] transition-all duration-200 <?php echo e(request()->routeIs('admin.pengumuman.*') ? 'bg-white/15 text-white shadow-admin-inner' : 'text-slate-300 hover:bg-white/10 hover:text-white'); ?>">
                    <span
                        class="w-9 h-9 rounded-lg flex items-center justify-center transition-all duration-200 <?php echo e(request()->routeIs('admin.pengumuman.*') ? 'bg-[#d4af37] text-[#1e3a5f]' : 'bg-white/10 group-hover:bg-white/15'); ?>">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z" />
                        </svg>
                    </span>
                    Pengumuman
                </a>

                <!-- Kalender -->
                <a href="<?php echo e(route('admin.kalender.index')); ?>"
                    class="admin-nav-item group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] transition-all duration-200 <?php echo e(request()->routeIs('admin.kalender.*') ? 'bg-white/15 text-white shadow-admin-inner' : 'text-slate-300 hover:bg-white/10 hover:text-white'); ?>">
                    <span
                        class="w-9 h-9 rounded-lg flex items-center justify-center transition-all duration-200 <?php echo e(request()->routeIs('admin.kalender.*') ? 'bg-[#d4af37] text-[#1e3a5f]' : 'bg-white/10 group-hover:bg-white/15'); ?>">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                        </svg>
                    </span>
                    Kalender
                </a>

                <!-- Divider -->
                <div class="my-4 border-t border-white/10"></div>
                <p class="px-4 py-2 text-xs font-semibold text-slate-400 uppercase tracking-wider">Layanan</p>

                <!-- Formulir -->
                <a href="<?php echo e(route('admin.formulir.index')); ?>"
                    class="admin-nav-item group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] transition-all duration-200 <?php echo e(request()->routeIs('admin.formulir.*') ? 'bg-white/15 text-white shadow-admin-inner' : 'text-slate-300 hover:bg-white/10 hover:text-white'); ?>">
                    <span
                        class="w-9 h-9 rounded-lg flex items-center justify-center transition-all duration-200 <?php echo e(request()->routeIs('admin.formulir.*') ? 'bg-[#d4af37] text-[#1e3a5f]' : 'bg-white/10 group-hover:bg-white/15'); ?>">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                        </svg>
                    </span>
                    Formulir
                </a>

                <!-- Keuangan -->
                <a href="<?php echo e(route('admin.keuangan.index')); ?>"
                    class="admin-nav-item group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] transition-all duration-200 <?php echo e(request()->routeIs('admin.keuangan.*') ? 'bg-white/15 text-white shadow-admin-inner' : 'text-slate-300 hover:bg-white/10 hover:text-white'); ?>">
                    <span
                        class="w-9 h-9 rounded-lg flex items-center justify-center transition-all duration-200 <?php echo e(request()->routeIs('admin.keuangan.*') ? 'bg-[#d4af37] text-[#1e3a5f]' : 'bg-white/10 group-hover:bg-white/15'); ?>">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </span>
                    Keuangan
                </a>

                <!-- Donasi -->
                <a href="<?php echo e(route('admin.donasi.index')); ?>"
                    class="admin-nav-item group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] transition-all duration-200 <?php echo e(request()->routeIs('admin.donasi.*') ? 'bg-white/15 text-white shadow-admin-inner' : 'text-slate-300 hover:bg-white/10 hover:text-white'); ?>">
                    <span
                        class="w-9 h-9 rounded-lg flex items-center justify-center transition-all duration-200 <?php echo e(request()->routeIs('admin.donasi.*') ? 'bg-[#d4af37] text-[#1e3a5f]' : 'bg-white/10 group-hover:bg-white/15'); ?>">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                        </svg>
                    </span>
                    Donasi
                </a>

                <!-- Komunikasi -->
                <a href="<?php echo e(route('admin.komunikasi.index')); ?>"
                    class="admin-nav-item group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] transition-all duration-200 <?php echo e(request()->routeIs('admin.komunikasi.*') ? 'bg-white/15 text-white shadow-admin-inner' : 'text-slate-300 hover:bg-white/10 hover:text-white'); ?>">
                    <span
                        class="w-9 h-9 rounded-lg flex items-center justify-center transition-all duration-200 <?php echo e(request()->routeIs('admin.komunikasi.*') ? 'bg-[#d4af37] text-[#1e3a5f]' : 'bg-white/10 group-hover:bg-white/15'); ?>">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z" />
                        </svg>
                    </span>
                    Komunikasi
                </a>

                <!-- Pesan Kontak -->
                <a href="<?php echo e(route('admin.pesan.index')); ?>"
                    class="admin-nav-item group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] transition-all duration-200 <?php echo e(request()->routeIs('admin.pesan.*') ? 'bg-white/15 text-white shadow-admin-inner' : 'text-slate-300 hover:bg-white/10 hover:text-white'); ?>">
                    <span
                        class="w-9 h-9 rounded-lg flex items-center justify-center transition-all duration-200 <?php echo e(request()->routeIs('admin.pesan.*') ? 'bg-[#d4af37] text-[#1e3a5f]' : 'bg-white/10 group-hover:bg-white/15'); ?>">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                        </svg>
                    </span>
                    <span class="flex items-center gap-2">
                        Pesan Kontak
                        <?php
                            $pesanBelumDibaca = \App\Models\PesanKontak::jumlahBelumDibaca();
                        ?>
                        <?php if($pesanBelumDibaca > 0): ?>
                            <span
                                class="px-2 py-0.5 text-xs font-bold bg-red-500 text-white rounded-full"><?php echo e($pesanBelumDibaca); ?></span>
                        <?php endif; ?>
                    </span>
                </a>

                <!-- Divider -->
                <div class="my-4 border-t border-white/10"></div>
                <p class="px-4 py-2 text-xs font-semibold text-slate-400 uppercase tracking-wider">Pengaturan</p>

                <!-- Pengguna -->
                <a href="<?php echo e(route('admin.user.index')); ?>"
                    class="admin-nav-item group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] transition-all duration-200 <?php echo e(request()->routeIs('admin.user.*') ? 'bg-white/15 text-white shadow-admin-inner' : 'text-slate-300 hover:bg-white/10 hover:text-white'); ?>">
                    <span
                        class="w-9 h-9 rounded-lg flex items-center justify-center transition-all duration-200 <?php echo e(request()->routeIs('admin.user.*') ? 'bg-[#d4af37] text-[#1e3a5f]' : 'bg-white/10 group-hover:bg-white/15'); ?>">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z" />
                        </svg>
                    </span>
                    Pengguna
                </a>

                <!-- Spacer -->
                <div class="h-4"></div>

                <!-- Lihat Website -->
                <a href="<?php echo e(route('beranda')); ?>" target="_blank"
                    class="group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] text-slate-400 hover:bg-white/5 hover:text-slate-300 transition-all duration-200">
                    <span
                        class="w-9 h-9 rounded-lg bg-white/5 flex items-center justify-center group-hover:bg-white/10 transition-all duration-200">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" />
                        </svg>
                    </span>
                    Lihat Website
                </a>

                <!-- Logout -->
                <form method="POST" action="<?php echo e(route('admin.logout')); ?>">
                    <?php echo csrf_field(); ?>
                    <button type="submit"
                        class="w-full group flex items-center gap-3 px-4 py-3.5 rounded-xl font-semibold text-[15px] text-red-300 hover:bg-red-500/20 hover:text-red-200 transition-all duration-200">
                        <span
                            class="w-9 h-9 rounded-lg bg-red-500/10 flex items-center justify-center group-hover:bg-red-500/20 transition-all duration-200">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                            </svg>
                        </span>
                        Keluar
                    </button>
                </form>
            </nav>
        </aside>

        <!-- ===== MAIN CONTENT ===== -->
        <div class="flex-1 lg:ml-[280px] min-h-screen flex flex-col">

            <!-- Top Header -->
            <header class="bg-white/80 backdrop-blur-xl sticky top-0 z-30 border-b border-slate-200/80">
                <div class="flex items-center justify-between px-6 lg:px-8 py-4">
                    <!-- Mobile Menu Toggle -->
                    <button id="sidebar-toggle"
                        class="lg:hidden p-2.5 rounded-xl hover:bg-slate-100 active:bg-slate-200 transition-colors duration-200">
                        <svg class="w-6 h-6 text-slate-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                    </button>

                    <!-- Page Title -->
                    <div class="flex-1 lg:flex-none">
                        <h2 class="text-xl lg:text-2xl font-bold text-[#1e3a5f]"><?php echo $__env->yieldContent('page-title', 'Dashboard'); ?></h2>
                    </div>

                    <!-- User Info -->
                    <div class="flex items-center gap-4">
                        <div class="hidden sm:flex items-center gap-3 px-4 py-2 bg-slate-50 rounded-xl">
                            <div
                                class="w-9 h-9 rounded-full bg-gradient-to-br from-[#1e3a5f] to-[#2d5a8a] flex items-center justify-center text-white font-bold text-sm shadow-admin-sm">
                                <?php echo e(substr(Auth::user()->name ?? 'A', 0, 1)); ?>

                            </div>
                            <div class="text-right">
                                <p class="text-sm font-semibold text-slate-700"><?php echo e(Auth::user()->name ?? 'Admin'); ?></p>
                                <p class="text-xs text-slate-500"><?php echo e(ucfirst(Auth::user()->role ?? 'Administrator')); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Page Content -->
            <main class="flex-1 p-6 lg:p-8">
                <!-- Success Alert -->
                <?php if(session('success')): ?>
                    <div
                        class="mb-6 flex items-center gap-3 px-5 py-4 bg-emerald-50 border border-emerald-200 text-emerald-700 rounded-xl shadow-admin-sm animate-fade-in">
                        <span class="flex-shrink-0 w-10 h-10 rounded-full bg-emerald-100 flex items-center justify-center">
                            <svg class="w-5 h-5 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                            </svg>
                        </span>
                        <p class="font-medium text-[15px]"><?php echo e(session('success')); ?></p>
                    </div>
                <?php endif; ?>

                <!-- Error Alert -->
                <?php if(session('error')): ?>
                    <div
                        class="mb-6 flex items-center gap-3 px-5 py-4 bg-red-50 border border-red-200 text-red-700 rounded-xl shadow-admin-sm animate-fade-in">
                        <span class="flex-shrink-0 w-10 h-10 rounded-full bg-red-100 flex items-center justify-center">
                            <svg class="w-5 h-5 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </span>
                        <p class="font-medium text-[15px]"><?php echo e(session('error')); ?></p>
                    </div>
                <?php endif; ?>

                <!-- Page Content -->
                <?php echo $__env->yieldContent('content'); ?>
            </main>

            <!-- Footer -->
            <footer class="px-6 lg:px-8 py-4 border-t border-slate-200/80 bg-white/50">
                <p class="text-center text-sm text-slate-500">&copy; <?php echo e(date('Y')); ?> Gereja Jemaat Buntu Ambaang. Panel
                    Admin.</p>
            </footer>
        </div>
    </div>

    <!-- Mobile Sidebar Overlay -->
    <div id="sidebar-overlay"
        class="fixed inset-0 bg-black/60 backdrop-blur-sm z-30 hidden lg:hidden transition-opacity duration-300"></div>

    <script>
        // Sidebar Toggle
        const sidebar = document.getElementById('sidebar');
        const sidebarToggle = document.getElementById('sidebar-toggle');
        const sidebarOverlay = document.getElementById('sidebar-overlay');

        sidebarToggle?.addEventListener('click', () => {
            sidebar.classList.toggle('-translate-x-full');
            sidebarOverlay.classList.toggle('hidden');
        });

        sidebarOverlay?.addEventListener('click', () => {
            sidebar.classList.add('-translate-x-full');
            sidebarOverlay.classList.add('hidden');
        });

        // Auto-hide alerts after 5 seconds
        document.querySelectorAll('.animate-fade-in').forEach(alert => {
            setTimeout(() => {
                alert.style.opacity = '0';
                alert.style.transform = 'translateY(-10px)';
                setTimeout(() => alert.remove(), 300);
            }, 5000);
        });
    </script>

    <style>
        .animate-fade-in {
            animation: fadeIn 0.3s ease-out;
            transition: opacity 0.3s, transform 0.3s;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    </style>
</body>

</html><?php /**PATH D:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/layouts/admin.blade.php ENDPATH**/ ?>