

<?php $__env->startSection('title', 'Manajemen Ibadah Khusus'); ?>
<?php $__env->startSection('page-title', 'Manajemen Ibadah Khusus'); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-white rounded-xl shadow-md p-6">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-6">
            <h2 class="text-xl font-bold text-gereja-biru mb-4 md:mb-0">Daftar Ibadah Khusus</h2>
            <a href="<?php echo e(route('admin.ibadah-khusus.create')); ?>"
                class="inline-flex items-center px-6 py-3 bg-gereja-biru text-white rounded-lg font-bold hover:bg-gereja-biru-light transition">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                </svg>
                Tambah Ibadah Khusus
            </a>
        </div>

        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-3 text-left text-gray-600">Nama Ibadah</th>
                        <th class="px-4 py-3 text-left text-gray-600">Kategori</th>
                        <th class="px-4 py-3 text-left text-gray-600">Tanggal & Waktu</th>
                        <th class="px-4 py-3 text-left text-gray-600">Tempat</th>
                        <th class="px-4 py-3 text-left text-gray-600">Pelayan</th>
                        <th class="px-4 py-3 text-left text-gray-600">Status</th>
                        <th class="px-4 py-3 text-left text-gray-600">Aksi</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    <?php $__empty_1 = true; $__currentLoopData = $jadwalList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jadwal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-4 font-semibold text-gereja-biru"><?php echo e($jadwal->nama); ?></td>
                            <td class="px-4 py-4">
                                <span
                                    class="px-2 py-1 bg-blue-100 text-blue-700 rounded text-xs font-bold uppercase"><?php echo e($jadwal->kategori ?? 'Umum'); ?></span>
                            </td>
                            <td class="px-4 py-4">
                                <div class="text-sm font-medium"><?php echo e($jadwal->tanggal->translatedFormat('d M Y')); ?></div>
                                <div class="text-xs text-gray-500"><?php echo e($jadwal->waktu); ?> WIB</div>
                            </td>
                            <td class="px-4 py-4 text-sm"><?php echo e($jadwal->tempat); ?></td>
                            <td class="px-4 py-4 text-sm"><?php echo e($jadwal->pelayan); ?></td>
                            <td class="px-4 py-4">
                                <?php if($jadwal->aktif): ?>
                                    <span class="px-2 py-1 bg-green-100 text-green-700 rounded text-xs font-bold">Aktif</span>
                                <?php else: ?>
                                    <span class="px-2 py-1 bg-red-100 text-red-700 rounded text-xs font-bold">Non-aktif</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-4">
                                <div class="flex items-center space-x-2">
                                    <a href="<?php echo e(route('admin.ibadah-khusus.edit', $jadwal->id)); ?>"
                                        class="p-2 text-blue-600 hover:bg-blue-100 rounded-lg" title="Edit">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                                        </svg>
                                    </a>
                                    <form action="<?php echo e(route('admin.ibadah-khusus.destroy', $jadwal->id)); ?>" method="POST"
                                        onsubmit="return confirm('Yakin ingin menghapus jadwal ibadah khusus ini?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="p-2 text-red-600 hover:bg-red-100 rounded-lg"
                                            title="Hapus">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                            </svg>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="px-4 py-8 text-center text-gray-500 italic">Belum ada data ibadah khusus.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="mt-6">
            <?php echo e($jadwalList->links('components.pagination')); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/admin/ibadah-khusus/index.blade.php ENDPATH**/ ?>