<?php $__env->startSection('title', 'Manajemen Formulir'); ?>
<?php $__env->startSection('page-title', 'Manajemen Formulir Jemaat'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Tabs Navigation -->
    <div class="bg-white rounded-2xl shadow-admin-md border border-slate-100 mb-6 overflow-hidden">
        <div class="flex border-b border-slate-200">
            <button id="btn-doa"
                class="tab-btn flex-1 sm:flex-none px-6 py-4 font-semibold text-[15px] text-[#1e3a5f] border-b-3 border-[#d4af37] bg-slate-50 transition-all duration-200"
                onclick="showTab('doa')">
                <span class="flex items-center justify-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                            d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                    </svg>
                    Permohonan Doa
                </span>
            </button>
            <button id="btn-pendaftaran"
                class="tab-btn flex-1 sm:flex-none px-6 py-4 font-semibold text-[15px] text-slate-500 hover:text-[#1e3a5f] hover:bg-slate-50 transition-all duration-200"
                onclick="showTab('pendaftaran')">
                <span class="flex items-center justify-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                            d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2" />
                    </svg>
                    Pendaftaran
                </span>
            </button>
            <button id="btn-konseling"
                class="tab-btn flex-1 sm:flex-none px-6 py-4 font-semibold text-[15px] text-slate-500 hover:text-[#1e3a5f] hover:bg-slate-50 transition-all duration-200"
                onclick="showTab('konseling')">
                <span class="flex items-center justify-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                            d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z" />
                    </svg>
                    Konseling
                </span>
            </button>
        </div>
    </div>

    <!-- Tab: Permohonan Doa -->
    <div id="tab-doa" class="bg-white rounded-2xl shadow-admin-md border border-slate-100 p-6">
        <div class="flex items-center gap-2 mb-6">
            <span class="w-1.5 h-7 bg-[#d4af37] rounded-full"></span>
            <h2 class="text-xl font-bold text-[#1e3a5f]">Daftar Permohonan Doa</h2>
        </div>

        <div class="space-y-4">
            <?php $__empty_1 = true; $__currentLoopData = $permohonanDoa; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div
                    class="bg-slate-50 rounded-xl p-5 hover:shadow-admin-md transition-all duration-300 border border-slate-100 hover:border-slate-200">
                    <div class="flex flex-col md:flex-row md:items-start md:justify-between gap-4 mb-4">
                        <div class="flex items-start gap-4">
                            <div
                                class="w-12 h-12 rounded-xl bg-gradient-to-br from-amber-100 to-amber-50 flex items-center justify-center flex-shrink-0 shadow-admin-sm">
                                <svg class="w-6 h-6 text-[#d4af37]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                        d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                                </svg>
                            </div>
                            <div>
                                <h3 class="font-bold text-[#1e3a5f] text-lg"><?php echo e($doa['nama']); ?></h3>
                                <p class="text-sm text-slate-500 mt-0.5"><?php echo e($doa['telepon']); ?> &bull; <?php echo e($doa['tanggal']); ?></p>
                            </div>
                        </div>
                        <div class="flex flex-wrap gap-2">
                            <span
                                class="inline-flex items-center gap-1.5 px-3 py-1.5 rounded-full text-xs font-semibold
                                                                <?php echo e($doa['status'] == 'pending' ? 'bg-amber-100 text-amber-700' : ($doa['status'] == 'proses' ? 'bg-blue-100 text-blue-700' : 'bg-emerald-100 text-emerald-700')); ?>">
                                <span
                                    class="w-1.5 h-1.5 rounded-full <?php echo e($doa['status'] == 'pending' ? 'bg-amber-500' : ($doa['status'] == 'proses' ? 'bg-blue-500' : 'bg-emerald-500')); ?>"></span>
                                <?php echo e(ucfirst($doa['status'])); ?>

                            </span>
                            <span
                                class="px-3 py-1.5 rounded-full text-xs font-semibold bg-slate-200 text-slate-700"><?php echo e($doa['kategori']); ?></span>
                        </div>
                    </div>

                    <p class="text-slate-600 text-[15px] leading-relaxed mb-4 pl-16 md:pl-0"><?php echo e($doa['permohonan']); ?></p>

                    <div class="flex flex-wrap items-center gap-3 pt-4 border-t border-slate-200">
                        <?php if($doa['status'] != 'selesai'): ?>
                            <?php if($doa['status'] == 'pending'): ?>
                                <a href="<?php echo e(route('admin.formulir.doa.status', ['id' => $doa['id'], 'status' => 'proses'])); ?>"
                                    class="inline-flex items-center gap-2 px-5 py-2.5 bg-[#1e3a5f] text-white rounded-xl text-sm font-semibold hover:bg-[#2d5a8a] transition-all duration-200 shadow-admin-sm hover:shadow-admin-md">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    Proses
                                </a>
                            <?php endif; ?>
                            <a href="<?php echo e(route('admin.formulir.doa.status', ['id' => $doa['id'], 'status' => 'selesai'])); ?>"
                                class="inline-flex items-center gap-2 px-5 py-2.5 bg-emerald-600 text-white rounded-xl text-sm font-semibold hover:bg-emerald-700 transition-all duration-200 shadow-admin-sm hover:shadow-admin-md">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                </svg>
                                Selesai
                            </a>
                        <?php endif; ?>

                        <form action="<?php echo e(route('admin.formulir.doa.delete', $doa['id'])); ?>" method="POST"
                            onsubmit="return confirm('Yakin ingin menghapus permohonan doa ini?')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit"
                                class="inline-flex items-center gap-2 px-5 py-2.5 bg-red-50 text-red-600 border border-red-100 rounded-xl text-sm font-semibold hover:bg-red-100 transition-all duration-200">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                </svg>
                                Hapus
                            </button>
                        </form>
                        <?php if($doa['privasi']): ?>
                            <span class="inline-flex items-center gap-1.5 text-sm text-rose-600 font-medium ml-auto">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                                </svg>
                                Rahasia
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="text-center py-12">
                    <div class="w-16 h-16 rounded-2xl bg-slate-100 flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                        </svg>
                    </div>
                    <p class="text-slate-500 text-[15px]">Belum ada permohonan doa</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Tab: Pendaftaran -->
    <div id="tab-pendaftaran" class="bg-white rounded-2xl shadow-admin-md border border-slate-100 p-6 hidden">
        <div class="flex items-center gap-2 mb-6">
            <span class="w-1.5 h-7 bg-[#d4af37] rounded-full"></span>
            <h2 class="text-xl font-bold text-[#1e3a5f]">Daftar Pendaftaran Kegiatan</h2>
        </div>

        <div class="overflow-x-auto rounded-xl border border-slate-200">
            <table class="w-full">
                <thead>
                    <tr class="bg-slate-50">
                        <th class="px-5 py-4 text-left text-[13px] font-semibold text-slate-600 uppercase tracking-wider">
                            Nama</th>
                        <th class="px-5 py-4 text-left text-[13px] font-semibold text-slate-600 uppercase tracking-wider">
                            Telepon</th>
                        <th class="px-5 py-4 text-left text-[13px] font-semibold text-slate-600 uppercase tracking-wider">
                            Kegiatan</th>
                        <th class="px-5 py-4 text-left text-[13px] font-semibold text-slate-600 uppercase tracking-wider">
                            Tanggal Daftar</th>
                        <th class="px-5 py-4 text-left text-[13px] font-semibold text-slate-600 uppercase tracking-wider">
                            Status</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-slate-100">
                    <?php $__empty_1 = true; $__currentLoopData = $pendaftaran; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-slate-50/50 transition-colors duration-150">
                            <td class="px-5 py-4 font-semibold text-slate-800 text-[15px]"><?php echo e($item['nama']); ?></td>
                            <td class="px-5 py-4 text-slate-600 text-[15px]"><?php echo e($item['telepon']); ?></td>
                            <td class="px-5 py-4 text-slate-600 text-[15px]"><?php echo e($item['kegiatan']); ?></td>
                            <td class="px-5 py-4 text-slate-600 text-[15px]"><?php echo e($item['tanggal']); ?></td>
                            <td class="px-5 py-4">
                                <span
                                    class="inline-flex items-center gap-1.5 px-3 py-1.5 rounded-full text-xs font-semibold bg-emerald-100 text-emerald-700">
                                    <span class="w-1.5 h-1.5 rounded-full bg-emerald-500"></span>
                                    Terdaftar
                                </span>
                            </td>
                        </tr>
                        <!-- Notes for Pendaftaran -->
                        <tr class="bg-slate-50/30">
                            <td colspan="5" class="px-5 py-4 border-t border-slate-100">
                                <div class="max-w-3xl">
                                    <div class="flex items-center gap-2 mb-3">
                                        <svg class="w-3.5 h-3.5 text-[#d4af37]" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
                                        </svg>
                                        <span class="text-[11px] font-bold text-slate-500 uppercase">Riwayat Catatan</span>
                                    </div>
                                    <div class="space-y-2 mb-3">
                                        <?php $__empty_2 = true; $__currentLoopData = $item['notes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                            <div
                                                class="flex gap-2 items-start bg-white p-2 rounded-lg border border-slate-100 shadow-sm text-[13px]">
                                                <div class="flex-grow min-w-0">
                                                    <div class="flex items-center justify-between gap-2 mb-0.5">
                                                        <span class="font-bold text-slate-700"><?php echo e($note['user_nama']); ?></span>
                                                        <span class="text-[10px] text-slate-400"><?php echo e($note['waktu']); ?></span>
                                                    </div>
                                                    <p class="text-slate-600"><?php echo e($note['catatan']); ?></p>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                            <p class="text-[11px] text-slate-400 italic">Belum ada catatan.</p>
                                        <?php endif; ?>
                                    </div>
                                    <form action="<?php echo e(route('admin.formulir.pendaftaran.catatan', $item['id'])); ?>" method="POST"
                                        class="flex flex-col gap-2">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PATCH'); ?>
                                        <input type="text" name="catatan" required placeholder="Tambah catatan..."
                                            class="w-full px-3 py-2 bg-white border border-slate-200 rounded-lg text-[13px] focus:border-[#1e3a5f] focus:outline-none">
                                        <div class="flex justify-end">
                                            <button type="submit"
                                                class="px-4 py-1.5 bg-[#1e3a5f] text-white text-[11px] font-bold rounded-lg hover:bg-[#2d5a8a]">SIMPAN</button>
                                        </div>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="py-12 text-center text-slate-500">Belum ada pendaftaran</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Tab: Konseling -->
    <div id="tab-konseling" class="bg-white rounded-2xl shadow-admin-md border border-slate-100 p-6 hidden">
        <div class="flex items-center gap-2 mb-6">
            <span class="w-1.5 h-7 bg-[#d4af37] rounded-full"></span>
            <h2 class="text-xl font-bold text-[#1e3a5f]">Daftar Permohonan Konseling</h2>
        </div>

        <div class="space-y-4">
            <?php $__empty_1 = true; $__currentLoopData = $konseling; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div
                    class="bg-slate-50 rounded-xl p-5 hover:shadow-admin-md transition-all duration-300 border border-slate-100 hover:border-slate-200">
                    <div class="flex flex-col lg:flex-row lg:items-start lg:justify-between gap-4">
                        <div class="flex items-start gap-4 flex-grow">
                            <div
                                class="w-12 h-12 rounded-xl bg-gradient-to-br from-blue-100 to-blue-50 flex items-center justify-center flex-shrink-0 shadow-admin-sm">
                                <svg class="w-6 h-6 text-[#1e3a5f]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                        d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z" />
                                </svg>
                            </div>
                            <div class="flex-grow">
                                <h3 class="font-bold text-[#1e3a5f] text-lg"><?php echo e($item['nama']); ?></h3>
                                <p class="text-sm text-slate-500 mb-2"><?php echo e($item['telepon']); ?> &bull; <?php echo e($item['kategori']); ?></p>
                                <p class="text-slate-600 text-[15px] leading-relaxed mb-3"><?php echo e($item['gambaran']); ?></p>
                                <div class="flex flex-wrap gap-4 text-sm text-slate-500">
                                    <span class="inline-flex items-center gap-1.5">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                        </svg>
                                        <?php echo e($item['metode']); ?>

                                    </span>
                                    <span class="inline-flex items-center gap-1.5">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                        </svg>
                                        <?php echo e($item['waktu']); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="flex flex-col items-end gap-3">
                            <span
                                class="inline-flex items-center gap-1.5 px-3 py-1.5 rounded-full text-xs font-semibold
                                                                <?php echo e($item['status'] == 'pending' ? 'bg-amber-100 text-amber-700' : 'bg-emerald-100 text-emerald-700'); ?>">
                                <span
                                    class="w-1.5 h-1.5 rounded-full <?php echo e($item['status'] == 'pending' ? 'bg-amber-500' : 'bg-emerald-500'); ?>"></span>
                                <?php echo e(ucfirst($item['status'])); ?>

                            </span>
                            <div class="flex gap-2">
                                <?php if($item['status'] == 'pending'): ?>
                                    <a href="<?php echo e(route('admin.formulir.konseling.status', ['id' => $item['id'], 'status' => 'konfirmasi'])); ?>"
                                        class="inline-flex items-center gap-2 px-5 py-2.5 bg-[#1e3a5f] text-white rounded-xl text-sm font-semibold hover:bg-[#2d5a8a] transition-all duration-200 shadow-admin-sm hover:shadow-admin-md">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                        </svg>
                                        Jadwalkan
                                    </a>
                                <?php endif; ?>
                                <form action="<?php echo e(route('admin.formulir.konseling.delete', $item['id'])); ?>" method="POST"
                                    onsubmit="return confirm('Yakin ingin menghapus permohonan konseling ini?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit"
                                        class="p-2.5 bg-red-50 text-red-600 rounded-xl hover:bg-red-100 transition-colors">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-4v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                        </svg>
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- Catatan Rohani History -->
                    <div class="mt-5 pt-5 border-t border-slate-200">
                        <div class="flex items-center gap-2 mb-4">
                            <svg class="w-4 h-4 text-[#d4af37]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
                            </svg>
                            <h4 class="text-sm font-bold text-slate-700 uppercase tracking-wider">Riwayat Catatan Rohani</h4>
                        </div>

                        <div class="space-y-3 mb-4">
                            <?php $__empty_2 = true; $__currentLoopData = $item['notes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                <div class="flex gap-3 items-start bg-white/50 p-3 rounded-xl border border-slate-100">
                                    <div
                                        class="w-8 h-8 rounded-full bg-[#1e3a5f]/10 flex items-center justify-center flex-shrink-0">
                                        <span
                                            class="text-[10px] font-bold text-[#1e3a5f]"><?php echo e(strtoupper(substr($note['user_nama'], 0, 1))); ?></span>
                                    </div>
                                    <div class="flex-grow min-w-0">
                                        <div class="flex items-center justify-between gap-2 mb-1">
                                            <span class="text-xs font-bold text-slate-800"><?php echo e($note['user_nama']); ?> <span
                                                    class="text-[10px] font-medium text-slate-400">(<?php echo e(ucfirst($note['user_role'])); ?>)</span></span>
                                            <span class="text-[10px] text-slate-400"><?php echo e($note['waktu']); ?></span>
                                        </div>
                                        <p class="text-[13px] text-slate-600 leading-relaxed"><?php echo e($note['catatan']); ?></p>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                <div class="text-center py-4 bg-slate-50 rounded-xl border border-dashed border-slate-200">
                                    <p class="text-xs text-slate-400">Belum ada catatan spiritual.</p>
                                </div>
                            <?php endif; ?>
                        </div>

                        <form action="<?php echo e(route('admin.formulir.konseling.catatan', $item['id'])); ?>" method="POST" class="mt-4">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PATCH'); ?>
                            <div class="flex flex-col gap-2">
                                <textarea name="catatan" rows="2" required
                                    class="w-full px-4 py-3 bg-white border border-slate-200 rounded-xl text-[14px] text-slate-600 focus:border-[#1e3a5f] focus:ring-0 focus:outline-none transition-all duration-200"
                                    placeholder="Tambahkan catatan spiritual baru..."></textarea>
                                <div class="flex justify-end">
                                    <button type="submit"
                                        class="px-5 py-2 bg-[#1e3a5f] text-white text-[12px] font-bold rounded-xl hover:bg-[#2d5a8a] transition-all shadow-sm">
                                        SIMPAN CATATAN
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="text-center py-12">
                    <div class="w-16 h-16 rounded-2xl bg-slate-100 flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z" />
                        </svg>
                    </div>
                    <p class="text-slate-500 text-[15px]">Belum ada permohonan konseling</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script>
        function showTab(tabName) {
            // Hide all tabs
            document.querySelectorAll('[id^="tab-"]').forEach(tab => tab.classList.add('hidden'));
            // Reset all buttons
            document.querySelectorAll('.tab-btn').forEach(btn => {
                btn.classList.remove('text-[#1e3a5f]', 'border-[#d4af37]', 'bg-slate-50', 'border-b-3');
                btn.classList.add('text-slate-500');
            });
            // Show selected tab
            document.getElementById('tab-' + tabName).classList.remove('hidden');
            // Activate button
            const activeBtn = document.getElementById('btn-' + tabName);
            activeBtn.classList.remove('text-slate-500');
            activeBtn.classList.add('text-[#1e3a5f]', 'border-[#d4af37]', 'bg-slate-50', 'border-b-3');
        }
    </script>

    <style>
        .border-b-3 {
            border-bottom-width: 3px;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/admin/formulir/index.blade.php ENDPATH**/ ?>